/*
 * Decompiled with CFR 0.152.
 */
package org.probatron.officeotron;

import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.probatron.officeotron.ValidationReport;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CommentatingErrorHandler
implements ErrorHandler {
    private ValidationReport commentary;
    static Logger logger = Logger.getLogger(CommentatingErrorHandler.class);
    private int instanceErrCount;
    public static final int THRESHOLD = 10;
    private String fragmentName;

    public CommentatingErrorHandler(ValidationReport validationReport, String string) {
        this.commentary = validationReport;
        this.fragmentName = string;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.instanceErrCount < 10) {
            String string = this.fragmentName;
            if (sAXParseException.getSystemId() != null && !sAXParseException.getSystemId().endsWith(this.fragmentName)) {
                string = sAXParseException.getSystemId();
            }
            String string2 = MessageFormat.format("({0}:{1} col:{2}) {3}", string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage());
            this.commentary.addComment("ERROR", string2);
        }
        this.commentary.incErrs();
        ++this.instanceErrCount;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.debug("Fatal Error: " + sAXParseException.getMessage());
        this.commentary.addComment("ERROR", sAXParseException.getMessage());
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        logger.debug("Warning: " + sAXParseException.getMessage());
        this.commentary.addComment("WARN", sAXParseException.getMessage());
    }

    public int getInstanceErrCount() {
        return this.instanceErrCount;
    }
}

