// Copyright 2019 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/regexp/regexp-bytecodes.h"

#include <cctype>

#include "src/regexp/regexp-bytecodes-inl.h"
#include "src/utils/utils.h"

namespace v8 {
namespace internal {

void RegExpBytecodeDisassembleSingle(const uint8_t* code_base,
                                     const uint8_t* pc) {
  // TODO(jgruber): Now that we know about operand types, improve printing.
  RegExpBytecode bytecode = RegExpBytecodes::FromPtr(pc);
  PrintF("%s", RegExpBytecodes::Name(bytecode));

  // Args and the bytecode as hex.
  for (int i = 0; i < RegExpBytecodes::Size(bytecode); i++) {
    PrintF(", %02x", pc[i]);
  }
  PrintF(" ");

  // Args as ascii.
  for (int i = 1; i < RegExpBytecodes::Size(bytecode); i++) {
    unsigned char b = pc[i];
    PrintF("%c", std::isprint(b) ? b : '.');
  }
  PrintF("\n");
}

void RegExpBytecodeDisassemble(const uint8_t* code_base, int length,
                               const char* pattern) {
  PrintF("[generated bytecode for regexp pattern: '%s']\n", pattern);

  ptrdiff_t offset = 0;

  // TODO(pthier): Consider using the RegExpBytecodeIterator.
  while (offset < length) {
    const uint8_t* const pc = code_base + offset;
    PrintF("%p  %4" V8PRIxPTRDIFF "  ", pc, offset);
    RegExpBytecodeDisassembleSingle(code_base, pc);
    offset += RegExpBytecodes::Size(RegExpBytecodes::FromPtr(pc));
  }
}

}  // namespace internal
}  // namespace v8
