#!/bin/bash
set -e

# Clean up
rm -rf gen_temp gen
mkdir -p gen_temp

# Download artifacts
gh run download 21040538462 -p "src_binding_*.rs" -D gen_temp

# Flatten directory structure
mkdir -p gen
for dir in gen_temp/*/; do
  if [ -d "$dir" ]; then
    for file in "$dir"*.rs; do
      if [ -f "$file" ]; then
        cp "$file" gen/
      fi
    done
  fi
done

# Clean up temp
rm -rf gen_temp

echo "Downloaded binding files:"
ls -1 gen/

echo ""
echo "Ready to publish. Run: cargo publish -vv --locked --allow-dirty"
