/* automatically generated by rust-bindgen 0.72.0 */

#[doc = " Base class for managed objects. Only descendent types of `GarbageCollected`\n can be constructed using `MakeGarbageCollected()`. Must be inherited from as\n left-most base class.\n\n Types inheriting from GarbageCollected must provide a method of\n signature `void Trace(cppgc::Visitor*) const` that dispatchs all managed\n pointers to the visitor and delegates to garbage-collected base classes.\n The method must be virtual if the type is not directly a child of\n GarbageCollected and marked as final.\n\n \\code\n // Example using final class.\n class FinalType final : public GarbageCollected<FinalType> {\n  public:\n   void Trace(cppgc::Visitor* visitor) const {\n     // Dispatch using visitor->Trace(...);\n   }\n };\n\n // Example using non-final base class.\n class NonFinalBase : public GarbageCollected<NonFinalBase> {\n  public:\n   virtual void Trace(cppgc::Visitor*) const {}\n };\n\n class FinalChild final : public NonFinalBase {\n  public:\n   void Trace(cppgc::Visitor* visitor) const final {\n     // Dispatch using visitor->Trace(...);\n     NonFinalBase::Trace(visitor);\n   }\n };\n \\endcode"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cppgc_GarbageCollected {
  pub _address: u8,
}
pub type cppgc_GarbageCollected_IsGarbageCollectedTypeMarker =
  ::std::os::raw::c_void;
pub type cppgc_GarbageCollected_ParentMostGarbageCollectedType<T> = T;
#[repr(C)]
pub struct cppgc_Visitor__bindgen_vtable(::std::os::raw::c_void);
#[doc = " Visitor passed to trace methods. All managed pointers must have called the\n Visitor's trace method on them.\n\n \\code\n class Foo final : public GarbageCollected<Foo> {\n  public:\n   void Trace(Visitor* visitor) const {\n     visitor->Trace(foo_);\n     visitor->Trace(weak_foo_);\n   }\n  private:\n   Member<Foo> foo_;\n   WeakMember<Foo> weak_foo_;\n };\n \\endcode"]
#[repr(C)]
#[derive(Debug)]
pub struct cppgc_Visitor {
  pub vtable_: *const cppgc_Visitor__bindgen_vtable,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cppgc_Visitor_Key {
  pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of cppgc_Visitor_Key"]
    [::std::mem::size_of::<cppgc_Visitor_Key>() - 1usize];
  ["Alignment of cppgc_Visitor_Key"]
    [::std::mem::align_of::<cppgc_Visitor_Key>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of cppgc_Visitor"][::std::mem::size_of::<cppgc_Visitor>() - 8usize];
  ["Alignment of cppgc_Visitor"]
    [::std::mem::align_of::<cppgc_Visitor>() - 8usize];
};
#[repr(C)]
pub struct cppgc_NameProvider__bindgen_vtable(::std::os::raw::c_void);
#[doc = " NameProvider allows for providing a human-readable name for garbage-collected\n objects.\n\n There's two cases of names to distinguish:\n a. Explicitly specified names via using NameProvider. Such names are always\n    preserved in the system.\n b. Internal names that Oilpan infers from a C++ type on the class hierarchy\n    of the object. This is not necessarily the type of the actually\n    instantiated object.\n\n Depending on the build configuration, Oilpan may hide names, i.e., represent\n them with kHiddenName, of case b. to avoid exposing internal details."]
#[repr(C)]
#[derive(Debug)]
pub struct cppgc_NameProvider {
  pub vtable_: *const cppgc_NameProvider__bindgen_vtable,
}
#[doc = " Name that is used when hiding internals."]
pub const cppgc_NameProvider_kHiddenName: &::std::ffi::CStr = c"InternalNode";
#[doc = " Name that is used in case compiler support is missing for composing a name\n from C++ types."]
pub const cppgc_NameProvider_kNoNameDeducible: &::std::ffi::CStr = c"<No name>";
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of cppgc_NameProvider"]
    [::std::mem::size_of::<cppgc_NameProvider>() - 8usize];
  ["Alignment of cppgc_NameProvider"]
    [::std::mem::align_of::<cppgc_NameProvider>() - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_String_WriteFlags {
  pub _address: u8,
}
pub const v8_String_WriteFlags_kNone: v8_String_WriteFlags__bindgen_ty_1 = 0;
pub const v8_String_WriteFlags_kNullTerminate:
  v8_String_WriteFlags__bindgen_ty_1 = 1;
pub const v8_String_WriteFlags_kReplaceInvalidUtf8:
  v8_String_WriteFlags__bindgen_ty_1 = 2;
pub type v8_String_WriteFlags__bindgen_ty_1 = ::std::os::raw::c_int;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_String_WriteFlags"]
    [::std::mem::size_of::<v8_String_WriteFlags>() - 1usize];
  ["Alignment of v8_String_WriteFlags"]
    [::std::mem::align_of::<v8_String_WriteFlags>() - 1usize];
};
#[repr(C)]
pub struct v8_String_ExternalStringResourceBase__bindgen_vtable(
  ::std::os::raw::c_void,
);
#[repr(C)]
#[derive(Debug)]
pub struct v8_String_ExternalStringResourceBase {
  pub vtable_: *const v8_String_ExternalStringResourceBase__bindgen_vtable,
}
#[repr(C)]
pub struct v8_String_ExternalStringResourceBase_SharedMemoryUsageRecorder__bindgen_vtable(
  ::std::os::raw::c_void,
);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_String_ExternalStringResourceBase_SharedMemoryUsageRecorder { pub vtable_ : * const v8_String_ExternalStringResourceBase_SharedMemoryUsageRecorder__bindgen_vtable , }
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_String_ExternalStringResourceBase_SharedMemoryUsageRecorder"]
    [::std::mem::size_of::<
      v8_String_ExternalStringResourceBase_SharedMemoryUsageRecorder,
    >()
      - 8usize];
  [
    "Alignment of v8_String_ExternalStringResourceBase_SharedMemoryUsageRecorder",
  ][::std::mem::align_of::<
    v8_String_ExternalStringResourceBase_SharedMemoryUsageRecorder,
  >()
    - 8usize];
};
unsafe extern "C" {
  #[link_name = "\u{1}?kDefaultMemoryEstimate@ExternalStringResourceBase@String@v8@@2_KB"]
  pub static v8_String_ExternalStringResourceBase_kDefaultMemoryEstimate: usize;
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_String_ExternalStringResourceBase"]
    [::std::mem::size_of::<v8_String_ExternalStringResourceBase>() - 8usize];
  ["Alignment of v8_String_ExternalStringResourceBase"]
    [::std::mem::align_of::<v8_String_ExternalStringResourceBase>() - 8usize];
};
#[doc = " An ExternalOneByteStringResource is a wrapper around an one-byte\n string buffer that resides outside V8's heap. Implement an\n ExternalOneByteStringResource to manage the life cycle of the\n underlying buffer.  Note that the string data must be immutable\n and that the data must be Latin-1 and not UTF-8, which would require\n special treatment internally in the engine and do not allow efficient\n indexing.  Use String::New or convert to 16 bit data for non-Latin1."]
#[repr(C)]
#[derive(Debug)]
pub struct v8_String_ExternalOneByteStringResource {
  pub _base: v8_String_ExternalStringResourceBase,
  pub cached_data_: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_String_ExternalOneByteStringResource"][::std::mem::size_of::<
    v8_String_ExternalOneByteStringResource,
  >()
    - 16usize];
  ["Alignment of v8_String_ExternalOneByteStringResource"][::std::mem::align_of::<
    v8_String_ExternalOneByteStringResource,
  >() - 8usize];
  ["Offset of field: v8_String_ExternalOneByteStringResource::cached_data_"][::std::mem::offset_of!(
    v8_String_ExternalOneByteStringResource,
    cached_data_
  )
    - 8usize];
};
unsafe extern "C" {
  #[doc = " Update {cached_data_} with the data from the underlying buffer. This can\n be called only for cacheable resources."]
  #[link_name = "\u{1}?UpdateDataCache@ExternalOneByteStringResource@String@v8@@QEAAXXZ"]
  pub fn v8_String_ExternalOneByteStringResource_UpdateDataCache(
    this: *mut v8_String_ExternalOneByteStringResource,
  );
}
impl v8_String_ExternalOneByteStringResource {
  #[inline]
  pub unsafe fn UpdateDataCache(&mut self) {
    v8_String_ExternalOneByteStringResource_UpdateDataCache(self)
  }
}
#[repr(C)]
#[derive(Debug)]
pub struct v8_Object_Wrappable {
  pub _base_1: cppgc_NameProvider,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_Object_Wrappable"]
    [::std::mem::size_of::<v8_Object_Wrappable>() - 8usize];
  ["Alignment of v8_Object_Wrappable"]
    [::std::mem::align_of::<v8_Object_Wrappable>() - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_CTypeInfo {
  pub type_: v8_CTypeInfo_Type,
  pub flags_: v8_CTypeInfo_Flags,
}
pub const v8_CTypeInfo_Type_kVoid: v8_CTypeInfo_Type = 0;
pub const v8_CTypeInfo_Type_kBool: v8_CTypeInfo_Type = 1;
pub const v8_CTypeInfo_Type_kUint8: v8_CTypeInfo_Type = 2;
pub const v8_CTypeInfo_Type_kInt32: v8_CTypeInfo_Type = 3;
pub const v8_CTypeInfo_Type_kUint32: v8_CTypeInfo_Type = 4;
pub const v8_CTypeInfo_Type_kInt64: v8_CTypeInfo_Type = 5;
pub const v8_CTypeInfo_Type_kUint64: v8_CTypeInfo_Type = 6;
pub const v8_CTypeInfo_Type_kFloat32: v8_CTypeInfo_Type = 7;
pub const v8_CTypeInfo_Type_kFloat64: v8_CTypeInfo_Type = 8;
pub const v8_CTypeInfo_Type_kPointer: v8_CTypeInfo_Type = 9;
pub const v8_CTypeInfo_Type_kV8Value: v8_CTypeInfo_Type = 10;
pub const v8_CTypeInfo_Type_kSeqOneByteString: v8_CTypeInfo_Type = 11;
pub const v8_CTypeInfo_Type_kApiObject: v8_CTypeInfo_Type = 12;
pub const v8_CTypeInfo_Type_kAny: v8_CTypeInfo_Type = 13;
pub type v8_CTypeInfo_Type = u8;
pub const v8_CTypeInfo_Flags_kNone: v8_CTypeInfo_Flags = 0;
pub const v8_CTypeInfo_Flags_kAllowSharedBit: v8_CTypeInfo_Flags = 1;
pub const v8_CTypeInfo_Flags_kEnforceRangeBit: v8_CTypeInfo_Flags = 2;
pub const v8_CTypeInfo_Flags_kClampBit: v8_CTypeInfo_Flags = 4;
pub const v8_CTypeInfo_Flags_kIsRestrictedBit: v8_CTypeInfo_Flags = 8;
pub type v8_CTypeInfo_Flags = u8;
pub type v8_CTypeInfo_Identifier = u32;
unsafe extern "C" {
  #[link_name = "\u{1}?kCallbackOptionsType@CTypeInfo@v8@@2W4Type@12@B"]
  pub static v8_CTypeInfo_kCallbackOptionsType: v8_CTypeInfo_Type;
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_CTypeInfo"][::std::mem::size_of::<v8_CTypeInfo>() - 2usize];
  ["Alignment of v8_CTypeInfo"]
    [::std::mem::align_of::<v8_CTypeInfo>() - 1usize];
  ["Offset of field: v8_CTypeInfo::type_"]
    [::std::mem::offset_of!(v8_CTypeInfo, type_) - 0usize];
  ["Offset of field: v8_CTypeInfo::flags_"]
    [::std::mem::offset_of!(v8_CTypeInfo, flags_) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_FastOneByteString {
  pub data: *const ::std::os::raw::c_char,
  pub length: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_FastOneByteString"]
    [::std::mem::size_of::<v8_FastOneByteString>() - 16usize];
  ["Alignment of v8_FastOneByteString"]
    [::std::mem::align_of::<v8_FastOneByteString>() - 8usize];
  ["Offset of field: v8_FastOneByteString::data"]
    [::std::mem::offset_of!(v8_FastOneByteString, data) - 0usize];
  ["Offset of field: v8_FastOneByteString::length"]
    [::std::mem::offset_of!(v8_FastOneByteString, length) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_CFunctionInfo {
  pub return_info_: v8_CTypeInfo,
  pub repr_: v8_CFunctionInfo_Int64Representation,
  pub arg_count_: ::std::os::raw::c_uint,
  pub arg_info_: *const v8_CTypeInfo,
}
pub const v8_CFunctionInfo_Int64Representation_kNumber:
  v8_CFunctionInfo_Int64Representation = 0;
pub const v8_CFunctionInfo_Int64Representation_kBigInt:
  v8_CFunctionInfo_Int64Representation = 1;
pub type v8_CFunctionInfo_Int64Representation = u8;
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_CFunctionInfo"]
    [::std::mem::size_of::<v8_CFunctionInfo>() - 16usize];
  ["Alignment of v8_CFunctionInfo"]
    [::std::mem::align_of::<v8_CFunctionInfo>() - 8usize];
  ["Offset of field: v8_CFunctionInfo::return_info_"]
    [::std::mem::offset_of!(v8_CFunctionInfo, return_info_) - 0usize];
  ["Offset of field: v8_CFunctionInfo::repr_"]
    [::std::mem::offset_of!(v8_CFunctionInfo, repr_) - 2usize];
  ["Offset of field: v8_CFunctionInfo::arg_count_"]
    [::std::mem::offset_of!(v8_CFunctionInfo, arg_count_) - 4usize];
  ["Offset of field: v8_CFunctionInfo::arg_info_"]
    [::std::mem::offset_of!(v8_CFunctionInfo, arg_info_) - 8usize];
};
unsafe extern "C" {
  #[link_name = "\u{1}?ArgumentInfo@CFunctionInfo@v8@@QEBAAEBVCTypeInfo@2@I@Z"]
  pub fn v8_CFunctionInfo_ArgumentInfo(
    this: *const v8_CFunctionInfo,
    index: ::std::os::raw::c_uint,
  ) -> *const v8_CTypeInfo;
}
unsafe extern "C" {
  #[link_name = "\u{1}??0CFunctionInfo@v8@@QEAA@AEBVCTypeInfo@1@IPEBV21@W4Int64Representation@01@@Z"]
  pub fn v8_CFunctionInfo_CFunctionInfo(
    this: *mut v8_CFunctionInfo,
    return_info: *const v8_CTypeInfo,
    arg_count: ::std::os::raw::c_uint,
    arg_info: *const v8_CTypeInfo,
    repr: v8_CFunctionInfo_Int64Representation,
  );
}
impl v8_CFunctionInfo {
  #[inline]
  pub unsafe fn ArgumentInfo(
    &self,
    index: ::std::os::raw::c_uint,
  ) -> *const v8_CTypeInfo {
    v8_CFunctionInfo_ArgumentInfo(self, index)
  }
  #[inline]
  pub unsafe fn new(
    return_info: *const v8_CTypeInfo,
    arg_count: ::std::os::raw::c_uint,
    arg_info: *const v8_CTypeInfo,
    repr: v8_CFunctionInfo_Int64Representation,
  ) -> Self {
    let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
    v8_CFunctionInfo_CFunctionInfo(
      __bindgen_tmp.as_mut_ptr(),
      return_info,
      arg_count,
      arg_info,
      repr,
    );
    __bindgen_tmp.assume_init()
  }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_CFunction {
  pub address_: *const ::std::os::raw::c_void,
  pub type_info_: *const v8_CFunctionInfo,
}
pub const v8_CFunction_OverloadResolution_kImpossible:
  v8_CFunction_OverloadResolution = 0;
pub const v8_CFunction_OverloadResolution_kAtRuntime:
  v8_CFunction_OverloadResolution = 1;
pub const v8_CFunction_OverloadResolution_kAtCompileTime:
  v8_CFunction_OverloadResolution = 2;
pub type v8_CFunction_OverloadResolution = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_CFunction_ArgUnwrap {
  pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_CFunction"][::std::mem::size_of::<v8_CFunction>() - 16usize];
  ["Alignment of v8_CFunction"]
    [::std::mem::align_of::<v8_CFunction>() - 8usize];
  ["Offset of field: v8_CFunction::address_"]
    [::std::mem::offset_of!(v8_CFunction, address_) - 0usize];
  ["Offset of field: v8_CFunction::type_info_"]
    [::std::mem::offset_of!(v8_CFunction, type_info_) - 8usize];
};
unsafe extern "C" {
  #[link_name = "\u{1}??0CFunction@v8@@QEAA@PEBXPEBVCFunctionInfo@1@@Z"]
  pub fn v8_CFunction_CFunction(
    this: *mut v8_CFunction,
    address: *const ::std::os::raw::c_void,
    type_info: *const v8_CFunctionInfo,
  );
}
impl v8_CFunction {
  #[inline]
  pub unsafe fn new(
    address: *const ::std::os::raw::c_void,
    type_info: *const v8_CFunctionInfo,
  ) -> Self {
    let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
    v8_CFunction_CFunction(__bindgen_tmp.as_mut_ptr(), address, type_info);
    __bindgen_tmp.assume_init()
  }
}
impl v8_GCType {
  pub const kGCTypeScavenge: v8_GCType = v8_GCType(1);
  pub const kGCTypeMinorMarkSweep: v8_GCType = v8_GCType(2);
  pub const kGCTypeMarkSweepCompact: v8_GCType = v8_GCType(4);
  pub const kGCTypeIncrementalMarking: v8_GCType = v8_GCType(8);
  pub const kGCTypeProcessWeakCallbacks: v8_GCType = v8_GCType(16);
  pub const kGCTypeAll: v8_GCType = v8_GCType(31);
}
impl ::std::ops::BitOr<v8_GCType> for v8_GCType {
  type Output = Self;
  #[inline]
  fn bitor(self, other: Self) -> Self {
    v8_GCType(self.0 | other.0)
  }
}
impl ::std::ops::BitOrAssign for v8_GCType {
  #[inline]
  fn bitor_assign(&mut self, rhs: v8_GCType) {
    self.0 |= rhs.0;
  }
}
impl ::std::ops::BitAnd<v8_GCType> for v8_GCType {
  type Output = Self;
  #[inline]
  fn bitand(self, other: Self) -> Self {
    v8_GCType(self.0 & other.0)
  }
}
impl ::std::ops::BitAndAssign for v8_GCType {
  #[inline]
  fn bitand_assign(&mut self, rhs: v8_GCType) {
    self.0 &= rhs.0;
  }
}
#[repr(transparent)]
#[doc = " Applications can register callback functions which will be called before and\n after certain garbage collection operations.  Allocations are not allowed in\n the callback functions, you therefore cannot manipulate objects (set or\n delete properties for example) since it is possible such operations will\n result in the allocation of objects.\n TODO(v8:12612): Deprecate kGCTypeMinorMarkSweep after updating blink."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct v8_GCType(pub ::std::os::raw::c_int);
impl v8_GCCallbackFlags {
  pub const kNoGCCallbackFlags: v8_GCCallbackFlags = v8_GCCallbackFlags(0);
  pub const kGCCallbackFlagConstructRetainedObjectInfos: v8_GCCallbackFlags =
    v8_GCCallbackFlags(2);
  pub const kGCCallbackFlagForced: v8_GCCallbackFlags = v8_GCCallbackFlags(4);
  pub const kGCCallbackFlagSynchronousPhantomCallbackProcessing:
    v8_GCCallbackFlags = v8_GCCallbackFlags(8);
  pub const kGCCallbackFlagCollectAllAvailableGarbage: v8_GCCallbackFlags =
    v8_GCCallbackFlags(16);
  pub const kGCCallbackFlagCollectAllExternalMemory: v8_GCCallbackFlags =
    v8_GCCallbackFlags(32);
  pub const kGCCallbackScheduleIdleGarbageCollection: v8_GCCallbackFlags =
    v8_GCCallbackFlags(64);
  pub const kGCCallbackFlagLastResort: v8_GCCallbackFlags =
    v8_GCCallbackFlags(128);
}
impl ::std::ops::BitOr<v8_GCCallbackFlags> for v8_GCCallbackFlags {
  type Output = Self;
  #[inline]
  fn bitor(self, other: Self) -> Self {
    v8_GCCallbackFlags(self.0 | other.0)
  }
}
impl ::std::ops::BitOrAssign for v8_GCCallbackFlags {
  #[inline]
  fn bitor_assign(&mut self, rhs: v8_GCCallbackFlags) {
    self.0 |= rhs.0;
  }
}
impl ::std::ops::BitAnd<v8_GCCallbackFlags> for v8_GCCallbackFlags {
  type Output = Self;
  #[inline]
  fn bitand(self, other: Self) -> Self {
    v8_GCCallbackFlags(self.0 & other.0)
  }
}
impl ::std::ops::BitAndAssign for v8_GCCallbackFlags {
  #[inline]
  fn bitand_assign(&mut self, rhs: v8_GCCallbackFlags) {
    self.0 &= rhs.0;
  }
}
#[repr(transparent)]
#[doc = " GCCallbackFlags is used to notify additional information about the GC\n callback.\n   - kGCCallbackFlagConstructRetainedObjectInfos: The GC callback is for\n     constructing retained object infos.\n   - kGCCallbackFlagForced: The GC callback is for a forced GC for testing.\n   - kGCCallbackFlagSynchronousPhantomCallbackProcessing: The GC callback\n     is called synchronously without getting posted to an idle task.\n   - kGCCallbackFlagCollectAllAvailableGarbage: The GC callback is called\n     in a phase where V8 is trying to collect all available garbage\n     (e.g., handling a low memory notification).\n   - kGCCallbackScheduleIdleGarbageCollection: The GC callback is called to\n     trigger an idle garbage collection."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct v8_GCCallbackFlags(pub ::std::os::raw::c_int);
#[repr(i32)]
#[doc = " Import phases in import requests."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum v8_ModuleImportPhase {
  kSource = 0,
  kDefer = 1,
  kEvaluation = 2,
}
#[doc = " Collection of V8 heap information.\n\n Instances of this class can be passed to v8::Isolate::GetHeapStatistics to\n get heap statistics from V8."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_HeapStatistics {
  pub total_heap_size_: usize,
  pub total_heap_size_executable_: usize,
  pub total_physical_size_: usize,
  pub total_available_size_: usize,
  pub used_heap_size_: usize,
  pub heap_size_limit_: usize,
  pub malloced_memory_: usize,
  pub external_memory_: usize,
  pub peak_malloced_memory_: usize,
  pub does_zap_garbage_: bool,
  pub number_of_native_contexts_: usize,
  pub number_of_detached_contexts_: usize,
  pub total_global_handles_size_: usize,
  pub used_global_handles_size_: usize,
  pub total_allocated_bytes_: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_HeapStatistics"]
    [::std::mem::size_of::<v8_HeapStatistics>() - 120usize];
  ["Alignment of v8_HeapStatistics"]
    [::std::mem::align_of::<v8_HeapStatistics>() - 8usize];
  ["Offset of field: v8_HeapStatistics::total_heap_size_"]
    [::std::mem::offset_of!(v8_HeapStatistics, total_heap_size_) - 0usize];
  ["Offset of field: v8_HeapStatistics::total_heap_size_executable_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    total_heap_size_executable_
  )
    - 8usize];
  ["Offset of field: v8_HeapStatistics::total_physical_size_"]
    [::std::mem::offset_of!(v8_HeapStatistics, total_physical_size_) - 16usize];
  ["Offset of field: v8_HeapStatistics::total_available_size_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    total_available_size_
  ) - 24usize];
  ["Offset of field: v8_HeapStatistics::used_heap_size_"]
    [::std::mem::offset_of!(v8_HeapStatistics, used_heap_size_) - 32usize];
  ["Offset of field: v8_HeapStatistics::heap_size_limit_"]
    [::std::mem::offset_of!(v8_HeapStatistics, heap_size_limit_) - 40usize];
  ["Offset of field: v8_HeapStatistics::malloced_memory_"]
    [::std::mem::offset_of!(v8_HeapStatistics, malloced_memory_) - 48usize];
  ["Offset of field: v8_HeapStatistics::external_memory_"]
    [::std::mem::offset_of!(v8_HeapStatistics, external_memory_) - 56usize];
  ["Offset of field: v8_HeapStatistics::peak_malloced_memory_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    peak_malloced_memory_
  ) - 64usize];
  ["Offset of field: v8_HeapStatistics::does_zap_garbage_"]
    [::std::mem::offset_of!(v8_HeapStatistics, does_zap_garbage_) - 72usize];
  ["Offset of field: v8_HeapStatistics::number_of_native_contexts_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    number_of_native_contexts_
  )
    - 80usize];
  ["Offset of field: v8_HeapStatistics::number_of_detached_contexts_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    number_of_detached_contexts_
  )
    - 88usize];
  ["Offset of field: v8_HeapStatistics::total_global_handles_size_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    total_global_handles_size_
  )
    - 96usize];
  ["Offset of field: v8_HeapStatistics::used_global_handles_size_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    used_global_handles_size_
  )
    - 104usize];
  ["Offset of field: v8_HeapStatistics::total_allocated_bytes_"][::std::mem::offset_of!(
    v8_HeapStatistics,
    total_allocated_bytes_
  ) - 112usize];
};
unsafe extern "C" {
  #[link_name = "\u{1}??0HeapStatistics@v8@@QEAA@XZ"]
  pub fn v8_HeapStatistics_HeapStatistics(this: *mut v8_HeapStatistics);
}
impl v8_HeapStatistics {
  #[inline]
  pub unsafe fn new() -> Self {
    let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
    v8_HeapStatistics_HeapStatistics(__bindgen_tmp.as_mut_ptr());
    __bindgen_tmp.assume_init()
  }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct v8_HeapSpaceStatistics {
  pub space_name_: *const ::std::os::raw::c_char,
  pub space_size_: usize,
  pub space_used_size_: usize,
  pub space_available_size_: usize,
  pub physical_space_size_: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of v8_HeapSpaceStatistics"]
    [::std::mem::size_of::<v8_HeapSpaceStatistics>() - 40usize];
  ["Alignment of v8_HeapSpaceStatistics"]
    [::std::mem::align_of::<v8_HeapSpaceStatistics>() - 8usize];
  ["Offset of field: v8_HeapSpaceStatistics::space_name_"]
    [::std::mem::offset_of!(v8_HeapSpaceStatistics, space_name_) - 0usize];
  ["Offset of field: v8_HeapSpaceStatistics::space_size_"]
    [::std::mem::offset_of!(v8_HeapSpaceStatistics, space_size_) - 8usize];
  ["Offset of field: v8_HeapSpaceStatistics::space_used_size_"][::std::mem::offset_of!(
    v8_HeapSpaceStatistics,
    space_used_size_
  ) - 16usize];
  ["Offset of field: v8_HeapSpaceStatistics::space_available_size_"][::std::mem::offset_of!(
    v8_HeapSpaceStatistics,
    space_available_size_
  )
    - 24usize];
  ["Offset of field: v8_HeapSpaceStatistics::physical_space_size_"][::std::mem::offset_of!(
    v8_HeapSpaceStatistics,
    physical_space_size_
  )
    - 32usize];
};
unsafe extern "C" {
  #[link_name = "\u{1}??0HeapSpaceStatistics@v8@@QEAA@XZ"]
  pub fn v8_HeapSpaceStatistics_HeapSpaceStatistics(
    this: *mut v8_HeapSpaceStatistics,
  );
}
impl v8_HeapSpaceStatistics {
  #[inline]
  pub unsafe fn new() -> Self {
    let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
    v8_HeapSpaceStatistics_HeapSpaceStatistics(__bindgen_tmp.as_mut_ptr());
    __bindgen_tmp.assume_init()
  }
}
#[repr(i32)]
#[doc = " Features reported via the SetUseCounterCallback callback. Do not change\n assigned numbers of existing items; add new features to the end of this\n list.\n Dead features can be marked `V8_DEPRECATE_SOON`, then `V8_DEPRECATED`, and\n then finally be renamed to `kOBSOLETE_...` to stop embedders from using\n them."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum v8_Isolate_UseCounterFeature {
  kUseAsm = 0,
  kBreakIterator = 1,
  kOBSOLETE_LegacyConst = 2,
  kOBSOLETE_MarkDequeOverflow = 3,
  kOBSOLETE_StoreBufferOverflow = 4,
  kOBSOLETE_SlotsBufferOverflow = 5,
  kOBSOLETE_ObjectObserve = 6,
  kForcedGC = 7,
  kSloppyMode = 8,
  kStrictMode = 9,
  kOBSOLETE_StrongMode = 10,
  kRegExpPrototypeStickyGetter = 11,
  kRegExpPrototypeToString = 12,
  kRegExpPrototypeUnicodeGetter = 13,
  kOBSOLETE_IntlV8Parse = 14,
  kOBSOLETE_IntlPattern = 15,
  kOBSOLETE_IntlResolved = 16,
  kOBSOLETE_PromiseChain = 17,
  kOBSOLETE_PromiseAccept = 18,
  kOBSOLETE_PromiseDefer = 19,
  kHtmlCommentInExternalScript = 20,
  kHtmlComment = 21,
  kSloppyModeBlockScopedFunctionRedefinition = 22,
  kForInInitializer = 23,
  kOBSOLETE_ArrayProtectorDirtied = 24,
  kArraySpeciesModified = 25,
  kArrayPrototypeConstructorModified = 26,
  kOBSOLETE_ArrayInstanceProtoModified = 27,
  kArrayInstanceConstructorModified = 28,
  kOBSOLETE_LegacyFunctionDeclaration = 29,
  kOBSOLETE_RegExpPrototypeSourceGetter = 30,
  kOBSOLETE_RegExpPrototypeOldFlagGetter = 31,
  kDecimalWithLeadingZeroInStrictMode = 32,
  kLegacyDateParser = 33,
  kDefineGetterOrSetterWouldThrow = 34,
  kFunctionConstructorReturnedUndefined = 35,
  kAssigmentExpressionLHSIsCallInSloppy = 36,
  kAssigmentExpressionLHSIsCallInStrict = 37,
  kPromiseConstructorReturnedUndefined = 38,
  kOBSOLETE_ConstructorNonUndefinedPrimitiveReturn = 39,
  kOBSOLETE_LabeledExpressionStatement = 40,
  kOBSOLETE_LineOrParagraphSeparatorAsLineTerminator = 41,
  kIndexAccessor = 42,
  kErrorCaptureStackTrace = 43,
  kErrorPrepareStackTrace = 44,
  kErrorStackTraceLimit = 45,
  kWebAssemblyInstantiation = 46,
  kDeoptimizerDisableSpeculation = 47,
  kOBSOLETE_ArrayPrototypeSortJSArrayModifiedPrototype = 48,
  kFunctionTokenOffsetTooLongForToString = 49,
  kWasmSharedMemory = 50,
  kWasmThreadOpcodes = 51,
  kOBSOLETE_AtomicsNotify = 52,
  kOBSOLETE_AtomicsWake = 53,
  kCollator = 54,
  kNumberFormat = 55,
  kDateTimeFormat = 56,
  kPluralRules = 57,
  kRelativeTimeFormat = 58,
  kLocale = 59,
  kListFormat = 60,
  kSegmenter = 61,
  kStringLocaleCompare = 62,
  kOBSOLETE_StringToLocaleUpperCase = 63,
  kStringToLocaleLowerCase = 64,
  kNumberToLocaleString = 65,
  kDateToLocaleString = 66,
  kDateToLocaleDateString = 67,
  kDateToLocaleTimeString = 68,
  kAttemptOverrideReadOnlyOnPrototypeSloppy = 69,
  kAttemptOverrideReadOnlyOnPrototypeStrict = 70,
  kOBSOLETE_OptimizedFunctionWithOneShotBytecode = 71,
  kRegExpMatchIsTrueishOnNonJSRegExp = 72,
  kRegExpMatchIsFalseishOnJSRegExp = 73,
  kOBSOLETE_DateGetTimezoneOffset = 74,
  kStringNormalize = 75,
  kCallSiteAPIGetFunctionSloppyCall = 76,
  kCallSiteAPIGetThisSloppyCall = 77,
  kOBSOLETE_RegExpMatchAllWithNonGlobalRegExp = 78,
  kRegExpExecCalledOnSlowRegExp = 79,
  kRegExpReplaceCalledOnSlowRegExp = 80,
  kDisplayNames = 81,
  kSharedArrayBufferConstructed = 82,
  kArrayPrototypeHasElements = 83,
  kObjectPrototypeHasElements = 84,
  kNumberFormatStyleUnit = 85,
  kDateTimeFormatRange = 86,
  kDateTimeFormatDateTimeStyle = 87,
  kBreakIteratorTypeWord = 88,
  kBreakIteratorTypeLine = 89,
  kInvalidatedArrayBufferDetachingProtector = 90,
  kInvalidatedArrayConstructorProtector = 91,
  kInvalidatedArrayIteratorLookupChainProtector = 92,
  kInvalidatedArraySpeciesLookupChainProtector = 93,
  kInvalidatedIsConcatSpreadableLookupChainProtector = 94,
  kInvalidatedMapIteratorLookupChainProtector = 95,
  kInvalidatedNoElementsProtector = 96,
  kInvalidatedPromiseHookProtector = 97,
  kInvalidatedPromiseResolveLookupChainProtector = 98,
  kInvalidatedPromiseSpeciesLookupChainProtector = 99,
  kInvalidatedPromiseThenLookupChainProtector = 100,
  kInvalidatedRegExpSpeciesLookupChainProtector = 101,
  kInvalidatedSetIteratorLookupChainProtector = 102,
  kInvalidatedStringIteratorLookupChainProtector = 103,
  kInvalidatedStringLengthOverflowLookupChainProtector = 104,
  kInvalidatedTypedArraySpeciesLookupChainProtector = 105,
  kWasmSimdOpcodes = 106,
  kVarRedeclaredCatchBinding = 107,
  kWasmRefTypes = 108,
  kWasmBulkMemory = 109,
  kWasmMultiValue = 110,
  kWasmExceptionHandling = 111,
  kInvalidatedMegaDOMProtector = 112,
  kFunctionPrototypeArguments = 113,
  kFunctionPrototypeCaller = 114,
  kTurboFanOsrCompileStarted = 115,
  kAsyncStackTaggingCreateTaskCall = 116,
  kDurationFormat = 117,
  kInvalidatedNumberStringNotRegexpLikeProtector = 118,
  kOBSOLETE_RegExpUnicodeSetIncompatibilitiesWithUnicodeMode = 119,
  kOBSOLETE_ImportAssertionDeprecatedSyntax = 120,
  kLocaleInfoObsoletedGetters = 121,
  kLocaleInfoFunctions = 122,
  kCompileHintsMagicAll = 123,
  kInvalidatedNoProfilingProtector = 124,
  kWasmMemory64 = 125,
  kWasmMultiMemory = 126,
  kWasmGC = 127,
  kWasmImportedStrings = 128,
  kSourceMappingUrlMagicCommentAtSign = 129,
  kTemporalObject = 130,
  kWasmModuleCompilation = 131,
  kInvalidatedNoUndetectableObjectsProtector = 132,
  kWasmJavaScriptPromiseIntegration = 133,
  kWasmReturnCall = 134,
  kWasmExtendedConst = 135,
  kWasmRelaxedSimd = 136,
  kWasmTypeReflection = 137,
  kWasmExnRef = 138,
  kWasmTypedFuncRef = 139,
  kInvalidatedStringWrapperToPrimitiveProtector = 140,
  kDocumentAllLegacyCall = 141,
  kDocumentAllLegacyConstruct = 142,
  kConsoleContext = 143,
  kWasmImportedStringsUtf8 = 144,
  kResizableArrayBuffer = 145,
  kGrowableSharedArrayBuffer = 146,
  kArrayByCopy = 147,
  kArrayFromAsync = 148,
  kIteratorMethods = 149,
  kPromiseAny = 150,
  kSetMethods = 151,
  kArrayFindLast = 152,
  kArrayGroup = 153,
  kArrayBufferTransfer = 154,
  kPromiseWithResolvers = 155,
  kAtomicsWaitAsync = 156,
  kExtendingNonExtensibleWithPrivate = 157,
  kPromiseTry = 158,
  kStringReplaceAll = 159,
  kStringWellFormed = 160,
  kWeakReferences = 161,
  kErrorIsError = 162,
  kInvalidatedTypedArrayLengthLookupChainProtector = 163,
  kRegExpEscape = 164,
  kFloat16Array = 165,
  kExplicitResourceManagement = 166,
  kWasmBranchHinting = 167,
  kWasmMutableGlobals = 168,
  kUint8ArrayToFromBase64AndHex = 169,
  kAtomicsPause = 170,
  kTopLevelAwait = 171,
  kLogicalAssignment = 172,
  kNullishCoalescing = 173,
  kInvalidatedNoDateTimeConfigurationChangeProtector = 174,
  kWasmNonTrappingFloatToInt = 175,
  kWasmSignExtensionOps = 176,
  kRegExpCompile = 177,
  kRegExpStaticProperties = 178,
  kRegExpStaticPropertiesWithLastMatch = 179,
  kWithStatement = 180,
  kHtmlWrapperMethods = 181,
  kWasmCustomDescriptors = 182,
  kWasmResizableBuffers = 183,
  kUseCounterFeatureCount = 184,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct memory_span_t {
  pub data: *mut u8,
  pub size: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of memory_span_t"][::std::mem::size_of::<memory_span_t>() - 16usize];
  ["Alignment of memory_span_t"]
    [::std::mem::align_of::<memory_span_t>() - 8usize];
  ["Offset of field: memory_span_t::data"]
    [::std::mem::offset_of!(memory_span_t, data) - 0usize];
  ["Offset of field: memory_span_t::size"]
    [::std::mem::offset_of!(memory_span_t, size) - 8usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct RustObj {
  pub _base: v8_Object_Wrappable,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of RustObj"][::std::mem::size_of::<RustObj>() - 8usize];
  ["Alignment of RustObj"][::std::mem::align_of::<RustObj>() - 8usize];
};
unsafe extern "C" {
  #[link_name = "\u{1}??1RustObj@@UEAA@XZ"]
  pub fn RustObj_RustObj_destructor(this: *mut RustObj);
}
unsafe extern "C" {
  #[link_name = "\u{1}?Trace@RustObj@@UEBAXPEAVVisitor@cppgc@@@Z"]
  pub fn RustObj_Trace(
    this: *mut ::std::os::raw::c_void,
    visitor: *mut cppgc_Visitor,
  );
}
unsafe extern "C" {
  #[link_name = "\u{1}?GetHumanReadableName@RustObj@@UEBAPEBDXZ"]
  pub fn RustObj_GetHumanReadableName(
    this: *mut ::std::os::raw::c_void,
  ) -> *const ::std::os::raw::c_char;
}
#[doc = " Types defined here will be compiled with bindgen\n and made available in `crate::binding` in rust."]
pub const v8__ScriptOrigin_SIZE: usize = 40;
pub const cppgc__Member_SIZE: usize = 4;
pub const cppgc__WeakMember_SIZE: usize = 4;
pub const v8__TracedReference_SIZE: usize = 8;
pub const v8__Eternal_SIZE: usize = 8;
pub const v8__String__ValueView_SIZE: usize = 32;
pub const v8__String__kMaxLength: ::std::os::raw::c_int = 536870888;
pub const v8__TypedArray__kMaxByteLength: usize = 9007199254740991;
pub const v8__TYPED_ARRAY_MAX_SIZE_IN_HEAP: usize = 0;
pub const v8__Uint8Array__kMaxLength: usize = 9007199254740991;
pub const v8__Uint8ClampedArray__kMaxLength: usize = 9007199254740991;
pub const v8__Int8Array__kMaxLength: usize = 9007199254740991;
pub const v8__Uint16Array__kMaxLength: usize = 4503599627370495;
pub const v8__Int16Array__kMaxLength: usize = 4503599627370495;
pub const v8__Uint32Array__kMaxLength: usize = 2251799813685247;
pub const v8__Int32Array__kMaxLength: usize = 2251799813685247;
pub const v8__Float16Array__kMaxLength: usize = 4503599627370495;
pub const v8__Float32Array__kMaxLength: usize = 2251799813685247;
pub const v8__Float64Array__kMaxLength: usize = 1125899906842623;
pub const v8__BigUint64Array__kMaxLength: usize = 1125899906842623;
pub const v8__BigInt64Array__kMaxLength: usize = 1125899906842623;
pub type v8__CFunction = v8_CFunction;
pub type v8__CFunctionInfo = v8_CFunctionInfo;
pub type v8__FastOneByteString = v8_FastOneByteString;
#[doc = " Features reported via the SetUseCounterCallback callback. Do not change\n assigned numbers of existing items; add new features to the end of this\n list.\n Dead features can be marked `V8_DEPRECATE_SOON`, then `V8_DEPRECATED`, and\n then finally be renamed to `kOBSOLETE_...` to stop embedders from using\n them."]
pub use self::v8_Isolate_UseCounterFeature as v8__Isolate__UseCounterFeature;
pub type v8__String__WriteFlags = v8_String_WriteFlags;
#[doc = " Import phases in import requests."]
pub use self::v8_ModuleImportPhase as v8__ModuleImportPhase;
#[doc = " Collection of V8 heap information.\n\n Instances of this class can be passed to v8::Isolate::GetHeapStatistics to\n get heap statistics from V8."]
pub type v8__HeapStatistics = v8_HeapStatistics;
pub type v8__HeapSpaceStatistics = v8_HeapSpaceStatistics;
#[doc = " GCCallbackFlags is used to notify additional information about the GC\n callback.\n   - kGCCallbackFlagConstructRetainedObjectInfos: The GC callback is for\n     constructing retained object infos.\n   - kGCCallbackFlagForced: The GC callback is for a forced GC for testing.\n   - kGCCallbackFlagSynchronousPhantomCallbackProcessing: The GC callback\n     is called synchronously without getting posted to an idle task.\n   - kGCCallbackFlagCollectAllAvailableGarbage: The GC callback is called\n     in a phase where V8 is trying to collect all available garbage\n     (e.g., handling a low memory notification).\n   - kGCCallbackScheduleIdleGarbageCollection: The GC callback is called to\n     trigger an idle garbage collection."]
pub use self::v8_GCCallbackFlags as v8__GCCallbackFlags;
#[doc = " Applications can register callback functions which will be called before and\n after certain garbage collection operations.  Allocations are not allowed in\n the callback functions, you therefore cannot manipulate objects (set or\n delete properties for example) since it is possible such operations will\n result in the allocation of objects.\n TODO(v8:12612): Deprecate kGCTypeMinorMarkSweep after updating blink."]
pub use self::v8_GCType as v8__GCType;
pub const v8__MAJOR_VERSION: u32 = 14;
pub const v8__MINOR_VERSION: u32 = 5;
pub const v8__BUILD_NUMBER: u32 = 201;
pub const v8__PATCH_LEVEL: u32 = 2;
pub const v8__VERSION_STRING: &::std::ffi::CStr = c"14.5.201.2-rusty";
#[repr(C)]
#[derive(Debug)]
pub struct ExternalConstOneByteStringResource {
  pub _base: v8_String_ExternalOneByteStringResource,
  pub _length: ::std::os::raw::c_int,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  ["Size of ExternalConstOneByteStringResource"]
    [::std::mem::size_of::<ExternalConstOneByteStringResource>() - 24usize];
  ["Alignment of ExternalConstOneByteStringResource"]
    [::std::mem::align_of::<ExternalConstOneByteStringResource>() - 8usize];
  ["Offset of field: ExternalConstOneByteStringResource::_length"][::std::mem::offset_of!(
    ExternalConstOneByteStringResource,
    _length
  ) - 16usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
  [
    "Size of template specialization: cppgc_GarbageCollected_open0_v8_Object_Wrappable_close0",
  ][::std::mem::size_of::<cppgc_GarbageCollected>() - 1usize];
  [
    "Align of template specialization: cppgc_GarbageCollected_open0_v8_Object_Wrappable_close0",
  ][::std::mem::align_of::<cppgc_GarbageCollected>() - 1usize];
};
