#![doc = " fiat-crypto output postprocessed by fiat-constify: <https://github.com/rustcrypto/utils>"]
#![doc = " Autogenerated: './word_by_word_montgomery' --lang Rust --inline p224_scalar 64 26959946667150639794667015087019625940457807714424391721682722368061 mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp"]
#![doc = " curve description: p224_scalar"]
#![doc = " machine_wordsize = 64 (from \"64\")"]
#![doc = " requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp"]
#![doc = " m = 0xffffffffffffffffffffffffffff16a2e0b8f03e13dd29455c5c2a3d (from \"26959946667150639794667015087019625940457807714424391721682722368061\")"]
#![doc = ""]
#![doc = " NOTE: In addition to the bounds specified above each function, all"]
#![doc = "   functions synthesized for this Montgomery arithmetic require the"]
#![doc = "   input to be strictly less than the prime modulus (m), and also"]
#![doc = "   require the input to be in the unique saturated representation."]
#![doc = "   All functions also ensure that these two properties are true of"]
#![doc = "   return values."]
#![doc = ""]
#![doc = " Computed values:"]
#![doc = "   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)"]
#![doc = "   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216)"]
#![doc = "   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in"]
#![doc = "                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256"]
#![allow(unused_parens)]
#![allow(non_camel_case_types)]
#![allow(
    clippy::identity_op,
    clippy::unnecessary_cast,
    dead_code,
    rustdoc::broken_intra_doc_links,
    unused_assignments,
    unused_mut,
    unused_variables
)]
pub type fiat_p224_scalar_u1 = u8;
pub type fiat_p224_scalar_i1 = i8;
pub type fiat_p224_scalar_u2 = u8;
pub type fiat_p224_scalar_i2 = i8;
pub type fiat_p224_scalar_montgomery_domain_field_element = [u64; 4];
pub type fiat_p224_scalar_non_montgomery_domain_field_element = [u64; 4];
#[doc = " The function fiat_p224_scalar_addcarryx_u64 is an addition with carry."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 + arg2 + arg3) mod 2^64"]
#[doc = "   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p224_scalar_addcarryx_u64(
    arg1: fiat_p224_scalar_u1,
    arg2: u64,
    arg3: u64,
) -> (u64, fiat_p224_scalar_u1) {
    let mut out1: u64 = 0;
    let mut out2: fiat_p224_scalar_u1 = 0;
    let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: fiat_p224_scalar_u1 = ((x1 >> 64) as fiat_p224_scalar_u1);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p224_scalar_subborrowx_u64 is a subtraction with borrow."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (-arg1 + arg2 + -arg3) mod 2^64"]
#[doc = "   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p224_scalar_subborrowx_u64(
    arg1: fiat_p224_scalar_u1,
    arg2: u64,
    arg3: u64,
) -> (u64, fiat_p224_scalar_u1) {
    let mut out1: u64 = 0;
    let mut out2: fiat_p224_scalar_u1 = 0;
    let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
    let x2: fiat_p224_scalar_i1 = ((x1 >> 64) as fiat_p224_scalar_i1);
    let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
    out1 = x3;
    out2 = (((0x0 as fiat_p224_scalar_i2) - (x2 as fiat_p224_scalar_i2)) as fiat_p224_scalar_u1);
    (out1, out2)
}
#[doc = " The function fiat_p224_scalar_mulx_u64 is a multiplication, returning the full double-width result."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 * arg2) mod 2^64"]
#[doc = "   out2 = ⌊arg1 * arg2 / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p224_scalar_mulx_u64(arg1: u64, arg2: u64) -> (u64, u64) {
    let mut out1: u64 = 0;
    let mut out2: u64 = 0;
    let x1: u128 = ((arg1 as u128) * (arg2 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: u64 = ((x1 >> 64) as u64);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p224_scalar_cmovznz_u64 is a single-word conditional move."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p224_scalar_cmovznz_u64(arg1: fiat_p224_scalar_u1, arg2: u64, arg3: u64) -> u64 {
    let mut out1: u64 = 0;
    let x1: fiat_p224_scalar_u1 = (!(!arg1));
    let x2: u64 = ((((((0x0 as fiat_p224_scalar_i2) - (x1 as fiat_p224_scalar_i2))
        as fiat_p224_scalar_i1) as i128)
        & (0xffffffffffffffff as i128)) as u64);
    let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
    out1 = x3;
    out1
}
#[doc = " The function fiat_p224_scalar_mul multiplies two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_mul(
    arg1: &fiat_p224_scalar_montgomery_domain_field_element,
    arg2: &fiat_p224_scalar_montgomery_domain_field_element,
) -> fiat_p224_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_montgomery_domain_field_element = [0; 4];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[0]);
    let mut x5: u64 = 0;
    let mut x6: u64 = 0;
    let (x5, x6) = fiat_p224_scalar_mulx_u64(x4, (arg2[3]));
    let mut x7: u64 = 0;
    let mut x8: u64 = 0;
    let (x7, x8) = fiat_p224_scalar_mulx_u64(x4, (arg2[2]));
    let mut x9: u64 = 0;
    let mut x10: u64 = 0;
    let (x9, x10) = fiat_p224_scalar_mulx_u64(x4, (arg2[1]));
    let mut x11: u64 = 0;
    let mut x12: u64 = 0;
    let (x11, x12) = fiat_p224_scalar_mulx_u64(x4, (arg2[0]));
    let mut x13: u64 = 0;
    let mut x14: fiat_p224_scalar_u1 = 0;
    let (x13, x14) = fiat_p224_scalar_addcarryx_u64(0x0, x12, x9);
    let mut x15: u64 = 0;
    let mut x16: fiat_p224_scalar_u1 = 0;
    let (x15, x16) = fiat_p224_scalar_addcarryx_u64(x14, x10, x7);
    let mut x17: u64 = 0;
    let mut x18: fiat_p224_scalar_u1 = 0;
    let (x17, x18) = fiat_p224_scalar_addcarryx_u64(x16, x8, x5);
    let x19: u64 = ((x18 as u64) + x6);
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    let (x20, x21) = fiat_p224_scalar_mulx_u64(x11, 0xd6e242706a1fc2eb);
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    let (x22, x23) = fiat_p224_scalar_mulx_u64(x20, 0xffffffff);
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    let (x24, x25) = fiat_p224_scalar_mulx_u64(x20, 0xffffffffffffffff);
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    let (x26, x27) = fiat_p224_scalar_mulx_u64(x20, 0xffff16a2e0b8f03e);
    let mut x28: u64 = 0;
    let mut x29: u64 = 0;
    let (x28, x29) = fiat_p224_scalar_mulx_u64(x20, 0x13dd29455c5c2a3d);
    let mut x30: u64 = 0;
    let mut x31: fiat_p224_scalar_u1 = 0;
    let (x30, x31) = fiat_p224_scalar_addcarryx_u64(0x0, x29, x26);
    let mut x32: u64 = 0;
    let mut x33: fiat_p224_scalar_u1 = 0;
    let (x32, x33) = fiat_p224_scalar_addcarryx_u64(x31, x27, x24);
    let mut x34: u64 = 0;
    let mut x35: fiat_p224_scalar_u1 = 0;
    let (x34, x35) = fiat_p224_scalar_addcarryx_u64(x33, x25, x22);
    let x36: u64 = ((x35 as u64) + x23);
    let mut x37: u64 = 0;
    let mut x38: fiat_p224_scalar_u1 = 0;
    let (x37, x38) = fiat_p224_scalar_addcarryx_u64(0x0, x11, x28);
    let mut x39: u64 = 0;
    let mut x40: fiat_p224_scalar_u1 = 0;
    let (x39, x40) = fiat_p224_scalar_addcarryx_u64(x38, x13, x30);
    let mut x41: u64 = 0;
    let mut x42: fiat_p224_scalar_u1 = 0;
    let (x41, x42) = fiat_p224_scalar_addcarryx_u64(x40, x15, x32);
    let mut x43: u64 = 0;
    let mut x44: fiat_p224_scalar_u1 = 0;
    let (x43, x44) = fiat_p224_scalar_addcarryx_u64(x42, x17, x34);
    let mut x45: u64 = 0;
    let mut x46: fiat_p224_scalar_u1 = 0;
    let (x45, x46) = fiat_p224_scalar_addcarryx_u64(x44, x19, x36);
    let mut x47: u64 = 0;
    let mut x48: u64 = 0;
    let (x47, x48) = fiat_p224_scalar_mulx_u64(x1, (arg2[3]));
    let mut x49: u64 = 0;
    let mut x50: u64 = 0;
    let (x49, x50) = fiat_p224_scalar_mulx_u64(x1, (arg2[2]));
    let mut x51: u64 = 0;
    let mut x52: u64 = 0;
    let (x51, x52) = fiat_p224_scalar_mulx_u64(x1, (arg2[1]));
    let mut x53: u64 = 0;
    let mut x54: u64 = 0;
    let (x53, x54) = fiat_p224_scalar_mulx_u64(x1, (arg2[0]));
    let mut x55: u64 = 0;
    let mut x56: fiat_p224_scalar_u1 = 0;
    let (x55, x56) = fiat_p224_scalar_addcarryx_u64(0x0, x54, x51);
    let mut x57: u64 = 0;
    let mut x58: fiat_p224_scalar_u1 = 0;
    let (x57, x58) = fiat_p224_scalar_addcarryx_u64(x56, x52, x49);
    let mut x59: u64 = 0;
    let mut x60: fiat_p224_scalar_u1 = 0;
    let (x59, x60) = fiat_p224_scalar_addcarryx_u64(x58, x50, x47);
    let x61: u64 = ((x60 as u64) + x48);
    let mut x62: u64 = 0;
    let mut x63: fiat_p224_scalar_u1 = 0;
    let (x62, x63) = fiat_p224_scalar_addcarryx_u64(0x0, x39, x53);
    let mut x64: u64 = 0;
    let mut x65: fiat_p224_scalar_u1 = 0;
    let (x64, x65) = fiat_p224_scalar_addcarryx_u64(x63, x41, x55);
    let mut x66: u64 = 0;
    let mut x67: fiat_p224_scalar_u1 = 0;
    let (x66, x67) = fiat_p224_scalar_addcarryx_u64(x65, x43, x57);
    let mut x68: u64 = 0;
    let mut x69: fiat_p224_scalar_u1 = 0;
    let (x68, x69) = fiat_p224_scalar_addcarryx_u64(x67, x45, x59);
    let mut x70: u64 = 0;
    let mut x71: fiat_p224_scalar_u1 = 0;
    let (x70, x71) = fiat_p224_scalar_addcarryx_u64(x69, (x46 as u64), x61);
    let mut x72: u64 = 0;
    let mut x73: u64 = 0;
    let (x72, x73) = fiat_p224_scalar_mulx_u64(x62, 0xd6e242706a1fc2eb);
    let mut x74: u64 = 0;
    let mut x75: u64 = 0;
    let (x74, x75) = fiat_p224_scalar_mulx_u64(x72, 0xffffffff);
    let mut x76: u64 = 0;
    let mut x77: u64 = 0;
    let (x76, x77) = fiat_p224_scalar_mulx_u64(x72, 0xffffffffffffffff);
    let mut x78: u64 = 0;
    let mut x79: u64 = 0;
    let (x78, x79) = fiat_p224_scalar_mulx_u64(x72, 0xffff16a2e0b8f03e);
    let mut x80: u64 = 0;
    let mut x81: u64 = 0;
    let (x80, x81) = fiat_p224_scalar_mulx_u64(x72, 0x13dd29455c5c2a3d);
    let mut x82: u64 = 0;
    let mut x83: fiat_p224_scalar_u1 = 0;
    let (x82, x83) = fiat_p224_scalar_addcarryx_u64(0x0, x81, x78);
    let mut x84: u64 = 0;
    let mut x85: fiat_p224_scalar_u1 = 0;
    let (x84, x85) = fiat_p224_scalar_addcarryx_u64(x83, x79, x76);
    let mut x86: u64 = 0;
    let mut x87: fiat_p224_scalar_u1 = 0;
    let (x86, x87) = fiat_p224_scalar_addcarryx_u64(x85, x77, x74);
    let x88: u64 = ((x87 as u64) + x75);
    let mut x89: u64 = 0;
    let mut x90: fiat_p224_scalar_u1 = 0;
    let (x89, x90) = fiat_p224_scalar_addcarryx_u64(0x0, x62, x80);
    let mut x91: u64 = 0;
    let mut x92: fiat_p224_scalar_u1 = 0;
    let (x91, x92) = fiat_p224_scalar_addcarryx_u64(x90, x64, x82);
    let mut x93: u64 = 0;
    let mut x94: fiat_p224_scalar_u1 = 0;
    let (x93, x94) = fiat_p224_scalar_addcarryx_u64(x92, x66, x84);
    let mut x95: u64 = 0;
    let mut x96: fiat_p224_scalar_u1 = 0;
    let (x95, x96) = fiat_p224_scalar_addcarryx_u64(x94, x68, x86);
    let mut x97: u64 = 0;
    let mut x98: fiat_p224_scalar_u1 = 0;
    let (x97, x98) = fiat_p224_scalar_addcarryx_u64(x96, x70, x88);
    let x99: u64 = ((x98 as u64) + (x71 as u64));
    let mut x100: u64 = 0;
    let mut x101: u64 = 0;
    let (x100, x101) = fiat_p224_scalar_mulx_u64(x2, (arg2[3]));
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    let (x102, x103) = fiat_p224_scalar_mulx_u64(x2, (arg2[2]));
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    let (x104, x105) = fiat_p224_scalar_mulx_u64(x2, (arg2[1]));
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p224_scalar_mulx_u64(x2, (arg2[0]));
    let mut x108: u64 = 0;
    let mut x109: fiat_p224_scalar_u1 = 0;
    let (x108, x109) = fiat_p224_scalar_addcarryx_u64(0x0, x107, x104);
    let mut x110: u64 = 0;
    let mut x111: fiat_p224_scalar_u1 = 0;
    let (x110, x111) = fiat_p224_scalar_addcarryx_u64(x109, x105, x102);
    let mut x112: u64 = 0;
    let mut x113: fiat_p224_scalar_u1 = 0;
    let (x112, x113) = fiat_p224_scalar_addcarryx_u64(x111, x103, x100);
    let x114: u64 = ((x113 as u64) + x101);
    let mut x115: u64 = 0;
    let mut x116: fiat_p224_scalar_u1 = 0;
    let (x115, x116) = fiat_p224_scalar_addcarryx_u64(0x0, x91, x106);
    let mut x117: u64 = 0;
    let mut x118: fiat_p224_scalar_u1 = 0;
    let (x117, x118) = fiat_p224_scalar_addcarryx_u64(x116, x93, x108);
    let mut x119: u64 = 0;
    let mut x120: fiat_p224_scalar_u1 = 0;
    let (x119, x120) = fiat_p224_scalar_addcarryx_u64(x118, x95, x110);
    let mut x121: u64 = 0;
    let mut x122: fiat_p224_scalar_u1 = 0;
    let (x121, x122) = fiat_p224_scalar_addcarryx_u64(x120, x97, x112);
    let mut x123: u64 = 0;
    let mut x124: fiat_p224_scalar_u1 = 0;
    let (x123, x124) = fiat_p224_scalar_addcarryx_u64(x122, x99, x114);
    let mut x125: u64 = 0;
    let mut x126: u64 = 0;
    let (x125, x126) = fiat_p224_scalar_mulx_u64(x115, 0xd6e242706a1fc2eb);
    let mut x127: u64 = 0;
    let mut x128: u64 = 0;
    let (x127, x128) = fiat_p224_scalar_mulx_u64(x125, 0xffffffff);
    let mut x129: u64 = 0;
    let mut x130: u64 = 0;
    let (x129, x130) = fiat_p224_scalar_mulx_u64(x125, 0xffffffffffffffff);
    let mut x131: u64 = 0;
    let mut x132: u64 = 0;
    let (x131, x132) = fiat_p224_scalar_mulx_u64(x125, 0xffff16a2e0b8f03e);
    let mut x133: u64 = 0;
    let mut x134: u64 = 0;
    let (x133, x134) = fiat_p224_scalar_mulx_u64(x125, 0x13dd29455c5c2a3d);
    let mut x135: u64 = 0;
    let mut x136: fiat_p224_scalar_u1 = 0;
    let (x135, x136) = fiat_p224_scalar_addcarryx_u64(0x0, x134, x131);
    let mut x137: u64 = 0;
    let mut x138: fiat_p224_scalar_u1 = 0;
    let (x137, x138) = fiat_p224_scalar_addcarryx_u64(x136, x132, x129);
    let mut x139: u64 = 0;
    let mut x140: fiat_p224_scalar_u1 = 0;
    let (x139, x140) = fiat_p224_scalar_addcarryx_u64(x138, x130, x127);
    let x141: u64 = ((x140 as u64) + x128);
    let mut x142: u64 = 0;
    let mut x143: fiat_p224_scalar_u1 = 0;
    let (x142, x143) = fiat_p224_scalar_addcarryx_u64(0x0, x115, x133);
    let mut x144: u64 = 0;
    let mut x145: fiat_p224_scalar_u1 = 0;
    let (x144, x145) = fiat_p224_scalar_addcarryx_u64(x143, x117, x135);
    let mut x146: u64 = 0;
    let mut x147: fiat_p224_scalar_u1 = 0;
    let (x146, x147) = fiat_p224_scalar_addcarryx_u64(x145, x119, x137);
    let mut x148: u64 = 0;
    let mut x149: fiat_p224_scalar_u1 = 0;
    let (x148, x149) = fiat_p224_scalar_addcarryx_u64(x147, x121, x139);
    let mut x150: u64 = 0;
    let mut x151: fiat_p224_scalar_u1 = 0;
    let (x150, x151) = fiat_p224_scalar_addcarryx_u64(x149, x123, x141);
    let x152: u64 = ((x151 as u64) + (x124 as u64));
    let mut x153: u64 = 0;
    let mut x154: u64 = 0;
    let (x153, x154) = fiat_p224_scalar_mulx_u64(x3, (arg2[3]));
    let mut x155: u64 = 0;
    let mut x156: u64 = 0;
    let (x155, x156) = fiat_p224_scalar_mulx_u64(x3, (arg2[2]));
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    let (x157, x158) = fiat_p224_scalar_mulx_u64(x3, (arg2[1]));
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    let (x159, x160) = fiat_p224_scalar_mulx_u64(x3, (arg2[0]));
    let mut x161: u64 = 0;
    let mut x162: fiat_p224_scalar_u1 = 0;
    let (x161, x162) = fiat_p224_scalar_addcarryx_u64(0x0, x160, x157);
    let mut x163: u64 = 0;
    let mut x164: fiat_p224_scalar_u1 = 0;
    let (x163, x164) = fiat_p224_scalar_addcarryx_u64(x162, x158, x155);
    let mut x165: u64 = 0;
    let mut x166: fiat_p224_scalar_u1 = 0;
    let (x165, x166) = fiat_p224_scalar_addcarryx_u64(x164, x156, x153);
    let x167: u64 = ((x166 as u64) + x154);
    let mut x168: u64 = 0;
    let mut x169: fiat_p224_scalar_u1 = 0;
    let (x168, x169) = fiat_p224_scalar_addcarryx_u64(0x0, x144, x159);
    let mut x170: u64 = 0;
    let mut x171: fiat_p224_scalar_u1 = 0;
    let (x170, x171) = fiat_p224_scalar_addcarryx_u64(x169, x146, x161);
    let mut x172: u64 = 0;
    let mut x173: fiat_p224_scalar_u1 = 0;
    let (x172, x173) = fiat_p224_scalar_addcarryx_u64(x171, x148, x163);
    let mut x174: u64 = 0;
    let mut x175: fiat_p224_scalar_u1 = 0;
    let (x174, x175) = fiat_p224_scalar_addcarryx_u64(x173, x150, x165);
    let mut x176: u64 = 0;
    let mut x177: fiat_p224_scalar_u1 = 0;
    let (x176, x177) = fiat_p224_scalar_addcarryx_u64(x175, x152, x167);
    let mut x178: u64 = 0;
    let mut x179: u64 = 0;
    let (x178, x179) = fiat_p224_scalar_mulx_u64(x168, 0xd6e242706a1fc2eb);
    let mut x180: u64 = 0;
    let mut x181: u64 = 0;
    let (x180, x181) = fiat_p224_scalar_mulx_u64(x178, 0xffffffff);
    let mut x182: u64 = 0;
    let mut x183: u64 = 0;
    let (x182, x183) = fiat_p224_scalar_mulx_u64(x178, 0xffffffffffffffff);
    let mut x184: u64 = 0;
    let mut x185: u64 = 0;
    let (x184, x185) = fiat_p224_scalar_mulx_u64(x178, 0xffff16a2e0b8f03e);
    let mut x186: u64 = 0;
    let mut x187: u64 = 0;
    let (x186, x187) = fiat_p224_scalar_mulx_u64(x178, 0x13dd29455c5c2a3d);
    let mut x188: u64 = 0;
    let mut x189: fiat_p224_scalar_u1 = 0;
    let (x188, x189) = fiat_p224_scalar_addcarryx_u64(0x0, x187, x184);
    let mut x190: u64 = 0;
    let mut x191: fiat_p224_scalar_u1 = 0;
    let (x190, x191) = fiat_p224_scalar_addcarryx_u64(x189, x185, x182);
    let mut x192: u64 = 0;
    let mut x193: fiat_p224_scalar_u1 = 0;
    let (x192, x193) = fiat_p224_scalar_addcarryx_u64(x191, x183, x180);
    let x194: u64 = ((x193 as u64) + x181);
    let mut x195: u64 = 0;
    let mut x196: fiat_p224_scalar_u1 = 0;
    let (x195, x196) = fiat_p224_scalar_addcarryx_u64(0x0, x168, x186);
    let mut x197: u64 = 0;
    let mut x198: fiat_p224_scalar_u1 = 0;
    let (x197, x198) = fiat_p224_scalar_addcarryx_u64(x196, x170, x188);
    let mut x199: u64 = 0;
    let mut x200: fiat_p224_scalar_u1 = 0;
    let (x199, x200) = fiat_p224_scalar_addcarryx_u64(x198, x172, x190);
    let mut x201: u64 = 0;
    let mut x202: fiat_p224_scalar_u1 = 0;
    let (x201, x202) = fiat_p224_scalar_addcarryx_u64(x200, x174, x192);
    let mut x203: u64 = 0;
    let mut x204: fiat_p224_scalar_u1 = 0;
    let (x203, x204) = fiat_p224_scalar_addcarryx_u64(x202, x176, x194);
    let x205: u64 = ((x204 as u64) + (x177 as u64));
    let mut x206: u64 = 0;
    let mut x207: fiat_p224_scalar_u1 = 0;
    let (x206, x207) = fiat_p224_scalar_subborrowx_u64(0x0, x197, 0x13dd29455c5c2a3d);
    let mut x208: u64 = 0;
    let mut x209: fiat_p224_scalar_u1 = 0;
    let (x208, x209) = fiat_p224_scalar_subborrowx_u64(x207, x199, 0xffff16a2e0b8f03e);
    let mut x210: u64 = 0;
    let mut x211: fiat_p224_scalar_u1 = 0;
    let (x210, x211) = fiat_p224_scalar_subborrowx_u64(x209, x201, 0xffffffffffffffff);
    let mut x212: u64 = 0;
    let mut x213: fiat_p224_scalar_u1 = 0;
    let (x212, x213) = fiat_p224_scalar_subborrowx_u64(x211, x203, 0xffffffff);
    let mut x214: u64 = 0;
    let mut x215: fiat_p224_scalar_u1 = 0;
    let (x214, x215) = fiat_p224_scalar_subborrowx_u64(x213, x205, (0x0 as u64));
    let mut x216: u64 = 0;
    let (x216) = fiat_p224_scalar_cmovznz_u64(x215, x206, x197);
    let mut x217: u64 = 0;
    let (x217) = fiat_p224_scalar_cmovznz_u64(x215, x208, x199);
    let mut x218: u64 = 0;
    let (x218) = fiat_p224_scalar_cmovznz_u64(x215, x210, x201);
    let mut x219: u64 = 0;
    let (x219) = fiat_p224_scalar_cmovznz_u64(x215, x212, x203);
    out1[0] = x216;
    out1[1] = x217;
    out1[2] = x218;
    out1[3] = x219;
    out1
}
#[doc = " The function fiat_p224_scalar_square squares a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_square(
    arg1: &fiat_p224_scalar_montgomery_domain_field_element,
) -> fiat_p224_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_montgomery_domain_field_element = [0; 4];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[0]);
    let mut x5: u64 = 0;
    let mut x6: u64 = 0;
    let (x5, x6) = fiat_p224_scalar_mulx_u64(x4, (arg1[3]));
    let mut x7: u64 = 0;
    let mut x8: u64 = 0;
    let (x7, x8) = fiat_p224_scalar_mulx_u64(x4, (arg1[2]));
    let mut x9: u64 = 0;
    let mut x10: u64 = 0;
    let (x9, x10) = fiat_p224_scalar_mulx_u64(x4, (arg1[1]));
    let mut x11: u64 = 0;
    let mut x12: u64 = 0;
    let (x11, x12) = fiat_p224_scalar_mulx_u64(x4, (arg1[0]));
    let mut x13: u64 = 0;
    let mut x14: fiat_p224_scalar_u1 = 0;
    let (x13, x14) = fiat_p224_scalar_addcarryx_u64(0x0, x12, x9);
    let mut x15: u64 = 0;
    let mut x16: fiat_p224_scalar_u1 = 0;
    let (x15, x16) = fiat_p224_scalar_addcarryx_u64(x14, x10, x7);
    let mut x17: u64 = 0;
    let mut x18: fiat_p224_scalar_u1 = 0;
    let (x17, x18) = fiat_p224_scalar_addcarryx_u64(x16, x8, x5);
    let x19: u64 = ((x18 as u64) + x6);
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    let (x20, x21) = fiat_p224_scalar_mulx_u64(x11, 0xd6e242706a1fc2eb);
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    let (x22, x23) = fiat_p224_scalar_mulx_u64(x20, 0xffffffff);
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    let (x24, x25) = fiat_p224_scalar_mulx_u64(x20, 0xffffffffffffffff);
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    let (x26, x27) = fiat_p224_scalar_mulx_u64(x20, 0xffff16a2e0b8f03e);
    let mut x28: u64 = 0;
    let mut x29: u64 = 0;
    let (x28, x29) = fiat_p224_scalar_mulx_u64(x20, 0x13dd29455c5c2a3d);
    let mut x30: u64 = 0;
    let mut x31: fiat_p224_scalar_u1 = 0;
    let (x30, x31) = fiat_p224_scalar_addcarryx_u64(0x0, x29, x26);
    let mut x32: u64 = 0;
    let mut x33: fiat_p224_scalar_u1 = 0;
    let (x32, x33) = fiat_p224_scalar_addcarryx_u64(x31, x27, x24);
    let mut x34: u64 = 0;
    let mut x35: fiat_p224_scalar_u1 = 0;
    let (x34, x35) = fiat_p224_scalar_addcarryx_u64(x33, x25, x22);
    let x36: u64 = ((x35 as u64) + x23);
    let mut x37: u64 = 0;
    let mut x38: fiat_p224_scalar_u1 = 0;
    let (x37, x38) = fiat_p224_scalar_addcarryx_u64(0x0, x11, x28);
    let mut x39: u64 = 0;
    let mut x40: fiat_p224_scalar_u1 = 0;
    let (x39, x40) = fiat_p224_scalar_addcarryx_u64(x38, x13, x30);
    let mut x41: u64 = 0;
    let mut x42: fiat_p224_scalar_u1 = 0;
    let (x41, x42) = fiat_p224_scalar_addcarryx_u64(x40, x15, x32);
    let mut x43: u64 = 0;
    let mut x44: fiat_p224_scalar_u1 = 0;
    let (x43, x44) = fiat_p224_scalar_addcarryx_u64(x42, x17, x34);
    let mut x45: u64 = 0;
    let mut x46: fiat_p224_scalar_u1 = 0;
    let (x45, x46) = fiat_p224_scalar_addcarryx_u64(x44, x19, x36);
    let mut x47: u64 = 0;
    let mut x48: u64 = 0;
    let (x47, x48) = fiat_p224_scalar_mulx_u64(x1, (arg1[3]));
    let mut x49: u64 = 0;
    let mut x50: u64 = 0;
    let (x49, x50) = fiat_p224_scalar_mulx_u64(x1, (arg1[2]));
    let mut x51: u64 = 0;
    let mut x52: u64 = 0;
    let (x51, x52) = fiat_p224_scalar_mulx_u64(x1, (arg1[1]));
    let mut x53: u64 = 0;
    let mut x54: u64 = 0;
    let (x53, x54) = fiat_p224_scalar_mulx_u64(x1, (arg1[0]));
    let mut x55: u64 = 0;
    let mut x56: fiat_p224_scalar_u1 = 0;
    let (x55, x56) = fiat_p224_scalar_addcarryx_u64(0x0, x54, x51);
    let mut x57: u64 = 0;
    let mut x58: fiat_p224_scalar_u1 = 0;
    let (x57, x58) = fiat_p224_scalar_addcarryx_u64(x56, x52, x49);
    let mut x59: u64 = 0;
    let mut x60: fiat_p224_scalar_u1 = 0;
    let (x59, x60) = fiat_p224_scalar_addcarryx_u64(x58, x50, x47);
    let x61: u64 = ((x60 as u64) + x48);
    let mut x62: u64 = 0;
    let mut x63: fiat_p224_scalar_u1 = 0;
    let (x62, x63) = fiat_p224_scalar_addcarryx_u64(0x0, x39, x53);
    let mut x64: u64 = 0;
    let mut x65: fiat_p224_scalar_u1 = 0;
    let (x64, x65) = fiat_p224_scalar_addcarryx_u64(x63, x41, x55);
    let mut x66: u64 = 0;
    let mut x67: fiat_p224_scalar_u1 = 0;
    let (x66, x67) = fiat_p224_scalar_addcarryx_u64(x65, x43, x57);
    let mut x68: u64 = 0;
    let mut x69: fiat_p224_scalar_u1 = 0;
    let (x68, x69) = fiat_p224_scalar_addcarryx_u64(x67, x45, x59);
    let mut x70: u64 = 0;
    let mut x71: fiat_p224_scalar_u1 = 0;
    let (x70, x71) = fiat_p224_scalar_addcarryx_u64(x69, (x46 as u64), x61);
    let mut x72: u64 = 0;
    let mut x73: u64 = 0;
    let (x72, x73) = fiat_p224_scalar_mulx_u64(x62, 0xd6e242706a1fc2eb);
    let mut x74: u64 = 0;
    let mut x75: u64 = 0;
    let (x74, x75) = fiat_p224_scalar_mulx_u64(x72, 0xffffffff);
    let mut x76: u64 = 0;
    let mut x77: u64 = 0;
    let (x76, x77) = fiat_p224_scalar_mulx_u64(x72, 0xffffffffffffffff);
    let mut x78: u64 = 0;
    let mut x79: u64 = 0;
    let (x78, x79) = fiat_p224_scalar_mulx_u64(x72, 0xffff16a2e0b8f03e);
    let mut x80: u64 = 0;
    let mut x81: u64 = 0;
    let (x80, x81) = fiat_p224_scalar_mulx_u64(x72, 0x13dd29455c5c2a3d);
    let mut x82: u64 = 0;
    let mut x83: fiat_p224_scalar_u1 = 0;
    let (x82, x83) = fiat_p224_scalar_addcarryx_u64(0x0, x81, x78);
    let mut x84: u64 = 0;
    let mut x85: fiat_p224_scalar_u1 = 0;
    let (x84, x85) = fiat_p224_scalar_addcarryx_u64(x83, x79, x76);
    let mut x86: u64 = 0;
    let mut x87: fiat_p224_scalar_u1 = 0;
    let (x86, x87) = fiat_p224_scalar_addcarryx_u64(x85, x77, x74);
    let x88: u64 = ((x87 as u64) + x75);
    let mut x89: u64 = 0;
    let mut x90: fiat_p224_scalar_u1 = 0;
    let (x89, x90) = fiat_p224_scalar_addcarryx_u64(0x0, x62, x80);
    let mut x91: u64 = 0;
    let mut x92: fiat_p224_scalar_u1 = 0;
    let (x91, x92) = fiat_p224_scalar_addcarryx_u64(x90, x64, x82);
    let mut x93: u64 = 0;
    let mut x94: fiat_p224_scalar_u1 = 0;
    let (x93, x94) = fiat_p224_scalar_addcarryx_u64(x92, x66, x84);
    let mut x95: u64 = 0;
    let mut x96: fiat_p224_scalar_u1 = 0;
    let (x95, x96) = fiat_p224_scalar_addcarryx_u64(x94, x68, x86);
    let mut x97: u64 = 0;
    let mut x98: fiat_p224_scalar_u1 = 0;
    let (x97, x98) = fiat_p224_scalar_addcarryx_u64(x96, x70, x88);
    let x99: u64 = ((x98 as u64) + (x71 as u64));
    let mut x100: u64 = 0;
    let mut x101: u64 = 0;
    let (x100, x101) = fiat_p224_scalar_mulx_u64(x2, (arg1[3]));
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    let (x102, x103) = fiat_p224_scalar_mulx_u64(x2, (arg1[2]));
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    let (x104, x105) = fiat_p224_scalar_mulx_u64(x2, (arg1[1]));
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p224_scalar_mulx_u64(x2, (arg1[0]));
    let mut x108: u64 = 0;
    let mut x109: fiat_p224_scalar_u1 = 0;
    let (x108, x109) = fiat_p224_scalar_addcarryx_u64(0x0, x107, x104);
    let mut x110: u64 = 0;
    let mut x111: fiat_p224_scalar_u1 = 0;
    let (x110, x111) = fiat_p224_scalar_addcarryx_u64(x109, x105, x102);
    let mut x112: u64 = 0;
    let mut x113: fiat_p224_scalar_u1 = 0;
    let (x112, x113) = fiat_p224_scalar_addcarryx_u64(x111, x103, x100);
    let x114: u64 = ((x113 as u64) + x101);
    let mut x115: u64 = 0;
    let mut x116: fiat_p224_scalar_u1 = 0;
    let (x115, x116) = fiat_p224_scalar_addcarryx_u64(0x0, x91, x106);
    let mut x117: u64 = 0;
    let mut x118: fiat_p224_scalar_u1 = 0;
    let (x117, x118) = fiat_p224_scalar_addcarryx_u64(x116, x93, x108);
    let mut x119: u64 = 0;
    let mut x120: fiat_p224_scalar_u1 = 0;
    let (x119, x120) = fiat_p224_scalar_addcarryx_u64(x118, x95, x110);
    let mut x121: u64 = 0;
    let mut x122: fiat_p224_scalar_u1 = 0;
    let (x121, x122) = fiat_p224_scalar_addcarryx_u64(x120, x97, x112);
    let mut x123: u64 = 0;
    let mut x124: fiat_p224_scalar_u1 = 0;
    let (x123, x124) = fiat_p224_scalar_addcarryx_u64(x122, x99, x114);
    let mut x125: u64 = 0;
    let mut x126: u64 = 0;
    let (x125, x126) = fiat_p224_scalar_mulx_u64(x115, 0xd6e242706a1fc2eb);
    let mut x127: u64 = 0;
    let mut x128: u64 = 0;
    let (x127, x128) = fiat_p224_scalar_mulx_u64(x125, 0xffffffff);
    let mut x129: u64 = 0;
    let mut x130: u64 = 0;
    let (x129, x130) = fiat_p224_scalar_mulx_u64(x125, 0xffffffffffffffff);
    let mut x131: u64 = 0;
    let mut x132: u64 = 0;
    let (x131, x132) = fiat_p224_scalar_mulx_u64(x125, 0xffff16a2e0b8f03e);
    let mut x133: u64 = 0;
    let mut x134: u64 = 0;
    let (x133, x134) = fiat_p224_scalar_mulx_u64(x125, 0x13dd29455c5c2a3d);
    let mut x135: u64 = 0;
    let mut x136: fiat_p224_scalar_u1 = 0;
    let (x135, x136) = fiat_p224_scalar_addcarryx_u64(0x0, x134, x131);
    let mut x137: u64 = 0;
    let mut x138: fiat_p224_scalar_u1 = 0;
    let (x137, x138) = fiat_p224_scalar_addcarryx_u64(x136, x132, x129);
    let mut x139: u64 = 0;
    let mut x140: fiat_p224_scalar_u1 = 0;
    let (x139, x140) = fiat_p224_scalar_addcarryx_u64(x138, x130, x127);
    let x141: u64 = ((x140 as u64) + x128);
    let mut x142: u64 = 0;
    let mut x143: fiat_p224_scalar_u1 = 0;
    let (x142, x143) = fiat_p224_scalar_addcarryx_u64(0x0, x115, x133);
    let mut x144: u64 = 0;
    let mut x145: fiat_p224_scalar_u1 = 0;
    let (x144, x145) = fiat_p224_scalar_addcarryx_u64(x143, x117, x135);
    let mut x146: u64 = 0;
    let mut x147: fiat_p224_scalar_u1 = 0;
    let (x146, x147) = fiat_p224_scalar_addcarryx_u64(x145, x119, x137);
    let mut x148: u64 = 0;
    let mut x149: fiat_p224_scalar_u1 = 0;
    let (x148, x149) = fiat_p224_scalar_addcarryx_u64(x147, x121, x139);
    let mut x150: u64 = 0;
    let mut x151: fiat_p224_scalar_u1 = 0;
    let (x150, x151) = fiat_p224_scalar_addcarryx_u64(x149, x123, x141);
    let x152: u64 = ((x151 as u64) + (x124 as u64));
    let mut x153: u64 = 0;
    let mut x154: u64 = 0;
    let (x153, x154) = fiat_p224_scalar_mulx_u64(x3, (arg1[3]));
    let mut x155: u64 = 0;
    let mut x156: u64 = 0;
    let (x155, x156) = fiat_p224_scalar_mulx_u64(x3, (arg1[2]));
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    let (x157, x158) = fiat_p224_scalar_mulx_u64(x3, (arg1[1]));
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    let (x159, x160) = fiat_p224_scalar_mulx_u64(x3, (arg1[0]));
    let mut x161: u64 = 0;
    let mut x162: fiat_p224_scalar_u1 = 0;
    let (x161, x162) = fiat_p224_scalar_addcarryx_u64(0x0, x160, x157);
    let mut x163: u64 = 0;
    let mut x164: fiat_p224_scalar_u1 = 0;
    let (x163, x164) = fiat_p224_scalar_addcarryx_u64(x162, x158, x155);
    let mut x165: u64 = 0;
    let mut x166: fiat_p224_scalar_u1 = 0;
    let (x165, x166) = fiat_p224_scalar_addcarryx_u64(x164, x156, x153);
    let x167: u64 = ((x166 as u64) + x154);
    let mut x168: u64 = 0;
    let mut x169: fiat_p224_scalar_u1 = 0;
    let (x168, x169) = fiat_p224_scalar_addcarryx_u64(0x0, x144, x159);
    let mut x170: u64 = 0;
    let mut x171: fiat_p224_scalar_u1 = 0;
    let (x170, x171) = fiat_p224_scalar_addcarryx_u64(x169, x146, x161);
    let mut x172: u64 = 0;
    let mut x173: fiat_p224_scalar_u1 = 0;
    let (x172, x173) = fiat_p224_scalar_addcarryx_u64(x171, x148, x163);
    let mut x174: u64 = 0;
    let mut x175: fiat_p224_scalar_u1 = 0;
    let (x174, x175) = fiat_p224_scalar_addcarryx_u64(x173, x150, x165);
    let mut x176: u64 = 0;
    let mut x177: fiat_p224_scalar_u1 = 0;
    let (x176, x177) = fiat_p224_scalar_addcarryx_u64(x175, x152, x167);
    let mut x178: u64 = 0;
    let mut x179: u64 = 0;
    let (x178, x179) = fiat_p224_scalar_mulx_u64(x168, 0xd6e242706a1fc2eb);
    let mut x180: u64 = 0;
    let mut x181: u64 = 0;
    let (x180, x181) = fiat_p224_scalar_mulx_u64(x178, 0xffffffff);
    let mut x182: u64 = 0;
    let mut x183: u64 = 0;
    let (x182, x183) = fiat_p224_scalar_mulx_u64(x178, 0xffffffffffffffff);
    let mut x184: u64 = 0;
    let mut x185: u64 = 0;
    let (x184, x185) = fiat_p224_scalar_mulx_u64(x178, 0xffff16a2e0b8f03e);
    let mut x186: u64 = 0;
    let mut x187: u64 = 0;
    let (x186, x187) = fiat_p224_scalar_mulx_u64(x178, 0x13dd29455c5c2a3d);
    let mut x188: u64 = 0;
    let mut x189: fiat_p224_scalar_u1 = 0;
    let (x188, x189) = fiat_p224_scalar_addcarryx_u64(0x0, x187, x184);
    let mut x190: u64 = 0;
    let mut x191: fiat_p224_scalar_u1 = 0;
    let (x190, x191) = fiat_p224_scalar_addcarryx_u64(x189, x185, x182);
    let mut x192: u64 = 0;
    let mut x193: fiat_p224_scalar_u1 = 0;
    let (x192, x193) = fiat_p224_scalar_addcarryx_u64(x191, x183, x180);
    let x194: u64 = ((x193 as u64) + x181);
    let mut x195: u64 = 0;
    let mut x196: fiat_p224_scalar_u1 = 0;
    let (x195, x196) = fiat_p224_scalar_addcarryx_u64(0x0, x168, x186);
    let mut x197: u64 = 0;
    let mut x198: fiat_p224_scalar_u1 = 0;
    let (x197, x198) = fiat_p224_scalar_addcarryx_u64(x196, x170, x188);
    let mut x199: u64 = 0;
    let mut x200: fiat_p224_scalar_u1 = 0;
    let (x199, x200) = fiat_p224_scalar_addcarryx_u64(x198, x172, x190);
    let mut x201: u64 = 0;
    let mut x202: fiat_p224_scalar_u1 = 0;
    let (x201, x202) = fiat_p224_scalar_addcarryx_u64(x200, x174, x192);
    let mut x203: u64 = 0;
    let mut x204: fiat_p224_scalar_u1 = 0;
    let (x203, x204) = fiat_p224_scalar_addcarryx_u64(x202, x176, x194);
    let x205: u64 = ((x204 as u64) + (x177 as u64));
    let mut x206: u64 = 0;
    let mut x207: fiat_p224_scalar_u1 = 0;
    let (x206, x207) = fiat_p224_scalar_subborrowx_u64(0x0, x197, 0x13dd29455c5c2a3d);
    let mut x208: u64 = 0;
    let mut x209: fiat_p224_scalar_u1 = 0;
    let (x208, x209) = fiat_p224_scalar_subborrowx_u64(x207, x199, 0xffff16a2e0b8f03e);
    let mut x210: u64 = 0;
    let mut x211: fiat_p224_scalar_u1 = 0;
    let (x210, x211) = fiat_p224_scalar_subborrowx_u64(x209, x201, 0xffffffffffffffff);
    let mut x212: u64 = 0;
    let mut x213: fiat_p224_scalar_u1 = 0;
    let (x212, x213) = fiat_p224_scalar_subborrowx_u64(x211, x203, 0xffffffff);
    let mut x214: u64 = 0;
    let mut x215: fiat_p224_scalar_u1 = 0;
    let (x214, x215) = fiat_p224_scalar_subborrowx_u64(x213, x205, (0x0 as u64));
    let mut x216: u64 = 0;
    let (x216) = fiat_p224_scalar_cmovznz_u64(x215, x206, x197);
    let mut x217: u64 = 0;
    let (x217) = fiat_p224_scalar_cmovznz_u64(x215, x208, x199);
    let mut x218: u64 = 0;
    let (x218) = fiat_p224_scalar_cmovznz_u64(x215, x210, x201);
    let mut x219: u64 = 0;
    let (x219) = fiat_p224_scalar_cmovznz_u64(x215, x212, x203);
    out1[0] = x216;
    out1[1] = x217;
    out1[2] = x218;
    out1[3] = x219;
    out1
}
#[doc = " The function fiat_p224_scalar_add adds two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_add(
    arg1: &fiat_p224_scalar_montgomery_domain_field_element,
    arg2: &fiat_p224_scalar_montgomery_domain_field_element,
) -> fiat_p224_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_montgomery_domain_field_element = [0; 4];
    let mut x1: u64 = 0;
    let mut x2: fiat_p224_scalar_u1 = 0;
    let (x1, x2) = fiat_p224_scalar_addcarryx_u64(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p224_scalar_u1 = 0;
    let (x3, x4) = fiat_p224_scalar_addcarryx_u64(x2, (arg1[1]), (arg2[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p224_scalar_u1 = 0;
    let (x5, x6) = fiat_p224_scalar_addcarryx_u64(x4, (arg1[2]), (arg2[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p224_scalar_u1 = 0;
    let (x7, x8) = fiat_p224_scalar_addcarryx_u64(x6, (arg1[3]), (arg2[3]));
    let mut x9: u64 = 0;
    let mut x10: fiat_p224_scalar_u1 = 0;
    let (x9, x10) = fiat_p224_scalar_subborrowx_u64(0x0, x1, 0x13dd29455c5c2a3d);
    let mut x11: u64 = 0;
    let mut x12: fiat_p224_scalar_u1 = 0;
    let (x11, x12) = fiat_p224_scalar_subborrowx_u64(x10, x3, 0xffff16a2e0b8f03e);
    let mut x13: u64 = 0;
    let mut x14: fiat_p224_scalar_u1 = 0;
    let (x13, x14) = fiat_p224_scalar_subborrowx_u64(x12, x5, 0xffffffffffffffff);
    let mut x15: u64 = 0;
    let mut x16: fiat_p224_scalar_u1 = 0;
    let (x15, x16) = fiat_p224_scalar_subborrowx_u64(x14, x7, 0xffffffff);
    let mut x17: u64 = 0;
    let mut x18: fiat_p224_scalar_u1 = 0;
    let (x17, x18) = fiat_p224_scalar_subborrowx_u64(x16, (x8 as u64), (0x0 as u64));
    let mut x19: u64 = 0;
    let (x19) = fiat_p224_scalar_cmovznz_u64(x18, x9, x1);
    let mut x20: u64 = 0;
    let (x20) = fiat_p224_scalar_cmovznz_u64(x18, x11, x3);
    let mut x21: u64 = 0;
    let (x21) = fiat_p224_scalar_cmovznz_u64(x18, x13, x5);
    let mut x22: u64 = 0;
    let (x22) = fiat_p224_scalar_cmovznz_u64(x18, x15, x7);
    out1[0] = x19;
    out1[1] = x20;
    out1[2] = x21;
    out1[3] = x22;
    out1
}
#[doc = " The function fiat_p224_scalar_sub subtracts two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_sub(
    arg1: &fiat_p224_scalar_montgomery_domain_field_element,
    arg2: &fiat_p224_scalar_montgomery_domain_field_element,
) -> fiat_p224_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_montgomery_domain_field_element = [0; 4];
    let mut x1: u64 = 0;
    let mut x2: fiat_p224_scalar_u1 = 0;
    let (x1, x2) = fiat_p224_scalar_subborrowx_u64(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p224_scalar_u1 = 0;
    let (x3, x4) = fiat_p224_scalar_subborrowx_u64(x2, (arg1[1]), (arg2[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p224_scalar_u1 = 0;
    let (x5, x6) = fiat_p224_scalar_subborrowx_u64(x4, (arg1[2]), (arg2[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p224_scalar_u1 = 0;
    let (x7, x8) = fiat_p224_scalar_subborrowx_u64(x6, (arg1[3]), (arg2[3]));
    let mut x9: u64 = 0;
    let (x9) = fiat_p224_scalar_cmovznz_u64(x8, (0x0 as u64), 0xffffffffffffffff);
    let mut x10: u64 = 0;
    let mut x11: fiat_p224_scalar_u1 = 0;
    let (x10, x11) = fiat_p224_scalar_addcarryx_u64(0x0, x1, (x9 & 0x13dd29455c5c2a3d));
    let mut x12: u64 = 0;
    let mut x13: fiat_p224_scalar_u1 = 0;
    let (x12, x13) = fiat_p224_scalar_addcarryx_u64(x11, x3, (x9 & 0xffff16a2e0b8f03e));
    let mut x14: u64 = 0;
    let mut x15: fiat_p224_scalar_u1 = 0;
    let (x14, x15) = fiat_p224_scalar_addcarryx_u64(x13, x5, x9);
    let mut x16: u64 = 0;
    let mut x17: fiat_p224_scalar_u1 = 0;
    let (x16, x17) = fiat_p224_scalar_addcarryx_u64(x15, x7, (x9 & 0xffffffff));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
    out1
}
#[doc = " The function fiat_p224_scalar_opp negates a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_opp(
    arg1: &fiat_p224_scalar_montgomery_domain_field_element,
) -> fiat_p224_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_montgomery_domain_field_element = [0; 4];
    let mut x1: u64 = 0;
    let mut x2: fiat_p224_scalar_u1 = 0;
    let (x1, x2) = fiat_p224_scalar_subborrowx_u64(0x0, (0x0 as u64), (arg1[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p224_scalar_u1 = 0;
    let (x3, x4) = fiat_p224_scalar_subborrowx_u64(x2, (0x0 as u64), (arg1[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p224_scalar_u1 = 0;
    let (x5, x6) = fiat_p224_scalar_subborrowx_u64(x4, (0x0 as u64), (arg1[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p224_scalar_u1 = 0;
    let (x7, x8) = fiat_p224_scalar_subborrowx_u64(x6, (0x0 as u64), (arg1[3]));
    let mut x9: u64 = 0;
    let (x9) = fiat_p224_scalar_cmovznz_u64(x8, (0x0 as u64), 0xffffffffffffffff);
    let mut x10: u64 = 0;
    let mut x11: fiat_p224_scalar_u1 = 0;
    let (x10, x11) = fiat_p224_scalar_addcarryx_u64(0x0, x1, (x9 & 0x13dd29455c5c2a3d));
    let mut x12: u64 = 0;
    let mut x13: fiat_p224_scalar_u1 = 0;
    let (x12, x13) = fiat_p224_scalar_addcarryx_u64(x11, x3, (x9 & 0xffff16a2e0b8f03e));
    let mut x14: u64 = 0;
    let mut x15: fiat_p224_scalar_u1 = 0;
    let (x14, x15) = fiat_p224_scalar_addcarryx_u64(x13, x5, x9);
    let mut x16: u64 = 0;
    let mut x17: fiat_p224_scalar_u1 = 0;
    let (x16, x17) = fiat_p224_scalar_addcarryx_u64(x15, x7, (x9 & 0xffffffff));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
    out1
}
#[doc = " The function fiat_p224_scalar_from_montgomery translates a field element out of the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_from_montgomery(
    arg1: &fiat_p224_scalar_montgomery_domain_field_element,
) -> fiat_p224_scalar_non_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_non_montgomery_domain_field_element = [0; 4];
    let x1: u64 = (arg1[0]);
    let mut x2: u64 = 0;
    let mut x3: u64 = 0;
    let (x2, x3) = fiat_p224_scalar_mulx_u64(x1, 0xd6e242706a1fc2eb);
    let mut x4: u64 = 0;
    let mut x5: u64 = 0;
    let (x4, x5) = fiat_p224_scalar_mulx_u64(x2, 0xffffffff);
    let mut x6: u64 = 0;
    let mut x7: u64 = 0;
    let (x6, x7) = fiat_p224_scalar_mulx_u64(x2, 0xffffffffffffffff);
    let mut x8: u64 = 0;
    let mut x9: u64 = 0;
    let (x8, x9) = fiat_p224_scalar_mulx_u64(x2, 0xffff16a2e0b8f03e);
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    let (x10, x11) = fiat_p224_scalar_mulx_u64(x2, 0x13dd29455c5c2a3d);
    let mut x12: u64 = 0;
    let mut x13: fiat_p224_scalar_u1 = 0;
    let (x12, x13) = fiat_p224_scalar_addcarryx_u64(0x0, x11, x8);
    let mut x14: u64 = 0;
    let mut x15: fiat_p224_scalar_u1 = 0;
    let (x14, x15) = fiat_p224_scalar_addcarryx_u64(x13, x9, x6);
    let mut x16: u64 = 0;
    let mut x17: fiat_p224_scalar_u1 = 0;
    let (x16, x17) = fiat_p224_scalar_addcarryx_u64(x15, x7, x4);
    let mut x18: u64 = 0;
    let mut x19: fiat_p224_scalar_u1 = 0;
    let (x18, x19) = fiat_p224_scalar_addcarryx_u64(0x0, x1, x10);
    let mut x20: u64 = 0;
    let mut x21: fiat_p224_scalar_u1 = 0;
    let (x20, x21) = fiat_p224_scalar_addcarryx_u64(x19, (0x0 as u64), x12);
    let mut x22: u64 = 0;
    let mut x23: fiat_p224_scalar_u1 = 0;
    let (x22, x23) = fiat_p224_scalar_addcarryx_u64(x21, (0x0 as u64), x14);
    let mut x24: u64 = 0;
    let mut x25: fiat_p224_scalar_u1 = 0;
    let (x24, x25) = fiat_p224_scalar_addcarryx_u64(x23, (0x0 as u64), x16);
    let mut x26: u64 = 0;
    let mut x27: fiat_p224_scalar_u1 = 0;
    let (x26, x27) = fiat_p224_scalar_addcarryx_u64(0x0, x20, (arg1[1]));
    let mut x28: u64 = 0;
    let mut x29: fiat_p224_scalar_u1 = 0;
    let (x28, x29) = fiat_p224_scalar_addcarryx_u64(x27, x22, (0x0 as u64));
    let mut x30: u64 = 0;
    let mut x31: fiat_p224_scalar_u1 = 0;
    let (x30, x31) = fiat_p224_scalar_addcarryx_u64(x29, x24, (0x0 as u64));
    let mut x32: u64 = 0;
    let mut x33: u64 = 0;
    let (x32, x33) = fiat_p224_scalar_mulx_u64(x26, 0xd6e242706a1fc2eb);
    let mut x34: u64 = 0;
    let mut x35: u64 = 0;
    let (x34, x35) = fiat_p224_scalar_mulx_u64(x32, 0xffffffff);
    let mut x36: u64 = 0;
    let mut x37: u64 = 0;
    let (x36, x37) = fiat_p224_scalar_mulx_u64(x32, 0xffffffffffffffff);
    let mut x38: u64 = 0;
    let mut x39: u64 = 0;
    let (x38, x39) = fiat_p224_scalar_mulx_u64(x32, 0xffff16a2e0b8f03e);
    let mut x40: u64 = 0;
    let mut x41: u64 = 0;
    let (x40, x41) = fiat_p224_scalar_mulx_u64(x32, 0x13dd29455c5c2a3d);
    let mut x42: u64 = 0;
    let mut x43: fiat_p224_scalar_u1 = 0;
    let (x42, x43) = fiat_p224_scalar_addcarryx_u64(0x0, x41, x38);
    let mut x44: u64 = 0;
    let mut x45: fiat_p224_scalar_u1 = 0;
    let (x44, x45) = fiat_p224_scalar_addcarryx_u64(x43, x39, x36);
    let mut x46: u64 = 0;
    let mut x47: fiat_p224_scalar_u1 = 0;
    let (x46, x47) = fiat_p224_scalar_addcarryx_u64(x45, x37, x34);
    let mut x48: u64 = 0;
    let mut x49: fiat_p224_scalar_u1 = 0;
    let (x48, x49) = fiat_p224_scalar_addcarryx_u64(0x0, x26, x40);
    let mut x50: u64 = 0;
    let mut x51: fiat_p224_scalar_u1 = 0;
    let (x50, x51) = fiat_p224_scalar_addcarryx_u64(x49, x28, x42);
    let mut x52: u64 = 0;
    let mut x53: fiat_p224_scalar_u1 = 0;
    let (x52, x53) = fiat_p224_scalar_addcarryx_u64(x51, x30, x44);
    let mut x54: u64 = 0;
    let mut x55: fiat_p224_scalar_u1 = 0;
    let (x54, x55) = fiat_p224_scalar_addcarryx_u64(
        x53,
        ((x31 as u64) + ((x25 as u64) + ((x17 as u64) + x5))),
        x46,
    );
    let mut x56: u64 = 0;
    let mut x57: fiat_p224_scalar_u1 = 0;
    let (x56, x57) = fiat_p224_scalar_addcarryx_u64(0x0, x50, (arg1[2]));
    let mut x58: u64 = 0;
    let mut x59: fiat_p224_scalar_u1 = 0;
    let (x58, x59) = fiat_p224_scalar_addcarryx_u64(x57, x52, (0x0 as u64));
    let mut x60: u64 = 0;
    let mut x61: fiat_p224_scalar_u1 = 0;
    let (x60, x61) = fiat_p224_scalar_addcarryx_u64(x59, x54, (0x0 as u64));
    let mut x62: u64 = 0;
    let mut x63: u64 = 0;
    let (x62, x63) = fiat_p224_scalar_mulx_u64(x56, 0xd6e242706a1fc2eb);
    let mut x64: u64 = 0;
    let mut x65: u64 = 0;
    let (x64, x65) = fiat_p224_scalar_mulx_u64(x62, 0xffffffff);
    let mut x66: u64 = 0;
    let mut x67: u64 = 0;
    let (x66, x67) = fiat_p224_scalar_mulx_u64(x62, 0xffffffffffffffff);
    let mut x68: u64 = 0;
    let mut x69: u64 = 0;
    let (x68, x69) = fiat_p224_scalar_mulx_u64(x62, 0xffff16a2e0b8f03e);
    let mut x70: u64 = 0;
    let mut x71: u64 = 0;
    let (x70, x71) = fiat_p224_scalar_mulx_u64(x62, 0x13dd29455c5c2a3d);
    let mut x72: u64 = 0;
    let mut x73: fiat_p224_scalar_u1 = 0;
    let (x72, x73) = fiat_p224_scalar_addcarryx_u64(0x0, x71, x68);
    let mut x74: u64 = 0;
    let mut x75: fiat_p224_scalar_u1 = 0;
    let (x74, x75) = fiat_p224_scalar_addcarryx_u64(x73, x69, x66);
    let mut x76: u64 = 0;
    let mut x77: fiat_p224_scalar_u1 = 0;
    let (x76, x77) = fiat_p224_scalar_addcarryx_u64(x75, x67, x64);
    let mut x78: u64 = 0;
    let mut x79: fiat_p224_scalar_u1 = 0;
    let (x78, x79) = fiat_p224_scalar_addcarryx_u64(0x0, x56, x70);
    let mut x80: u64 = 0;
    let mut x81: fiat_p224_scalar_u1 = 0;
    let (x80, x81) = fiat_p224_scalar_addcarryx_u64(x79, x58, x72);
    let mut x82: u64 = 0;
    let mut x83: fiat_p224_scalar_u1 = 0;
    let (x82, x83) = fiat_p224_scalar_addcarryx_u64(x81, x60, x74);
    let mut x84: u64 = 0;
    let mut x85: fiat_p224_scalar_u1 = 0;
    let (x84, x85) = fiat_p224_scalar_addcarryx_u64(
        x83,
        ((x61 as u64) + ((x55 as u64) + ((x47 as u64) + x35))),
        x76,
    );
    let mut x86: u64 = 0;
    let mut x87: fiat_p224_scalar_u1 = 0;
    let (x86, x87) = fiat_p224_scalar_addcarryx_u64(0x0, x80, (arg1[3]));
    let mut x88: u64 = 0;
    let mut x89: fiat_p224_scalar_u1 = 0;
    let (x88, x89) = fiat_p224_scalar_addcarryx_u64(x87, x82, (0x0 as u64));
    let mut x90: u64 = 0;
    let mut x91: fiat_p224_scalar_u1 = 0;
    let (x90, x91) = fiat_p224_scalar_addcarryx_u64(x89, x84, (0x0 as u64));
    let mut x92: u64 = 0;
    let mut x93: u64 = 0;
    let (x92, x93) = fiat_p224_scalar_mulx_u64(x86, 0xd6e242706a1fc2eb);
    let mut x94: u64 = 0;
    let mut x95: u64 = 0;
    let (x94, x95) = fiat_p224_scalar_mulx_u64(x92, 0xffffffff);
    let mut x96: u64 = 0;
    let mut x97: u64 = 0;
    let (x96, x97) = fiat_p224_scalar_mulx_u64(x92, 0xffffffffffffffff);
    let mut x98: u64 = 0;
    let mut x99: u64 = 0;
    let (x98, x99) = fiat_p224_scalar_mulx_u64(x92, 0xffff16a2e0b8f03e);
    let mut x100: u64 = 0;
    let mut x101: u64 = 0;
    let (x100, x101) = fiat_p224_scalar_mulx_u64(x92, 0x13dd29455c5c2a3d);
    let mut x102: u64 = 0;
    let mut x103: fiat_p224_scalar_u1 = 0;
    let (x102, x103) = fiat_p224_scalar_addcarryx_u64(0x0, x101, x98);
    let mut x104: u64 = 0;
    let mut x105: fiat_p224_scalar_u1 = 0;
    let (x104, x105) = fiat_p224_scalar_addcarryx_u64(x103, x99, x96);
    let mut x106: u64 = 0;
    let mut x107: fiat_p224_scalar_u1 = 0;
    let (x106, x107) = fiat_p224_scalar_addcarryx_u64(x105, x97, x94);
    let mut x108: u64 = 0;
    let mut x109: fiat_p224_scalar_u1 = 0;
    let (x108, x109) = fiat_p224_scalar_addcarryx_u64(0x0, x86, x100);
    let mut x110: u64 = 0;
    let mut x111: fiat_p224_scalar_u1 = 0;
    let (x110, x111) = fiat_p224_scalar_addcarryx_u64(x109, x88, x102);
    let mut x112: u64 = 0;
    let mut x113: fiat_p224_scalar_u1 = 0;
    let (x112, x113) = fiat_p224_scalar_addcarryx_u64(x111, x90, x104);
    let mut x114: u64 = 0;
    let mut x115: fiat_p224_scalar_u1 = 0;
    let (x114, x115) = fiat_p224_scalar_addcarryx_u64(
        x113,
        ((x91 as u64) + ((x85 as u64) + ((x77 as u64) + x65))),
        x106,
    );
    let x116: u64 = ((x115 as u64) + ((x107 as u64) + x95));
    let mut x117: u64 = 0;
    let mut x118: fiat_p224_scalar_u1 = 0;
    let (x117, x118) = fiat_p224_scalar_subborrowx_u64(0x0, x110, 0x13dd29455c5c2a3d);
    let mut x119: u64 = 0;
    let mut x120: fiat_p224_scalar_u1 = 0;
    let (x119, x120) = fiat_p224_scalar_subborrowx_u64(x118, x112, 0xffff16a2e0b8f03e);
    let mut x121: u64 = 0;
    let mut x122: fiat_p224_scalar_u1 = 0;
    let (x121, x122) = fiat_p224_scalar_subborrowx_u64(x120, x114, 0xffffffffffffffff);
    let mut x123: u64 = 0;
    let mut x124: fiat_p224_scalar_u1 = 0;
    let (x123, x124) = fiat_p224_scalar_subborrowx_u64(x122, x116, 0xffffffff);
    let mut x125: u64 = 0;
    let mut x126: fiat_p224_scalar_u1 = 0;
    let (x125, x126) = fiat_p224_scalar_subborrowx_u64(x124, (0x0 as u64), (0x0 as u64));
    let mut x127: u64 = 0;
    let (x127) = fiat_p224_scalar_cmovznz_u64(x126, x117, x110);
    let mut x128: u64 = 0;
    let (x128) = fiat_p224_scalar_cmovznz_u64(x126, x119, x112);
    let mut x129: u64 = 0;
    let (x129) = fiat_p224_scalar_cmovznz_u64(x126, x121, x114);
    let mut x130: u64 = 0;
    let (x130) = fiat_p224_scalar_cmovznz_u64(x126, x123, x116);
    out1[0] = x127;
    out1[1] = x128;
    out1[2] = x129;
    out1[3] = x130;
    out1
}
#[doc = " The function fiat_p224_scalar_to_montgomery translates a field element into the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_to_montgomery(
    arg1: &fiat_p224_scalar_non_montgomery_domain_field_element,
) -> fiat_p224_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_montgomery_domain_field_element = [0; 4];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[0]);
    let mut x5: u64 = 0;
    let mut x6: u64 = 0;
    let (x5, x6) = fiat_p224_scalar_mulx_u64(x4, 0xb1e97961);
    let mut x7: u64 = 0;
    let mut x8: u64 = 0;
    let (x7, x8) = fiat_p224_scalar_mulx_u64(x4, 0x6ad15f7cd9714856);
    let mut x9: u64 = 0;
    let mut x10: u64 = 0;
    let (x9, x10) = fiat_p224_scalar_mulx_u64(x4, 0xabc8ff5931d63f4b);
    let mut x11: u64 = 0;
    let mut x12: u64 = 0;
    let (x11, x12) = fiat_p224_scalar_mulx_u64(x4, 0x29947a695f517d15);
    let mut x13: u64 = 0;
    let mut x14: fiat_p224_scalar_u1 = 0;
    let (x13, x14) = fiat_p224_scalar_addcarryx_u64(0x0, x12, x9);
    let mut x15: u64 = 0;
    let mut x16: fiat_p224_scalar_u1 = 0;
    let (x15, x16) = fiat_p224_scalar_addcarryx_u64(x14, x10, x7);
    let mut x17: u64 = 0;
    let mut x18: fiat_p224_scalar_u1 = 0;
    let (x17, x18) = fiat_p224_scalar_addcarryx_u64(x16, x8, x5);
    let mut x19: u64 = 0;
    let mut x20: u64 = 0;
    let (x19, x20) = fiat_p224_scalar_mulx_u64(x11, 0xd6e242706a1fc2eb);
    let mut x21: u64 = 0;
    let mut x22: u64 = 0;
    let (x21, x22) = fiat_p224_scalar_mulx_u64(x19, 0xffffffff);
    let mut x23: u64 = 0;
    let mut x24: u64 = 0;
    let (x23, x24) = fiat_p224_scalar_mulx_u64(x19, 0xffffffffffffffff);
    let mut x25: u64 = 0;
    let mut x26: u64 = 0;
    let (x25, x26) = fiat_p224_scalar_mulx_u64(x19, 0xffff16a2e0b8f03e);
    let mut x27: u64 = 0;
    let mut x28: u64 = 0;
    let (x27, x28) = fiat_p224_scalar_mulx_u64(x19, 0x13dd29455c5c2a3d);
    let mut x29: u64 = 0;
    let mut x30: fiat_p224_scalar_u1 = 0;
    let (x29, x30) = fiat_p224_scalar_addcarryx_u64(0x0, x28, x25);
    let mut x31: u64 = 0;
    let mut x32: fiat_p224_scalar_u1 = 0;
    let (x31, x32) = fiat_p224_scalar_addcarryx_u64(x30, x26, x23);
    let mut x33: u64 = 0;
    let mut x34: fiat_p224_scalar_u1 = 0;
    let (x33, x34) = fiat_p224_scalar_addcarryx_u64(x32, x24, x21);
    let mut x35: u64 = 0;
    let mut x36: fiat_p224_scalar_u1 = 0;
    let (x35, x36) = fiat_p224_scalar_addcarryx_u64(0x0, x11, x27);
    let mut x37: u64 = 0;
    let mut x38: fiat_p224_scalar_u1 = 0;
    let (x37, x38) = fiat_p224_scalar_addcarryx_u64(x36, x13, x29);
    let mut x39: u64 = 0;
    let mut x40: fiat_p224_scalar_u1 = 0;
    let (x39, x40) = fiat_p224_scalar_addcarryx_u64(x38, x15, x31);
    let mut x41: u64 = 0;
    let mut x42: fiat_p224_scalar_u1 = 0;
    let (x41, x42) = fiat_p224_scalar_addcarryx_u64(x40, x17, x33);
    let mut x43: u64 = 0;
    let mut x44: u64 = 0;
    let (x43, x44) = fiat_p224_scalar_mulx_u64(x1, 0xb1e97961);
    let mut x45: u64 = 0;
    let mut x46: u64 = 0;
    let (x45, x46) = fiat_p224_scalar_mulx_u64(x1, 0x6ad15f7cd9714856);
    let mut x47: u64 = 0;
    let mut x48: u64 = 0;
    let (x47, x48) = fiat_p224_scalar_mulx_u64(x1, 0xabc8ff5931d63f4b);
    let mut x49: u64 = 0;
    let mut x50: u64 = 0;
    let (x49, x50) = fiat_p224_scalar_mulx_u64(x1, 0x29947a695f517d15);
    let mut x51: u64 = 0;
    let mut x52: fiat_p224_scalar_u1 = 0;
    let (x51, x52) = fiat_p224_scalar_addcarryx_u64(0x0, x50, x47);
    let mut x53: u64 = 0;
    let mut x54: fiat_p224_scalar_u1 = 0;
    let (x53, x54) = fiat_p224_scalar_addcarryx_u64(x52, x48, x45);
    let mut x55: u64 = 0;
    let mut x56: fiat_p224_scalar_u1 = 0;
    let (x55, x56) = fiat_p224_scalar_addcarryx_u64(x54, x46, x43);
    let mut x57: u64 = 0;
    let mut x58: fiat_p224_scalar_u1 = 0;
    let (x57, x58) = fiat_p224_scalar_addcarryx_u64(0x0, x37, x49);
    let mut x59: u64 = 0;
    let mut x60: fiat_p224_scalar_u1 = 0;
    let (x59, x60) = fiat_p224_scalar_addcarryx_u64(x58, x39, x51);
    let mut x61: u64 = 0;
    let mut x62: fiat_p224_scalar_u1 = 0;
    let (x61, x62) = fiat_p224_scalar_addcarryx_u64(x60, x41, x53);
    let mut x63: u64 = 0;
    let mut x64: fiat_p224_scalar_u1 = 0;
    let (x63, x64) = fiat_p224_scalar_addcarryx_u64(
        x62,
        (((x42 as u64) + ((x18 as u64) + x6)) + ((x34 as u64) + x22)),
        x55,
    );
    let mut x65: u64 = 0;
    let mut x66: u64 = 0;
    let (x65, x66) = fiat_p224_scalar_mulx_u64(x57, 0xd6e242706a1fc2eb);
    let mut x67: u64 = 0;
    let mut x68: u64 = 0;
    let (x67, x68) = fiat_p224_scalar_mulx_u64(x65, 0xffffffff);
    let mut x69: u64 = 0;
    let mut x70: u64 = 0;
    let (x69, x70) = fiat_p224_scalar_mulx_u64(x65, 0xffffffffffffffff);
    let mut x71: u64 = 0;
    let mut x72: u64 = 0;
    let (x71, x72) = fiat_p224_scalar_mulx_u64(x65, 0xffff16a2e0b8f03e);
    let mut x73: u64 = 0;
    let mut x74: u64 = 0;
    let (x73, x74) = fiat_p224_scalar_mulx_u64(x65, 0x13dd29455c5c2a3d);
    let mut x75: u64 = 0;
    let mut x76: fiat_p224_scalar_u1 = 0;
    let (x75, x76) = fiat_p224_scalar_addcarryx_u64(0x0, x74, x71);
    let mut x77: u64 = 0;
    let mut x78: fiat_p224_scalar_u1 = 0;
    let (x77, x78) = fiat_p224_scalar_addcarryx_u64(x76, x72, x69);
    let mut x79: u64 = 0;
    let mut x80: fiat_p224_scalar_u1 = 0;
    let (x79, x80) = fiat_p224_scalar_addcarryx_u64(x78, x70, x67);
    let mut x81: u64 = 0;
    let mut x82: fiat_p224_scalar_u1 = 0;
    let (x81, x82) = fiat_p224_scalar_addcarryx_u64(0x0, x57, x73);
    let mut x83: u64 = 0;
    let mut x84: fiat_p224_scalar_u1 = 0;
    let (x83, x84) = fiat_p224_scalar_addcarryx_u64(x82, x59, x75);
    let mut x85: u64 = 0;
    let mut x86: fiat_p224_scalar_u1 = 0;
    let (x85, x86) = fiat_p224_scalar_addcarryx_u64(x84, x61, x77);
    let mut x87: u64 = 0;
    let mut x88: fiat_p224_scalar_u1 = 0;
    let (x87, x88) = fiat_p224_scalar_addcarryx_u64(x86, x63, x79);
    let mut x89: u64 = 0;
    let mut x90: u64 = 0;
    let (x89, x90) = fiat_p224_scalar_mulx_u64(x2, 0xb1e97961);
    let mut x91: u64 = 0;
    let mut x92: u64 = 0;
    let (x91, x92) = fiat_p224_scalar_mulx_u64(x2, 0x6ad15f7cd9714856);
    let mut x93: u64 = 0;
    let mut x94: u64 = 0;
    let (x93, x94) = fiat_p224_scalar_mulx_u64(x2, 0xabc8ff5931d63f4b);
    let mut x95: u64 = 0;
    let mut x96: u64 = 0;
    let (x95, x96) = fiat_p224_scalar_mulx_u64(x2, 0x29947a695f517d15);
    let mut x97: u64 = 0;
    let mut x98: fiat_p224_scalar_u1 = 0;
    let (x97, x98) = fiat_p224_scalar_addcarryx_u64(0x0, x96, x93);
    let mut x99: u64 = 0;
    let mut x100: fiat_p224_scalar_u1 = 0;
    let (x99, x100) = fiat_p224_scalar_addcarryx_u64(x98, x94, x91);
    let mut x101: u64 = 0;
    let mut x102: fiat_p224_scalar_u1 = 0;
    let (x101, x102) = fiat_p224_scalar_addcarryx_u64(x100, x92, x89);
    let mut x103: u64 = 0;
    let mut x104: fiat_p224_scalar_u1 = 0;
    let (x103, x104) = fiat_p224_scalar_addcarryx_u64(0x0, x83, x95);
    let mut x105: u64 = 0;
    let mut x106: fiat_p224_scalar_u1 = 0;
    let (x105, x106) = fiat_p224_scalar_addcarryx_u64(x104, x85, x97);
    let mut x107: u64 = 0;
    let mut x108: fiat_p224_scalar_u1 = 0;
    let (x107, x108) = fiat_p224_scalar_addcarryx_u64(x106, x87, x99);
    let mut x109: u64 = 0;
    let mut x110: fiat_p224_scalar_u1 = 0;
    let (x109, x110) = fiat_p224_scalar_addcarryx_u64(
        x108,
        (((x88 as u64) + ((x64 as u64) + ((x56 as u64) + x44))) + ((x80 as u64) + x68)),
        x101,
    );
    let mut x111: u64 = 0;
    let mut x112: u64 = 0;
    let (x111, x112) = fiat_p224_scalar_mulx_u64(x103, 0xd6e242706a1fc2eb);
    let mut x113: u64 = 0;
    let mut x114: u64 = 0;
    let (x113, x114) = fiat_p224_scalar_mulx_u64(x111, 0xffffffff);
    let mut x115: u64 = 0;
    let mut x116: u64 = 0;
    let (x115, x116) = fiat_p224_scalar_mulx_u64(x111, 0xffffffffffffffff);
    let mut x117: u64 = 0;
    let mut x118: u64 = 0;
    let (x117, x118) = fiat_p224_scalar_mulx_u64(x111, 0xffff16a2e0b8f03e);
    let mut x119: u64 = 0;
    let mut x120: u64 = 0;
    let (x119, x120) = fiat_p224_scalar_mulx_u64(x111, 0x13dd29455c5c2a3d);
    let mut x121: u64 = 0;
    let mut x122: fiat_p224_scalar_u1 = 0;
    let (x121, x122) = fiat_p224_scalar_addcarryx_u64(0x0, x120, x117);
    let mut x123: u64 = 0;
    let mut x124: fiat_p224_scalar_u1 = 0;
    let (x123, x124) = fiat_p224_scalar_addcarryx_u64(x122, x118, x115);
    let mut x125: u64 = 0;
    let mut x126: fiat_p224_scalar_u1 = 0;
    let (x125, x126) = fiat_p224_scalar_addcarryx_u64(x124, x116, x113);
    let mut x127: u64 = 0;
    let mut x128: fiat_p224_scalar_u1 = 0;
    let (x127, x128) = fiat_p224_scalar_addcarryx_u64(0x0, x103, x119);
    let mut x129: u64 = 0;
    let mut x130: fiat_p224_scalar_u1 = 0;
    let (x129, x130) = fiat_p224_scalar_addcarryx_u64(x128, x105, x121);
    let mut x131: u64 = 0;
    let mut x132: fiat_p224_scalar_u1 = 0;
    let (x131, x132) = fiat_p224_scalar_addcarryx_u64(x130, x107, x123);
    let mut x133: u64 = 0;
    let mut x134: fiat_p224_scalar_u1 = 0;
    let (x133, x134) = fiat_p224_scalar_addcarryx_u64(x132, x109, x125);
    let mut x135: u64 = 0;
    let mut x136: u64 = 0;
    let (x135, x136) = fiat_p224_scalar_mulx_u64(x3, 0xb1e97961);
    let mut x137: u64 = 0;
    let mut x138: u64 = 0;
    let (x137, x138) = fiat_p224_scalar_mulx_u64(x3, 0x6ad15f7cd9714856);
    let mut x139: u64 = 0;
    let mut x140: u64 = 0;
    let (x139, x140) = fiat_p224_scalar_mulx_u64(x3, 0xabc8ff5931d63f4b);
    let mut x141: u64 = 0;
    let mut x142: u64 = 0;
    let (x141, x142) = fiat_p224_scalar_mulx_u64(x3, 0x29947a695f517d15);
    let mut x143: u64 = 0;
    let mut x144: fiat_p224_scalar_u1 = 0;
    let (x143, x144) = fiat_p224_scalar_addcarryx_u64(0x0, x142, x139);
    let mut x145: u64 = 0;
    let mut x146: fiat_p224_scalar_u1 = 0;
    let (x145, x146) = fiat_p224_scalar_addcarryx_u64(x144, x140, x137);
    let mut x147: u64 = 0;
    let mut x148: fiat_p224_scalar_u1 = 0;
    let (x147, x148) = fiat_p224_scalar_addcarryx_u64(x146, x138, x135);
    let mut x149: u64 = 0;
    let mut x150: fiat_p224_scalar_u1 = 0;
    let (x149, x150) = fiat_p224_scalar_addcarryx_u64(0x0, x129, x141);
    let mut x151: u64 = 0;
    let mut x152: fiat_p224_scalar_u1 = 0;
    let (x151, x152) = fiat_p224_scalar_addcarryx_u64(x150, x131, x143);
    let mut x153: u64 = 0;
    let mut x154: fiat_p224_scalar_u1 = 0;
    let (x153, x154) = fiat_p224_scalar_addcarryx_u64(x152, x133, x145);
    let mut x155: u64 = 0;
    let mut x156: fiat_p224_scalar_u1 = 0;
    let (x155, x156) = fiat_p224_scalar_addcarryx_u64(
        x154,
        (((x134 as u64) + ((x110 as u64) + ((x102 as u64) + x90))) + ((x126 as u64) + x114)),
        x147,
    );
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    let (x157, x158) = fiat_p224_scalar_mulx_u64(x149, 0xd6e242706a1fc2eb);
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    let (x159, x160) = fiat_p224_scalar_mulx_u64(x157, 0xffffffff);
    let mut x161: u64 = 0;
    let mut x162: u64 = 0;
    let (x161, x162) = fiat_p224_scalar_mulx_u64(x157, 0xffffffffffffffff);
    let mut x163: u64 = 0;
    let mut x164: u64 = 0;
    let (x163, x164) = fiat_p224_scalar_mulx_u64(x157, 0xffff16a2e0b8f03e);
    let mut x165: u64 = 0;
    let mut x166: u64 = 0;
    let (x165, x166) = fiat_p224_scalar_mulx_u64(x157, 0x13dd29455c5c2a3d);
    let mut x167: u64 = 0;
    let mut x168: fiat_p224_scalar_u1 = 0;
    let (x167, x168) = fiat_p224_scalar_addcarryx_u64(0x0, x166, x163);
    let mut x169: u64 = 0;
    let mut x170: fiat_p224_scalar_u1 = 0;
    let (x169, x170) = fiat_p224_scalar_addcarryx_u64(x168, x164, x161);
    let mut x171: u64 = 0;
    let mut x172: fiat_p224_scalar_u1 = 0;
    let (x171, x172) = fiat_p224_scalar_addcarryx_u64(x170, x162, x159);
    let mut x173: u64 = 0;
    let mut x174: fiat_p224_scalar_u1 = 0;
    let (x173, x174) = fiat_p224_scalar_addcarryx_u64(0x0, x149, x165);
    let mut x175: u64 = 0;
    let mut x176: fiat_p224_scalar_u1 = 0;
    let (x175, x176) = fiat_p224_scalar_addcarryx_u64(x174, x151, x167);
    let mut x177: u64 = 0;
    let mut x178: fiat_p224_scalar_u1 = 0;
    let (x177, x178) = fiat_p224_scalar_addcarryx_u64(x176, x153, x169);
    let mut x179: u64 = 0;
    let mut x180: fiat_p224_scalar_u1 = 0;
    let (x179, x180) = fiat_p224_scalar_addcarryx_u64(x178, x155, x171);
    let x181: u64 =
        (((x180 as u64) + ((x156 as u64) + ((x148 as u64) + x136))) + ((x172 as u64) + x160));
    let mut x182: u64 = 0;
    let mut x183: fiat_p224_scalar_u1 = 0;
    let (x182, x183) = fiat_p224_scalar_subborrowx_u64(0x0, x175, 0x13dd29455c5c2a3d);
    let mut x184: u64 = 0;
    let mut x185: fiat_p224_scalar_u1 = 0;
    let (x184, x185) = fiat_p224_scalar_subborrowx_u64(x183, x177, 0xffff16a2e0b8f03e);
    let mut x186: u64 = 0;
    let mut x187: fiat_p224_scalar_u1 = 0;
    let (x186, x187) = fiat_p224_scalar_subborrowx_u64(x185, x179, 0xffffffffffffffff);
    let mut x188: u64 = 0;
    let mut x189: fiat_p224_scalar_u1 = 0;
    let (x188, x189) = fiat_p224_scalar_subborrowx_u64(x187, x181, 0xffffffff);
    let mut x190: u64 = 0;
    let mut x191: fiat_p224_scalar_u1 = 0;
    let (x190, x191) = fiat_p224_scalar_subborrowx_u64(x189, (0x0 as u64), (0x0 as u64));
    let mut x192: u64 = 0;
    let (x192) = fiat_p224_scalar_cmovznz_u64(x191, x182, x175);
    let mut x193: u64 = 0;
    let (x193) = fiat_p224_scalar_cmovznz_u64(x191, x184, x177);
    let mut x194: u64 = 0;
    let (x194) = fiat_p224_scalar_cmovznz_u64(x191, x186, x179);
    let mut x195: u64 = 0;
    let (x195) = fiat_p224_scalar_cmovznz_u64(x191, x188, x181);
    out1[0] = x192;
    out1[1] = x193;
    out1[2] = x194;
    out1[3] = x195;
    out1
}
#[doc = " The function fiat_p224_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p224_scalar_nonzero(arg1: &[u64; 4]) -> u64 {
    let mut out1: u64 = 0;
    let x1: u64 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | (arg1[3]))));
    out1 = x1;
    out1
}
#[doc = " The function fiat_p224_scalar_selectznz is a multi-limb conditional select."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p224_scalar_selectznz(
    arg1: fiat_p224_scalar_u1,
    arg2: &[u64; 4],
    arg3: &[u64; 4],
) -> [u64; 4] {
    let mut out1: [u64; 4] = [0; 4];
    let mut x1: u64 = 0;
    let (x1) = fiat_p224_scalar_cmovznz_u64(arg1, (arg2[0]), (arg3[0]));
    let mut x2: u64 = 0;
    let (x2) = fiat_p224_scalar_cmovznz_u64(arg1, (arg2[1]), (arg3[1]));
    let mut x3: u64 = 0;
    let (x3) = fiat_p224_scalar_cmovznz_u64(arg1, (arg2[2]), (arg3[2]));
    let mut x4: u64 = 0;
    let (x4) = fiat_p224_scalar_cmovznz_u64(arg1, (arg2[3]), (arg3[3]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1
}
#[doc = " The function fiat_p224_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..27]"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[inline]
pub const fn fiat_p224_scalar_to_bytes(arg1: &[u64; 4]) -> [u8; 28] {
    let mut out1: [u8; 28] = [0; 28];
    let x1: u64 = (arg1[3]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[1]);
    let x4: u64 = (arg1[0]);
    let x5: u8 = ((x4 & (0xff as u64)) as u8);
    let x6: u64 = (x4 >> 8);
    let x7: u8 = ((x6 & (0xff as u64)) as u8);
    let x8: u64 = (x6 >> 8);
    let x9: u8 = ((x8 & (0xff as u64)) as u8);
    let x10: u64 = (x8 >> 8);
    let x11: u8 = ((x10 & (0xff as u64)) as u8);
    let x12: u64 = (x10 >> 8);
    let x13: u8 = ((x12 & (0xff as u64)) as u8);
    let x14: u64 = (x12 >> 8);
    let x15: u8 = ((x14 & (0xff as u64)) as u8);
    let x16: u64 = (x14 >> 8);
    let x17: u8 = ((x16 & (0xff as u64)) as u8);
    let x18: u8 = ((x16 >> 8) as u8);
    let x19: u8 = ((x3 & (0xff as u64)) as u8);
    let x20: u64 = (x3 >> 8);
    let x21: u8 = ((x20 & (0xff as u64)) as u8);
    let x22: u64 = (x20 >> 8);
    let x23: u8 = ((x22 & (0xff as u64)) as u8);
    let x24: u64 = (x22 >> 8);
    let x25: u8 = ((x24 & (0xff as u64)) as u8);
    let x26: u64 = (x24 >> 8);
    let x27: u8 = ((x26 & (0xff as u64)) as u8);
    let x28: u64 = (x26 >> 8);
    let x29: u8 = ((x28 & (0xff as u64)) as u8);
    let x30: u64 = (x28 >> 8);
    let x31: u8 = ((x30 & (0xff as u64)) as u8);
    let x32: u8 = ((x30 >> 8) as u8);
    let x33: u8 = ((x2 & (0xff as u64)) as u8);
    let x34: u64 = (x2 >> 8);
    let x35: u8 = ((x34 & (0xff as u64)) as u8);
    let x36: u64 = (x34 >> 8);
    let x37: u8 = ((x36 & (0xff as u64)) as u8);
    let x38: u64 = (x36 >> 8);
    let x39: u8 = ((x38 & (0xff as u64)) as u8);
    let x40: u64 = (x38 >> 8);
    let x41: u8 = ((x40 & (0xff as u64)) as u8);
    let x42: u64 = (x40 >> 8);
    let x43: u8 = ((x42 & (0xff as u64)) as u8);
    let x44: u64 = (x42 >> 8);
    let x45: u8 = ((x44 & (0xff as u64)) as u8);
    let x46: u8 = ((x44 >> 8) as u8);
    let x47: u8 = ((x1 & (0xff as u64)) as u8);
    let x48: u64 = (x1 >> 8);
    let x49: u8 = ((x48 & (0xff as u64)) as u8);
    let x50: u64 = (x48 >> 8);
    let x51: u8 = ((x50 & (0xff as u64)) as u8);
    let x52: u8 = ((x50 >> 8) as u8);
    out1[0] = x5;
    out1[1] = x7;
    out1[2] = x9;
    out1[3] = x11;
    out1[4] = x13;
    out1[5] = x15;
    out1[6] = x17;
    out1[7] = x18;
    out1[8] = x19;
    out1[9] = x21;
    out1[10] = x23;
    out1[11] = x25;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x39;
    out1[20] = x41;
    out1[21] = x43;
    out1[22] = x45;
    out1[23] = x46;
    out1[24] = x47;
    out1[25] = x49;
    out1[26] = x51;
    out1[27] = x52;
    out1
}
#[doc = " The function fiat_p224_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ bytes_eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = bytes_eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p224_scalar_from_bytes(arg1: &[u8; 28]) -> [u64; 4] {
    let mut out1: [u64; 4] = [0; 4];
    let x1: u64 = (((arg1[27]) as u64) << 24);
    let x2: u64 = (((arg1[26]) as u64) << 16);
    let x3: u64 = (((arg1[25]) as u64) << 8);
    let x4: u8 = (arg1[24]);
    let x5: u64 = (((arg1[23]) as u64) << 56);
    let x6: u64 = (((arg1[22]) as u64) << 48);
    let x7: u64 = (((arg1[21]) as u64) << 40);
    let x8: u64 = (((arg1[20]) as u64) << 32);
    let x9: u64 = (((arg1[19]) as u64) << 24);
    let x10: u64 = (((arg1[18]) as u64) << 16);
    let x11: u64 = (((arg1[17]) as u64) << 8);
    let x12: u8 = (arg1[16]);
    let x13: u64 = (((arg1[15]) as u64) << 56);
    let x14: u64 = (((arg1[14]) as u64) << 48);
    let x15: u64 = (((arg1[13]) as u64) << 40);
    let x16: u64 = (((arg1[12]) as u64) << 32);
    let x17: u64 = (((arg1[11]) as u64) << 24);
    let x18: u64 = (((arg1[10]) as u64) << 16);
    let x19: u64 = (((arg1[9]) as u64) << 8);
    let x20: u8 = (arg1[8]);
    let x21: u64 = (((arg1[7]) as u64) << 56);
    let x22: u64 = (((arg1[6]) as u64) << 48);
    let x23: u64 = (((arg1[5]) as u64) << 40);
    let x24: u64 = (((arg1[4]) as u64) << 32);
    let x25: u64 = (((arg1[3]) as u64) << 24);
    let x26: u64 = (((arg1[2]) as u64) << 16);
    let x27: u64 = (((arg1[1]) as u64) << 8);
    let x28: u8 = (arg1[0]);
    let x29: u64 = (x27 + (x28 as u64));
    let x30: u64 = (x26 + x29);
    let x31: u64 = (x25 + x30);
    let x32: u64 = (x24 + x31);
    let x33: u64 = (x23 + x32);
    let x34: u64 = (x22 + x33);
    let x35: u64 = (x21 + x34);
    let x36: u64 = (x19 + (x20 as u64));
    let x37: u64 = (x18 + x36);
    let x38: u64 = (x17 + x37);
    let x39: u64 = (x16 + x38);
    let x40: u64 = (x15 + x39);
    let x41: u64 = (x14 + x40);
    let x42: u64 = (x13 + x41);
    let x43: u64 = (x11 + (x12 as u64));
    let x44: u64 = (x10 + x43);
    let x45: u64 = (x9 + x44);
    let x46: u64 = (x8 + x45);
    let x47: u64 = (x7 + x46);
    let x48: u64 = (x6 + x47);
    let x49: u64 = (x5 + x48);
    let x50: u64 = (x3 + (x4 as u64));
    let x51: u64 = (x2 + x50);
    let x52: u64 = (x1 + x51);
    out1[0] = x35;
    out1[1] = x42;
    out1[2] = x49;
    out1[3] = x52;
    out1
}
#[doc = " The function fiat_p224_scalar_set_one returns the field element one in the Montgomery domain."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = 1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_scalar_set_one() -> fiat_p224_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p224_scalar_montgomery_domain_field_element = [0; 4];
    out1[0] = 0xa3a3d5c300000000;
    out1[1] = 0x1f470fc1ec22d6ba;
    out1[2] = 0xe95d;
    out1[3] = (0x0 as u64);
    out1
}
#[doc = " The function fiat_p224_scalar_msat returns the saturated representation of the prime modulus."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   twos_complement_eval out1 = m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p224_scalar_msat() -> [u64; 5] {
    let mut out1: [u64; 5] = [0; 5];
    out1[0] = 0x13dd29455c5c2a3d;
    out1[1] = 0xffff16a2e0b8f03e;
    out1[2] = 0xffffffffffffffff;
    out1[3] = 0xffffffff;
    out1[4] = (0x0 as u64);
    out1
}
#[doc = " The function fiat_p224_scalar_divstep computes a divstep."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg4 < m"]
#[doc = "   0 ≤ eval arg5 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)"]
#[doc = "   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)"]
#[doc = "   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)"]
#[doc = "   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)"]
#[doc = "   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out2 < m"]
#[doc = "   0 ≤ eval out3 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p224_scalar_divstep(
    arg1: u64,
    arg2: &[u64; 5],
    arg3: &[u64; 5],
    arg4: &[u64; 4],
    arg5: &[u64; 4],
) -> (u64, [u64; 5], [u64; 5], [u64; 4], [u64; 4]) {
    let mut out1: u64 = 0;
    let mut out2: [u64; 5] = [0; 5];
    let mut out3: [u64; 5] = [0; 5];
    let mut out4: [u64; 4] = [0; 4];
    let mut out5: [u64; 4] = [0; 4];
    let mut x1: u64 = 0;
    let mut x2: fiat_p224_scalar_u1 = 0;
    let (x1, x2) = fiat_p224_scalar_addcarryx_u64(0x0, (!arg1), (0x1 as u64));
    let x3: fiat_p224_scalar_u1 =
        (((x1 >> 63) as fiat_p224_scalar_u1) & (((arg3[0]) & (0x1 as u64)) as fiat_p224_scalar_u1));
    let mut x4: u64 = 0;
    let mut x5: fiat_p224_scalar_u1 = 0;
    let (x4, x5) = fiat_p224_scalar_addcarryx_u64(0x0, (!arg1), (0x1 as u64));
    let mut x6: u64 = 0;
    let (x6) = fiat_p224_scalar_cmovznz_u64(x3, arg1, x4);
    let mut x7: u64 = 0;
    let (x7) = fiat_p224_scalar_cmovznz_u64(x3, (arg2[0]), (arg3[0]));
    let mut x8: u64 = 0;
    let (x8) = fiat_p224_scalar_cmovznz_u64(x3, (arg2[1]), (arg3[1]));
    let mut x9: u64 = 0;
    let (x9) = fiat_p224_scalar_cmovznz_u64(x3, (arg2[2]), (arg3[2]));
    let mut x10: u64 = 0;
    let (x10) = fiat_p224_scalar_cmovznz_u64(x3, (arg2[3]), (arg3[3]));
    let mut x11: u64 = 0;
    let (x11) = fiat_p224_scalar_cmovznz_u64(x3, (arg2[4]), (arg3[4]));
    let mut x12: u64 = 0;
    let mut x13: fiat_p224_scalar_u1 = 0;
    let (x12, x13) = fiat_p224_scalar_addcarryx_u64(0x0, (0x1 as u64), (!(arg2[0])));
    let mut x14: u64 = 0;
    let mut x15: fiat_p224_scalar_u1 = 0;
    let (x14, x15) = fiat_p224_scalar_addcarryx_u64(x13, (0x0 as u64), (!(arg2[1])));
    let mut x16: u64 = 0;
    let mut x17: fiat_p224_scalar_u1 = 0;
    let (x16, x17) = fiat_p224_scalar_addcarryx_u64(x15, (0x0 as u64), (!(arg2[2])));
    let mut x18: u64 = 0;
    let mut x19: fiat_p224_scalar_u1 = 0;
    let (x18, x19) = fiat_p224_scalar_addcarryx_u64(x17, (0x0 as u64), (!(arg2[3])));
    let mut x20: u64 = 0;
    let mut x21: fiat_p224_scalar_u1 = 0;
    let (x20, x21) = fiat_p224_scalar_addcarryx_u64(x19, (0x0 as u64), (!(arg2[4])));
    let mut x22: u64 = 0;
    let (x22) = fiat_p224_scalar_cmovznz_u64(x3, (arg3[0]), x12);
    let mut x23: u64 = 0;
    let (x23) = fiat_p224_scalar_cmovznz_u64(x3, (arg3[1]), x14);
    let mut x24: u64 = 0;
    let (x24) = fiat_p224_scalar_cmovznz_u64(x3, (arg3[2]), x16);
    let mut x25: u64 = 0;
    let (x25) = fiat_p224_scalar_cmovznz_u64(x3, (arg3[3]), x18);
    let mut x26: u64 = 0;
    let (x26) = fiat_p224_scalar_cmovznz_u64(x3, (arg3[4]), x20);
    let mut x27: u64 = 0;
    let (x27) = fiat_p224_scalar_cmovznz_u64(x3, (arg4[0]), (arg5[0]));
    let mut x28: u64 = 0;
    let (x28) = fiat_p224_scalar_cmovznz_u64(x3, (arg4[1]), (arg5[1]));
    let mut x29: u64 = 0;
    let (x29) = fiat_p224_scalar_cmovznz_u64(x3, (arg4[2]), (arg5[2]));
    let mut x30: u64 = 0;
    let (x30) = fiat_p224_scalar_cmovznz_u64(x3, (arg4[3]), (arg5[3]));
    let mut x31: u64 = 0;
    let mut x32: fiat_p224_scalar_u1 = 0;
    let (x31, x32) = fiat_p224_scalar_addcarryx_u64(0x0, x27, x27);
    let mut x33: u64 = 0;
    let mut x34: fiat_p224_scalar_u1 = 0;
    let (x33, x34) = fiat_p224_scalar_addcarryx_u64(x32, x28, x28);
    let mut x35: u64 = 0;
    let mut x36: fiat_p224_scalar_u1 = 0;
    let (x35, x36) = fiat_p224_scalar_addcarryx_u64(x34, x29, x29);
    let mut x37: u64 = 0;
    let mut x38: fiat_p224_scalar_u1 = 0;
    let (x37, x38) = fiat_p224_scalar_addcarryx_u64(x36, x30, x30);
    let mut x39: u64 = 0;
    let mut x40: fiat_p224_scalar_u1 = 0;
    let (x39, x40) = fiat_p224_scalar_subborrowx_u64(0x0, x31, 0x13dd29455c5c2a3d);
    let mut x41: u64 = 0;
    let mut x42: fiat_p224_scalar_u1 = 0;
    let (x41, x42) = fiat_p224_scalar_subborrowx_u64(x40, x33, 0xffff16a2e0b8f03e);
    let mut x43: u64 = 0;
    let mut x44: fiat_p224_scalar_u1 = 0;
    let (x43, x44) = fiat_p224_scalar_subborrowx_u64(x42, x35, 0xffffffffffffffff);
    let mut x45: u64 = 0;
    let mut x46: fiat_p224_scalar_u1 = 0;
    let (x45, x46) = fiat_p224_scalar_subborrowx_u64(x44, x37, 0xffffffff);
    let mut x47: u64 = 0;
    let mut x48: fiat_p224_scalar_u1 = 0;
    let (x47, x48) = fiat_p224_scalar_subborrowx_u64(x46, (x38 as u64), (0x0 as u64));
    let x49: u64 = (arg4[3]);
    let x50: u64 = (arg4[2]);
    let x51: u64 = (arg4[1]);
    let x52: u64 = (arg4[0]);
    let mut x53: u64 = 0;
    let mut x54: fiat_p224_scalar_u1 = 0;
    let (x53, x54) = fiat_p224_scalar_subborrowx_u64(0x0, (0x0 as u64), x52);
    let mut x55: u64 = 0;
    let mut x56: fiat_p224_scalar_u1 = 0;
    let (x55, x56) = fiat_p224_scalar_subborrowx_u64(x54, (0x0 as u64), x51);
    let mut x57: u64 = 0;
    let mut x58: fiat_p224_scalar_u1 = 0;
    let (x57, x58) = fiat_p224_scalar_subborrowx_u64(x56, (0x0 as u64), x50);
    let mut x59: u64 = 0;
    let mut x60: fiat_p224_scalar_u1 = 0;
    let (x59, x60) = fiat_p224_scalar_subborrowx_u64(x58, (0x0 as u64), x49);
    let mut x61: u64 = 0;
    let (x61) = fiat_p224_scalar_cmovznz_u64(x60, (0x0 as u64), 0xffffffffffffffff);
    let mut x62: u64 = 0;
    let mut x63: fiat_p224_scalar_u1 = 0;
    let (x62, x63) = fiat_p224_scalar_addcarryx_u64(0x0, x53, (x61 & 0x13dd29455c5c2a3d));
    let mut x64: u64 = 0;
    let mut x65: fiat_p224_scalar_u1 = 0;
    let (x64, x65) = fiat_p224_scalar_addcarryx_u64(x63, x55, (x61 & 0xffff16a2e0b8f03e));
    let mut x66: u64 = 0;
    let mut x67: fiat_p224_scalar_u1 = 0;
    let (x66, x67) = fiat_p224_scalar_addcarryx_u64(x65, x57, x61);
    let mut x68: u64 = 0;
    let mut x69: fiat_p224_scalar_u1 = 0;
    let (x68, x69) = fiat_p224_scalar_addcarryx_u64(x67, x59, (x61 & 0xffffffff));
    let mut x70: u64 = 0;
    let (x70) = fiat_p224_scalar_cmovznz_u64(x3, (arg5[0]), x62);
    let mut x71: u64 = 0;
    let (x71) = fiat_p224_scalar_cmovznz_u64(x3, (arg5[1]), x64);
    let mut x72: u64 = 0;
    let (x72) = fiat_p224_scalar_cmovznz_u64(x3, (arg5[2]), x66);
    let mut x73: u64 = 0;
    let (x73) = fiat_p224_scalar_cmovznz_u64(x3, (arg5[3]), x68);
    let x74: fiat_p224_scalar_u1 = ((x22 & (0x1 as u64)) as fiat_p224_scalar_u1);
    let mut x75: u64 = 0;
    let (x75) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x7);
    let mut x76: u64 = 0;
    let (x76) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x8);
    let mut x77: u64 = 0;
    let (x77) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x9);
    let mut x78: u64 = 0;
    let (x78) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x10);
    let mut x79: u64 = 0;
    let (x79) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x11);
    let mut x80: u64 = 0;
    let mut x81: fiat_p224_scalar_u1 = 0;
    let (x80, x81) = fiat_p224_scalar_addcarryx_u64(0x0, x22, x75);
    let mut x82: u64 = 0;
    let mut x83: fiat_p224_scalar_u1 = 0;
    let (x82, x83) = fiat_p224_scalar_addcarryx_u64(x81, x23, x76);
    let mut x84: u64 = 0;
    let mut x85: fiat_p224_scalar_u1 = 0;
    let (x84, x85) = fiat_p224_scalar_addcarryx_u64(x83, x24, x77);
    let mut x86: u64 = 0;
    let mut x87: fiat_p224_scalar_u1 = 0;
    let (x86, x87) = fiat_p224_scalar_addcarryx_u64(x85, x25, x78);
    let mut x88: u64 = 0;
    let mut x89: fiat_p224_scalar_u1 = 0;
    let (x88, x89) = fiat_p224_scalar_addcarryx_u64(x87, x26, x79);
    let mut x90: u64 = 0;
    let (x90) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x27);
    let mut x91: u64 = 0;
    let (x91) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x28);
    let mut x92: u64 = 0;
    let (x92) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x29);
    let mut x93: u64 = 0;
    let (x93) = fiat_p224_scalar_cmovznz_u64(x74, (0x0 as u64), x30);
    let mut x94: u64 = 0;
    let mut x95: fiat_p224_scalar_u1 = 0;
    let (x94, x95) = fiat_p224_scalar_addcarryx_u64(0x0, x70, x90);
    let mut x96: u64 = 0;
    let mut x97: fiat_p224_scalar_u1 = 0;
    let (x96, x97) = fiat_p224_scalar_addcarryx_u64(x95, x71, x91);
    let mut x98: u64 = 0;
    let mut x99: fiat_p224_scalar_u1 = 0;
    let (x98, x99) = fiat_p224_scalar_addcarryx_u64(x97, x72, x92);
    let mut x100: u64 = 0;
    let mut x101: fiat_p224_scalar_u1 = 0;
    let (x100, x101) = fiat_p224_scalar_addcarryx_u64(x99, x73, x93);
    let mut x102: u64 = 0;
    let mut x103: fiat_p224_scalar_u1 = 0;
    let (x102, x103) = fiat_p224_scalar_subborrowx_u64(0x0, x94, 0x13dd29455c5c2a3d);
    let mut x104: u64 = 0;
    let mut x105: fiat_p224_scalar_u1 = 0;
    let (x104, x105) = fiat_p224_scalar_subborrowx_u64(x103, x96, 0xffff16a2e0b8f03e);
    let mut x106: u64 = 0;
    let mut x107: fiat_p224_scalar_u1 = 0;
    let (x106, x107) = fiat_p224_scalar_subborrowx_u64(x105, x98, 0xffffffffffffffff);
    let mut x108: u64 = 0;
    let mut x109: fiat_p224_scalar_u1 = 0;
    let (x108, x109) = fiat_p224_scalar_subborrowx_u64(x107, x100, 0xffffffff);
    let mut x110: u64 = 0;
    let mut x111: fiat_p224_scalar_u1 = 0;
    let (x110, x111) = fiat_p224_scalar_subborrowx_u64(x109, (x101 as u64), (0x0 as u64));
    let mut x112: u64 = 0;
    let mut x113: fiat_p224_scalar_u1 = 0;
    let (x112, x113) = fiat_p224_scalar_addcarryx_u64(0x0, x6, (0x1 as u64));
    let x114: u64 = ((x80 >> 1) | ((x82 << 63) & 0xffffffffffffffff));
    let x115: u64 = ((x82 >> 1) | ((x84 << 63) & 0xffffffffffffffff));
    let x116: u64 = ((x84 >> 1) | ((x86 << 63) & 0xffffffffffffffff));
    let x117: u64 = ((x86 >> 1) | ((x88 << 63) & 0xffffffffffffffff));
    let x118: u64 = ((x88 & 0x8000000000000000) | (x88 >> 1));
    let mut x119: u64 = 0;
    let (x119) = fiat_p224_scalar_cmovznz_u64(x48, x39, x31);
    let mut x120: u64 = 0;
    let (x120) = fiat_p224_scalar_cmovznz_u64(x48, x41, x33);
    let mut x121: u64 = 0;
    let (x121) = fiat_p224_scalar_cmovznz_u64(x48, x43, x35);
    let mut x122: u64 = 0;
    let (x122) = fiat_p224_scalar_cmovznz_u64(x48, x45, x37);
    let mut x123: u64 = 0;
    let (x123) = fiat_p224_scalar_cmovznz_u64(x111, x102, x94);
    let mut x124: u64 = 0;
    let (x124) = fiat_p224_scalar_cmovznz_u64(x111, x104, x96);
    let mut x125: u64 = 0;
    let (x125) = fiat_p224_scalar_cmovznz_u64(x111, x106, x98);
    let mut x126: u64 = 0;
    let (x126) = fiat_p224_scalar_cmovznz_u64(x111, x108, x100);
    out1 = x112;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out3[0] = x114;
    out3[1] = x115;
    out3[2] = x116;
    out3[3] = x117;
    out3[4] = x118;
    out4[0] = x119;
    out4[1] = x120;
    out4[2] = x121;
    out4[3] = x122;
    out5[0] = x123;
    out5[1] = x124;
    out5[2] = x125;
    out5[3] = x126;
    (out1, out2, out3, out4, out5)
}
#[doc = " The function fiat_p224_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form)."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p224_scalar_divstep_precomp() -> [u64; 4] {
    let mut out1: [u64; 4] = [0; 4];
    out1[0] = 0x74ecb6e5a4954cc;
    out1[1] = 0x26a7844030955df6;
    out1[2] = 0xef16fedba3350f94;
    out1[3] = 0x4704d6d8;
    out1
}
