#![doc = " fiat-crypto output postprocessed by fiat-constify: https://github.com/rustcrypto/utils"]
#![doc = " Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p224 32 '2^224 - 2^96 + 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp"]
#![doc = " curve description: p224"]
#![doc = " machine_wordsize = 32 (from \"32\")"]
#![doc = " requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp"]
#![doc = " m = 0xffffffffffffffffffffffffffffffff000000000000000000000001 (from \"2^224 - 2^96 + 1\")"]
#![doc = ""]
#![doc = " NOTE: In addition to the bounds specified above each function, all"]
#![doc = "   functions synthesized for this Montgomery arithmetic require the"]
#![doc = "   input to be strictly less than the prime modulus (m), and also"]
#![doc = "   require the input to be in the unique saturated representation."]
#![doc = "   All functions also ensure that these two properties are true of"]
#![doc = "   return values."]
#![doc = ""]
#![doc = " Computed values:"]
#![doc = "   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192)"]
#![doc = "   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216)"]
#![doc = "   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) in"]
#![doc = "                            if x1 & (2^224-1) < 2^223 then x1 & (2^224-1) else (x1 & (2^224-1)) - 2^224"]
#![allow(unused_parens)]
#![allow(non_camel_case_types)]
#![allow(
    clippy::identity_op,
    clippy::unnecessary_cast,
    dead_code,
    rustdoc::broken_intra_doc_links,
    unused_assignments,
    unused_mut,
    unused_variables
)]
pub type fiat_p224_u1 = u8;
pub type fiat_p224_i1 = i8;
pub type fiat_p224_u2 = u8;
pub type fiat_p224_i2 = i8;
pub type fiat_p224_montgomery_domain_field_element = [u32; 7];
pub type fiat_p224_non_montgomery_domain_field_element = [u32; 7];
#[doc = " The function fiat_p224_addcarryx_u32 is an addition with carry."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 + arg2 + arg3) mod 2^32"]
#[doc = "   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p224_addcarryx_u32(
    arg1: fiat_p224_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p224_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p224_u1 = 0;
    let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: fiat_p224_u1 = ((x1 >> 32) as fiat_p224_u1);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p224_subborrowx_u32 is a subtraction with borrow."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (-arg1 + arg2 + -arg3) mod 2^32"]
#[doc = "   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p224_subborrowx_u32(
    arg1: fiat_p224_u1,
    arg2: u32,
    arg3: u32,
) -> (u32, fiat_p224_u1) {
    let mut out1: u32 = 0;
    let mut out2: fiat_p224_u1 = 0;
    let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
    let x2: fiat_p224_i1 = ((x1 >> 32) as fiat_p224_i1);
    let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
    out1 = x3;
    out2 = (((0x0 as fiat_p224_i2) - (x2 as fiat_p224_i2)) as fiat_p224_u1);
    (out1, out2)
}
#[doc = " The function fiat_p224_mulx_u32 is a multiplication, returning the full double-width result."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 * arg2) mod 2^32"]
#[doc = "   out2 = ⌊arg1 * arg2 / 2^32⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p224_mulx_u32(arg1: u32, arg2: u32) -> (u32, u32) {
    let mut out1: u32 = 0;
    let mut out2: u32 = 0;
    let x1: u64 = ((arg1 as u64) * (arg2 as u64));
    let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
    let x3: u32 = ((x1 >> 32) as u32);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p224_cmovznz_u32 is a single-word conditional move."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p224_cmovznz_u32(arg1: fiat_p224_u1, arg2: u32, arg3: u32) -> u32 {
    let mut out1: u32 = 0;
    let x1: fiat_p224_u1 = (!(!arg1));
    let x2: u32 = ((((((0x0 as fiat_p224_i2) - (x1 as fiat_p224_i2)) as fiat_p224_i1) as i64)
        & (0xffffffff as i64)) as u32);
    let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
    out1 = x3;
    out1
}
#[doc = " The function fiat_p224_mul multiplies two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_mul(
    arg1: &fiat_p224_montgomery_domain_field_element,
    arg2: &fiat_p224_montgomery_domain_field_element,
) -> fiat_p224_montgomery_domain_field_element {
    let mut out1: fiat_p224_montgomery_domain_field_element = [0; 7];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[0]);
    let mut x8: u32 = 0;
    let mut x9: u32 = 0;
    let (x8, x9) = fiat_p224_mulx_u32(x7, (arg2[6]));
    let mut x10: u32 = 0;
    let mut x11: u32 = 0;
    let (x10, x11) = fiat_p224_mulx_u32(x7, (arg2[5]));
    let mut x12: u32 = 0;
    let mut x13: u32 = 0;
    let (x12, x13) = fiat_p224_mulx_u32(x7, (arg2[4]));
    let mut x14: u32 = 0;
    let mut x15: u32 = 0;
    let (x14, x15) = fiat_p224_mulx_u32(x7, (arg2[3]));
    let mut x16: u32 = 0;
    let mut x17: u32 = 0;
    let (x16, x17) = fiat_p224_mulx_u32(x7, (arg2[2]));
    let mut x18: u32 = 0;
    let mut x19: u32 = 0;
    let (x18, x19) = fiat_p224_mulx_u32(x7, (arg2[1]));
    let mut x20: u32 = 0;
    let mut x21: u32 = 0;
    let (x20, x21) = fiat_p224_mulx_u32(x7, (arg2[0]));
    let mut x22: u32 = 0;
    let mut x23: fiat_p224_u1 = 0;
    let (x22, x23) = fiat_p224_addcarryx_u32(0x0, x21, x18);
    let mut x24: u32 = 0;
    let mut x25: fiat_p224_u1 = 0;
    let (x24, x25) = fiat_p224_addcarryx_u32(x23, x19, x16);
    let mut x26: u32 = 0;
    let mut x27: fiat_p224_u1 = 0;
    let (x26, x27) = fiat_p224_addcarryx_u32(x25, x17, x14);
    let mut x28: u32 = 0;
    let mut x29: fiat_p224_u1 = 0;
    let (x28, x29) = fiat_p224_addcarryx_u32(x27, x15, x12);
    let mut x30: u32 = 0;
    let mut x31: fiat_p224_u1 = 0;
    let (x30, x31) = fiat_p224_addcarryx_u32(x29, x13, x10);
    let mut x32: u32 = 0;
    let mut x33: fiat_p224_u1 = 0;
    let (x32, x33) = fiat_p224_addcarryx_u32(x31, x11, x8);
    let x34: u32 = ((x33 as u32) + x9);
    let mut x35: u32 = 0;
    let mut x36: u32 = 0;
    let (x35, x36) = fiat_p224_mulx_u32(x20, 0xffffffff);
    let mut x37: u32 = 0;
    let mut x38: u32 = 0;
    let (x37, x38) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x39: u32 = 0;
    let mut x40: u32 = 0;
    let (x39, x40) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x41: u32 = 0;
    let mut x42: u32 = 0;
    let (x41, x42) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x43: u32 = 0;
    let mut x44: u32 = 0;
    let (x43, x44) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x45: u32 = 0;
    let mut x46: fiat_p224_u1 = 0;
    let (x45, x46) = fiat_p224_addcarryx_u32(0x0, x44, x41);
    let mut x47: u32 = 0;
    let mut x48: fiat_p224_u1 = 0;
    let (x47, x48) = fiat_p224_addcarryx_u32(x46, x42, x39);
    let mut x49: u32 = 0;
    let mut x50: fiat_p224_u1 = 0;
    let (x49, x50) = fiat_p224_addcarryx_u32(x48, x40, x37);
    let x51: u32 = ((x50 as u32) + x38);
    let mut x52: u32 = 0;
    let mut x53: fiat_p224_u1 = 0;
    let (x52, x53) = fiat_p224_addcarryx_u32(0x0, x20, x35);
    let mut x54: u32 = 0;
    let mut x55: fiat_p224_u1 = 0;
    let (x54, x55) = fiat_p224_addcarryx_u32(x53, x22, (0x0 as u32));
    let mut x56: u32 = 0;
    let mut x57: fiat_p224_u1 = 0;
    let (x56, x57) = fiat_p224_addcarryx_u32(x55, x24, (0x0 as u32));
    let mut x58: u32 = 0;
    let mut x59: fiat_p224_u1 = 0;
    let (x58, x59) = fiat_p224_addcarryx_u32(x57, x26, x43);
    let mut x60: u32 = 0;
    let mut x61: fiat_p224_u1 = 0;
    let (x60, x61) = fiat_p224_addcarryx_u32(x59, x28, x45);
    let mut x62: u32 = 0;
    let mut x63: fiat_p224_u1 = 0;
    let (x62, x63) = fiat_p224_addcarryx_u32(x61, x30, x47);
    let mut x64: u32 = 0;
    let mut x65: fiat_p224_u1 = 0;
    let (x64, x65) = fiat_p224_addcarryx_u32(x63, x32, x49);
    let mut x66: u32 = 0;
    let mut x67: fiat_p224_u1 = 0;
    let (x66, x67) = fiat_p224_addcarryx_u32(x65, x34, x51);
    let mut x68: u32 = 0;
    let mut x69: u32 = 0;
    let (x68, x69) = fiat_p224_mulx_u32(x1, (arg2[6]));
    let mut x70: u32 = 0;
    let mut x71: u32 = 0;
    let (x70, x71) = fiat_p224_mulx_u32(x1, (arg2[5]));
    let mut x72: u32 = 0;
    let mut x73: u32 = 0;
    let (x72, x73) = fiat_p224_mulx_u32(x1, (arg2[4]));
    let mut x74: u32 = 0;
    let mut x75: u32 = 0;
    let (x74, x75) = fiat_p224_mulx_u32(x1, (arg2[3]));
    let mut x76: u32 = 0;
    let mut x77: u32 = 0;
    let (x76, x77) = fiat_p224_mulx_u32(x1, (arg2[2]));
    let mut x78: u32 = 0;
    let mut x79: u32 = 0;
    let (x78, x79) = fiat_p224_mulx_u32(x1, (arg2[1]));
    let mut x80: u32 = 0;
    let mut x81: u32 = 0;
    let (x80, x81) = fiat_p224_mulx_u32(x1, (arg2[0]));
    let mut x82: u32 = 0;
    let mut x83: fiat_p224_u1 = 0;
    let (x82, x83) = fiat_p224_addcarryx_u32(0x0, x81, x78);
    let mut x84: u32 = 0;
    let mut x85: fiat_p224_u1 = 0;
    let (x84, x85) = fiat_p224_addcarryx_u32(x83, x79, x76);
    let mut x86: u32 = 0;
    let mut x87: fiat_p224_u1 = 0;
    let (x86, x87) = fiat_p224_addcarryx_u32(x85, x77, x74);
    let mut x88: u32 = 0;
    let mut x89: fiat_p224_u1 = 0;
    let (x88, x89) = fiat_p224_addcarryx_u32(x87, x75, x72);
    let mut x90: u32 = 0;
    let mut x91: fiat_p224_u1 = 0;
    let (x90, x91) = fiat_p224_addcarryx_u32(x89, x73, x70);
    let mut x92: u32 = 0;
    let mut x93: fiat_p224_u1 = 0;
    let (x92, x93) = fiat_p224_addcarryx_u32(x91, x71, x68);
    let x94: u32 = ((x93 as u32) + x69);
    let mut x95: u32 = 0;
    let mut x96: fiat_p224_u1 = 0;
    let (x95, x96) = fiat_p224_addcarryx_u32(0x0, x54, x80);
    let mut x97: u32 = 0;
    let mut x98: fiat_p224_u1 = 0;
    let (x97, x98) = fiat_p224_addcarryx_u32(x96, x56, x82);
    let mut x99: u32 = 0;
    let mut x100: fiat_p224_u1 = 0;
    let (x99, x100) = fiat_p224_addcarryx_u32(x98, x58, x84);
    let mut x101: u32 = 0;
    let mut x102: fiat_p224_u1 = 0;
    let (x101, x102) = fiat_p224_addcarryx_u32(x100, x60, x86);
    let mut x103: u32 = 0;
    let mut x104: fiat_p224_u1 = 0;
    let (x103, x104) = fiat_p224_addcarryx_u32(x102, x62, x88);
    let mut x105: u32 = 0;
    let mut x106: fiat_p224_u1 = 0;
    let (x105, x106) = fiat_p224_addcarryx_u32(x104, x64, x90);
    let mut x107: u32 = 0;
    let mut x108: fiat_p224_u1 = 0;
    let (x107, x108) = fiat_p224_addcarryx_u32(x106, x66, x92);
    let mut x109: u32 = 0;
    let mut x110: fiat_p224_u1 = 0;
    let (x109, x110) = fiat_p224_addcarryx_u32(x108, (x67 as u32), x94);
    let mut x111: u32 = 0;
    let mut x112: u32 = 0;
    let (x111, x112) = fiat_p224_mulx_u32(x95, 0xffffffff);
    let mut x113: u32 = 0;
    let mut x114: u32 = 0;
    let (x113, x114) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x115: u32 = 0;
    let mut x116: u32 = 0;
    let (x115, x116) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x117: u32 = 0;
    let mut x118: u32 = 0;
    let (x117, x118) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x119: u32 = 0;
    let mut x120: u32 = 0;
    let (x119, x120) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x121: u32 = 0;
    let mut x122: fiat_p224_u1 = 0;
    let (x121, x122) = fiat_p224_addcarryx_u32(0x0, x120, x117);
    let mut x123: u32 = 0;
    let mut x124: fiat_p224_u1 = 0;
    let (x123, x124) = fiat_p224_addcarryx_u32(x122, x118, x115);
    let mut x125: u32 = 0;
    let mut x126: fiat_p224_u1 = 0;
    let (x125, x126) = fiat_p224_addcarryx_u32(x124, x116, x113);
    let x127: u32 = ((x126 as u32) + x114);
    let mut x128: u32 = 0;
    let mut x129: fiat_p224_u1 = 0;
    let (x128, x129) = fiat_p224_addcarryx_u32(0x0, x95, x111);
    let mut x130: u32 = 0;
    let mut x131: fiat_p224_u1 = 0;
    let (x130, x131) = fiat_p224_addcarryx_u32(x129, x97, (0x0 as u32));
    let mut x132: u32 = 0;
    let mut x133: fiat_p224_u1 = 0;
    let (x132, x133) = fiat_p224_addcarryx_u32(x131, x99, (0x0 as u32));
    let mut x134: u32 = 0;
    let mut x135: fiat_p224_u1 = 0;
    let (x134, x135) = fiat_p224_addcarryx_u32(x133, x101, x119);
    let mut x136: u32 = 0;
    let mut x137: fiat_p224_u1 = 0;
    let (x136, x137) = fiat_p224_addcarryx_u32(x135, x103, x121);
    let mut x138: u32 = 0;
    let mut x139: fiat_p224_u1 = 0;
    let (x138, x139) = fiat_p224_addcarryx_u32(x137, x105, x123);
    let mut x140: u32 = 0;
    let mut x141: fiat_p224_u1 = 0;
    let (x140, x141) = fiat_p224_addcarryx_u32(x139, x107, x125);
    let mut x142: u32 = 0;
    let mut x143: fiat_p224_u1 = 0;
    let (x142, x143) = fiat_p224_addcarryx_u32(x141, x109, x127);
    let x144: u32 = ((x143 as u32) + (x110 as u32));
    let mut x145: u32 = 0;
    let mut x146: u32 = 0;
    let (x145, x146) = fiat_p224_mulx_u32(x2, (arg2[6]));
    let mut x147: u32 = 0;
    let mut x148: u32 = 0;
    let (x147, x148) = fiat_p224_mulx_u32(x2, (arg2[5]));
    let mut x149: u32 = 0;
    let mut x150: u32 = 0;
    let (x149, x150) = fiat_p224_mulx_u32(x2, (arg2[4]));
    let mut x151: u32 = 0;
    let mut x152: u32 = 0;
    let (x151, x152) = fiat_p224_mulx_u32(x2, (arg2[3]));
    let mut x153: u32 = 0;
    let mut x154: u32 = 0;
    let (x153, x154) = fiat_p224_mulx_u32(x2, (arg2[2]));
    let mut x155: u32 = 0;
    let mut x156: u32 = 0;
    let (x155, x156) = fiat_p224_mulx_u32(x2, (arg2[1]));
    let mut x157: u32 = 0;
    let mut x158: u32 = 0;
    let (x157, x158) = fiat_p224_mulx_u32(x2, (arg2[0]));
    let mut x159: u32 = 0;
    let mut x160: fiat_p224_u1 = 0;
    let (x159, x160) = fiat_p224_addcarryx_u32(0x0, x158, x155);
    let mut x161: u32 = 0;
    let mut x162: fiat_p224_u1 = 0;
    let (x161, x162) = fiat_p224_addcarryx_u32(x160, x156, x153);
    let mut x163: u32 = 0;
    let mut x164: fiat_p224_u1 = 0;
    let (x163, x164) = fiat_p224_addcarryx_u32(x162, x154, x151);
    let mut x165: u32 = 0;
    let mut x166: fiat_p224_u1 = 0;
    let (x165, x166) = fiat_p224_addcarryx_u32(x164, x152, x149);
    let mut x167: u32 = 0;
    let mut x168: fiat_p224_u1 = 0;
    let (x167, x168) = fiat_p224_addcarryx_u32(x166, x150, x147);
    let mut x169: u32 = 0;
    let mut x170: fiat_p224_u1 = 0;
    let (x169, x170) = fiat_p224_addcarryx_u32(x168, x148, x145);
    let x171: u32 = ((x170 as u32) + x146);
    let mut x172: u32 = 0;
    let mut x173: fiat_p224_u1 = 0;
    let (x172, x173) = fiat_p224_addcarryx_u32(0x0, x130, x157);
    let mut x174: u32 = 0;
    let mut x175: fiat_p224_u1 = 0;
    let (x174, x175) = fiat_p224_addcarryx_u32(x173, x132, x159);
    let mut x176: u32 = 0;
    let mut x177: fiat_p224_u1 = 0;
    let (x176, x177) = fiat_p224_addcarryx_u32(x175, x134, x161);
    let mut x178: u32 = 0;
    let mut x179: fiat_p224_u1 = 0;
    let (x178, x179) = fiat_p224_addcarryx_u32(x177, x136, x163);
    let mut x180: u32 = 0;
    let mut x181: fiat_p224_u1 = 0;
    let (x180, x181) = fiat_p224_addcarryx_u32(x179, x138, x165);
    let mut x182: u32 = 0;
    let mut x183: fiat_p224_u1 = 0;
    let (x182, x183) = fiat_p224_addcarryx_u32(x181, x140, x167);
    let mut x184: u32 = 0;
    let mut x185: fiat_p224_u1 = 0;
    let (x184, x185) = fiat_p224_addcarryx_u32(x183, x142, x169);
    let mut x186: u32 = 0;
    let mut x187: fiat_p224_u1 = 0;
    let (x186, x187) = fiat_p224_addcarryx_u32(x185, x144, x171);
    let mut x188: u32 = 0;
    let mut x189: u32 = 0;
    let (x188, x189) = fiat_p224_mulx_u32(x172, 0xffffffff);
    let mut x190: u32 = 0;
    let mut x191: u32 = 0;
    let (x190, x191) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x192: u32 = 0;
    let mut x193: u32 = 0;
    let (x192, x193) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x194: u32 = 0;
    let mut x195: u32 = 0;
    let (x194, x195) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x196: u32 = 0;
    let mut x197: u32 = 0;
    let (x196, x197) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x198: u32 = 0;
    let mut x199: fiat_p224_u1 = 0;
    let (x198, x199) = fiat_p224_addcarryx_u32(0x0, x197, x194);
    let mut x200: u32 = 0;
    let mut x201: fiat_p224_u1 = 0;
    let (x200, x201) = fiat_p224_addcarryx_u32(x199, x195, x192);
    let mut x202: u32 = 0;
    let mut x203: fiat_p224_u1 = 0;
    let (x202, x203) = fiat_p224_addcarryx_u32(x201, x193, x190);
    let x204: u32 = ((x203 as u32) + x191);
    let mut x205: u32 = 0;
    let mut x206: fiat_p224_u1 = 0;
    let (x205, x206) = fiat_p224_addcarryx_u32(0x0, x172, x188);
    let mut x207: u32 = 0;
    let mut x208: fiat_p224_u1 = 0;
    let (x207, x208) = fiat_p224_addcarryx_u32(x206, x174, (0x0 as u32));
    let mut x209: u32 = 0;
    let mut x210: fiat_p224_u1 = 0;
    let (x209, x210) = fiat_p224_addcarryx_u32(x208, x176, (0x0 as u32));
    let mut x211: u32 = 0;
    let mut x212: fiat_p224_u1 = 0;
    let (x211, x212) = fiat_p224_addcarryx_u32(x210, x178, x196);
    let mut x213: u32 = 0;
    let mut x214: fiat_p224_u1 = 0;
    let (x213, x214) = fiat_p224_addcarryx_u32(x212, x180, x198);
    let mut x215: u32 = 0;
    let mut x216: fiat_p224_u1 = 0;
    let (x215, x216) = fiat_p224_addcarryx_u32(x214, x182, x200);
    let mut x217: u32 = 0;
    let mut x218: fiat_p224_u1 = 0;
    let (x217, x218) = fiat_p224_addcarryx_u32(x216, x184, x202);
    let mut x219: u32 = 0;
    let mut x220: fiat_p224_u1 = 0;
    let (x219, x220) = fiat_p224_addcarryx_u32(x218, x186, x204);
    let x221: u32 = ((x220 as u32) + (x187 as u32));
    let mut x222: u32 = 0;
    let mut x223: u32 = 0;
    let (x222, x223) = fiat_p224_mulx_u32(x3, (arg2[6]));
    let mut x224: u32 = 0;
    let mut x225: u32 = 0;
    let (x224, x225) = fiat_p224_mulx_u32(x3, (arg2[5]));
    let mut x226: u32 = 0;
    let mut x227: u32 = 0;
    let (x226, x227) = fiat_p224_mulx_u32(x3, (arg2[4]));
    let mut x228: u32 = 0;
    let mut x229: u32 = 0;
    let (x228, x229) = fiat_p224_mulx_u32(x3, (arg2[3]));
    let mut x230: u32 = 0;
    let mut x231: u32 = 0;
    let (x230, x231) = fiat_p224_mulx_u32(x3, (arg2[2]));
    let mut x232: u32 = 0;
    let mut x233: u32 = 0;
    let (x232, x233) = fiat_p224_mulx_u32(x3, (arg2[1]));
    let mut x234: u32 = 0;
    let mut x235: u32 = 0;
    let (x234, x235) = fiat_p224_mulx_u32(x3, (arg2[0]));
    let mut x236: u32 = 0;
    let mut x237: fiat_p224_u1 = 0;
    let (x236, x237) = fiat_p224_addcarryx_u32(0x0, x235, x232);
    let mut x238: u32 = 0;
    let mut x239: fiat_p224_u1 = 0;
    let (x238, x239) = fiat_p224_addcarryx_u32(x237, x233, x230);
    let mut x240: u32 = 0;
    let mut x241: fiat_p224_u1 = 0;
    let (x240, x241) = fiat_p224_addcarryx_u32(x239, x231, x228);
    let mut x242: u32 = 0;
    let mut x243: fiat_p224_u1 = 0;
    let (x242, x243) = fiat_p224_addcarryx_u32(x241, x229, x226);
    let mut x244: u32 = 0;
    let mut x245: fiat_p224_u1 = 0;
    let (x244, x245) = fiat_p224_addcarryx_u32(x243, x227, x224);
    let mut x246: u32 = 0;
    let mut x247: fiat_p224_u1 = 0;
    let (x246, x247) = fiat_p224_addcarryx_u32(x245, x225, x222);
    let x248: u32 = ((x247 as u32) + x223);
    let mut x249: u32 = 0;
    let mut x250: fiat_p224_u1 = 0;
    let (x249, x250) = fiat_p224_addcarryx_u32(0x0, x207, x234);
    let mut x251: u32 = 0;
    let mut x252: fiat_p224_u1 = 0;
    let (x251, x252) = fiat_p224_addcarryx_u32(x250, x209, x236);
    let mut x253: u32 = 0;
    let mut x254: fiat_p224_u1 = 0;
    let (x253, x254) = fiat_p224_addcarryx_u32(x252, x211, x238);
    let mut x255: u32 = 0;
    let mut x256: fiat_p224_u1 = 0;
    let (x255, x256) = fiat_p224_addcarryx_u32(x254, x213, x240);
    let mut x257: u32 = 0;
    let mut x258: fiat_p224_u1 = 0;
    let (x257, x258) = fiat_p224_addcarryx_u32(x256, x215, x242);
    let mut x259: u32 = 0;
    let mut x260: fiat_p224_u1 = 0;
    let (x259, x260) = fiat_p224_addcarryx_u32(x258, x217, x244);
    let mut x261: u32 = 0;
    let mut x262: fiat_p224_u1 = 0;
    let (x261, x262) = fiat_p224_addcarryx_u32(x260, x219, x246);
    let mut x263: u32 = 0;
    let mut x264: fiat_p224_u1 = 0;
    let (x263, x264) = fiat_p224_addcarryx_u32(x262, x221, x248);
    let mut x265: u32 = 0;
    let mut x266: u32 = 0;
    let (x265, x266) = fiat_p224_mulx_u32(x249, 0xffffffff);
    let mut x267: u32 = 0;
    let mut x268: u32 = 0;
    let (x267, x268) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x269: u32 = 0;
    let mut x270: u32 = 0;
    let (x269, x270) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x271: u32 = 0;
    let mut x272: u32 = 0;
    let (x271, x272) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x273: u32 = 0;
    let mut x274: u32 = 0;
    let (x273, x274) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x275: u32 = 0;
    let mut x276: fiat_p224_u1 = 0;
    let (x275, x276) = fiat_p224_addcarryx_u32(0x0, x274, x271);
    let mut x277: u32 = 0;
    let mut x278: fiat_p224_u1 = 0;
    let (x277, x278) = fiat_p224_addcarryx_u32(x276, x272, x269);
    let mut x279: u32 = 0;
    let mut x280: fiat_p224_u1 = 0;
    let (x279, x280) = fiat_p224_addcarryx_u32(x278, x270, x267);
    let x281: u32 = ((x280 as u32) + x268);
    let mut x282: u32 = 0;
    let mut x283: fiat_p224_u1 = 0;
    let (x282, x283) = fiat_p224_addcarryx_u32(0x0, x249, x265);
    let mut x284: u32 = 0;
    let mut x285: fiat_p224_u1 = 0;
    let (x284, x285) = fiat_p224_addcarryx_u32(x283, x251, (0x0 as u32));
    let mut x286: u32 = 0;
    let mut x287: fiat_p224_u1 = 0;
    let (x286, x287) = fiat_p224_addcarryx_u32(x285, x253, (0x0 as u32));
    let mut x288: u32 = 0;
    let mut x289: fiat_p224_u1 = 0;
    let (x288, x289) = fiat_p224_addcarryx_u32(x287, x255, x273);
    let mut x290: u32 = 0;
    let mut x291: fiat_p224_u1 = 0;
    let (x290, x291) = fiat_p224_addcarryx_u32(x289, x257, x275);
    let mut x292: u32 = 0;
    let mut x293: fiat_p224_u1 = 0;
    let (x292, x293) = fiat_p224_addcarryx_u32(x291, x259, x277);
    let mut x294: u32 = 0;
    let mut x295: fiat_p224_u1 = 0;
    let (x294, x295) = fiat_p224_addcarryx_u32(x293, x261, x279);
    let mut x296: u32 = 0;
    let mut x297: fiat_p224_u1 = 0;
    let (x296, x297) = fiat_p224_addcarryx_u32(x295, x263, x281);
    let x298: u32 = ((x297 as u32) + (x264 as u32));
    let mut x299: u32 = 0;
    let mut x300: u32 = 0;
    let (x299, x300) = fiat_p224_mulx_u32(x4, (arg2[6]));
    let mut x301: u32 = 0;
    let mut x302: u32 = 0;
    let (x301, x302) = fiat_p224_mulx_u32(x4, (arg2[5]));
    let mut x303: u32 = 0;
    let mut x304: u32 = 0;
    let (x303, x304) = fiat_p224_mulx_u32(x4, (arg2[4]));
    let mut x305: u32 = 0;
    let mut x306: u32 = 0;
    let (x305, x306) = fiat_p224_mulx_u32(x4, (arg2[3]));
    let mut x307: u32 = 0;
    let mut x308: u32 = 0;
    let (x307, x308) = fiat_p224_mulx_u32(x4, (arg2[2]));
    let mut x309: u32 = 0;
    let mut x310: u32 = 0;
    let (x309, x310) = fiat_p224_mulx_u32(x4, (arg2[1]));
    let mut x311: u32 = 0;
    let mut x312: u32 = 0;
    let (x311, x312) = fiat_p224_mulx_u32(x4, (arg2[0]));
    let mut x313: u32 = 0;
    let mut x314: fiat_p224_u1 = 0;
    let (x313, x314) = fiat_p224_addcarryx_u32(0x0, x312, x309);
    let mut x315: u32 = 0;
    let mut x316: fiat_p224_u1 = 0;
    let (x315, x316) = fiat_p224_addcarryx_u32(x314, x310, x307);
    let mut x317: u32 = 0;
    let mut x318: fiat_p224_u1 = 0;
    let (x317, x318) = fiat_p224_addcarryx_u32(x316, x308, x305);
    let mut x319: u32 = 0;
    let mut x320: fiat_p224_u1 = 0;
    let (x319, x320) = fiat_p224_addcarryx_u32(x318, x306, x303);
    let mut x321: u32 = 0;
    let mut x322: fiat_p224_u1 = 0;
    let (x321, x322) = fiat_p224_addcarryx_u32(x320, x304, x301);
    let mut x323: u32 = 0;
    let mut x324: fiat_p224_u1 = 0;
    let (x323, x324) = fiat_p224_addcarryx_u32(x322, x302, x299);
    let x325: u32 = ((x324 as u32) + x300);
    let mut x326: u32 = 0;
    let mut x327: fiat_p224_u1 = 0;
    let (x326, x327) = fiat_p224_addcarryx_u32(0x0, x284, x311);
    let mut x328: u32 = 0;
    let mut x329: fiat_p224_u1 = 0;
    let (x328, x329) = fiat_p224_addcarryx_u32(x327, x286, x313);
    let mut x330: u32 = 0;
    let mut x331: fiat_p224_u1 = 0;
    let (x330, x331) = fiat_p224_addcarryx_u32(x329, x288, x315);
    let mut x332: u32 = 0;
    let mut x333: fiat_p224_u1 = 0;
    let (x332, x333) = fiat_p224_addcarryx_u32(x331, x290, x317);
    let mut x334: u32 = 0;
    let mut x335: fiat_p224_u1 = 0;
    let (x334, x335) = fiat_p224_addcarryx_u32(x333, x292, x319);
    let mut x336: u32 = 0;
    let mut x337: fiat_p224_u1 = 0;
    let (x336, x337) = fiat_p224_addcarryx_u32(x335, x294, x321);
    let mut x338: u32 = 0;
    let mut x339: fiat_p224_u1 = 0;
    let (x338, x339) = fiat_p224_addcarryx_u32(x337, x296, x323);
    let mut x340: u32 = 0;
    let mut x341: fiat_p224_u1 = 0;
    let (x340, x341) = fiat_p224_addcarryx_u32(x339, x298, x325);
    let mut x342: u32 = 0;
    let mut x343: u32 = 0;
    let (x342, x343) = fiat_p224_mulx_u32(x326, 0xffffffff);
    let mut x344: u32 = 0;
    let mut x345: u32 = 0;
    let (x344, x345) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x346: u32 = 0;
    let mut x347: u32 = 0;
    let (x346, x347) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x348: u32 = 0;
    let mut x349: u32 = 0;
    let (x348, x349) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x350: u32 = 0;
    let mut x351: u32 = 0;
    let (x350, x351) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x352: u32 = 0;
    let mut x353: fiat_p224_u1 = 0;
    let (x352, x353) = fiat_p224_addcarryx_u32(0x0, x351, x348);
    let mut x354: u32 = 0;
    let mut x355: fiat_p224_u1 = 0;
    let (x354, x355) = fiat_p224_addcarryx_u32(x353, x349, x346);
    let mut x356: u32 = 0;
    let mut x357: fiat_p224_u1 = 0;
    let (x356, x357) = fiat_p224_addcarryx_u32(x355, x347, x344);
    let x358: u32 = ((x357 as u32) + x345);
    let mut x359: u32 = 0;
    let mut x360: fiat_p224_u1 = 0;
    let (x359, x360) = fiat_p224_addcarryx_u32(0x0, x326, x342);
    let mut x361: u32 = 0;
    let mut x362: fiat_p224_u1 = 0;
    let (x361, x362) = fiat_p224_addcarryx_u32(x360, x328, (0x0 as u32));
    let mut x363: u32 = 0;
    let mut x364: fiat_p224_u1 = 0;
    let (x363, x364) = fiat_p224_addcarryx_u32(x362, x330, (0x0 as u32));
    let mut x365: u32 = 0;
    let mut x366: fiat_p224_u1 = 0;
    let (x365, x366) = fiat_p224_addcarryx_u32(x364, x332, x350);
    let mut x367: u32 = 0;
    let mut x368: fiat_p224_u1 = 0;
    let (x367, x368) = fiat_p224_addcarryx_u32(x366, x334, x352);
    let mut x369: u32 = 0;
    let mut x370: fiat_p224_u1 = 0;
    let (x369, x370) = fiat_p224_addcarryx_u32(x368, x336, x354);
    let mut x371: u32 = 0;
    let mut x372: fiat_p224_u1 = 0;
    let (x371, x372) = fiat_p224_addcarryx_u32(x370, x338, x356);
    let mut x373: u32 = 0;
    let mut x374: fiat_p224_u1 = 0;
    let (x373, x374) = fiat_p224_addcarryx_u32(x372, x340, x358);
    let x375: u32 = ((x374 as u32) + (x341 as u32));
    let mut x376: u32 = 0;
    let mut x377: u32 = 0;
    let (x376, x377) = fiat_p224_mulx_u32(x5, (arg2[6]));
    let mut x378: u32 = 0;
    let mut x379: u32 = 0;
    let (x378, x379) = fiat_p224_mulx_u32(x5, (arg2[5]));
    let mut x380: u32 = 0;
    let mut x381: u32 = 0;
    let (x380, x381) = fiat_p224_mulx_u32(x5, (arg2[4]));
    let mut x382: u32 = 0;
    let mut x383: u32 = 0;
    let (x382, x383) = fiat_p224_mulx_u32(x5, (arg2[3]));
    let mut x384: u32 = 0;
    let mut x385: u32 = 0;
    let (x384, x385) = fiat_p224_mulx_u32(x5, (arg2[2]));
    let mut x386: u32 = 0;
    let mut x387: u32 = 0;
    let (x386, x387) = fiat_p224_mulx_u32(x5, (arg2[1]));
    let mut x388: u32 = 0;
    let mut x389: u32 = 0;
    let (x388, x389) = fiat_p224_mulx_u32(x5, (arg2[0]));
    let mut x390: u32 = 0;
    let mut x391: fiat_p224_u1 = 0;
    let (x390, x391) = fiat_p224_addcarryx_u32(0x0, x389, x386);
    let mut x392: u32 = 0;
    let mut x393: fiat_p224_u1 = 0;
    let (x392, x393) = fiat_p224_addcarryx_u32(x391, x387, x384);
    let mut x394: u32 = 0;
    let mut x395: fiat_p224_u1 = 0;
    let (x394, x395) = fiat_p224_addcarryx_u32(x393, x385, x382);
    let mut x396: u32 = 0;
    let mut x397: fiat_p224_u1 = 0;
    let (x396, x397) = fiat_p224_addcarryx_u32(x395, x383, x380);
    let mut x398: u32 = 0;
    let mut x399: fiat_p224_u1 = 0;
    let (x398, x399) = fiat_p224_addcarryx_u32(x397, x381, x378);
    let mut x400: u32 = 0;
    let mut x401: fiat_p224_u1 = 0;
    let (x400, x401) = fiat_p224_addcarryx_u32(x399, x379, x376);
    let x402: u32 = ((x401 as u32) + x377);
    let mut x403: u32 = 0;
    let mut x404: fiat_p224_u1 = 0;
    let (x403, x404) = fiat_p224_addcarryx_u32(0x0, x361, x388);
    let mut x405: u32 = 0;
    let mut x406: fiat_p224_u1 = 0;
    let (x405, x406) = fiat_p224_addcarryx_u32(x404, x363, x390);
    let mut x407: u32 = 0;
    let mut x408: fiat_p224_u1 = 0;
    let (x407, x408) = fiat_p224_addcarryx_u32(x406, x365, x392);
    let mut x409: u32 = 0;
    let mut x410: fiat_p224_u1 = 0;
    let (x409, x410) = fiat_p224_addcarryx_u32(x408, x367, x394);
    let mut x411: u32 = 0;
    let mut x412: fiat_p224_u1 = 0;
    let (x411, x412) = fiat_p224_addcarryx_u32(x410, x369, x396);
    let mut x413: u32 = 0;
    let mut x414: fiat_p224_u1 = 0;
    let (x413, x414) = fiat_p224_addcarryx_u32(x412, x371, x398);
    let mut x415: u32 = 0;
    let mut x416: fiat_p224_u1 = 0;
    let (x415, x416) = fiat_p224_addcarryx_u32(x414, x373, x400);
    let mut x417: u32 = 0;
    let mut x418: fiat_p224_u1 = 0;
    let (x417, x418) = fiat_p224_addcarryx_u32(x416, x375, x402);
    let mut x419: u32 = 0;
    let mut x420: u32 = 0;
    let (x419, x420) = fiat_p224_mulx_u32(x403, 0xffffffff);
    let mut x421: u32 = 0;
    let mut x422: u32 = 0;
    let (x421, x422) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x423: u32 = 0;
    let mut x424: u32 = 0;
    let (x423, x424) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x425: u32 = 0;
    let mut x426: u32 = 0;
    let (x425, x426) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x427: u32 = 0;
    let mut x428: u32 = 0;
    let (x427, x428) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x429: u32 = 0;
    let mut x430: fiat_p224_u1 = 0;
    let (x429, x430) = fiat_p224_addcarryx_u32(0x0, x428, x425);
    let mut x431: u32 = 0;
    let mut x432: fiat_p224_u1 = 0;
    let (x431, x432) = fiat_p224_addcarryx_u32(x430, x426, x423);
    let mut x433: u32 = 0;
    let mut x434: fiat_p224_u1 = 0;
    let (x433, x434) = fiat_p224_addcarryx_u32(x432, x424, x421);
    let x435: u32 = ((x434 as u32) + x422);
    let mut x436: u32 = 0;
    let mut x437: fiat_p224_u1 = 0;
    let (x436, x437) = fiat_p224_addcarryx_u32(0x0, x403, x419);
    let mut x438: u32 = 0;
    let mut x439: fiat_p224_u1 = 0;
    let (x438, x439) = fiat_p224_addcarryx_u32(x437, x405, (0x0 as u32));
    let mut x440: u32 = 0;
    let mut x441: fiat_p224_u1 = 0;
    let (x440, x441) = fiat_p224_addcarryx_u32(x439, x407, (0x0 as u32));
    let mut x442: u32 = 0;
    let mut x443: fiat_p224_u1 = 0;
    let (x442, x443) = fiat_p224_addcarryx_u32(x441, x409, x427);
    let mut x444: u32 = 0;
    let mut x445: fiat_p224_u1 = 0;
    let (x444, x445) = fiat_p224_addcarryx_u32(x443, x411, x429);
    let mut x446: u32 = 0;
    let mut x447: fiat_p224_u1 = 0;
    let (x446, x447) = fiat_p224_addcarryx_u32(x445, x413, x431);
    let mut x448: u32 = 0;
    let mut x449: fiat_p224_u1 = 0;
    let (x448, x449) = fiat_p224_addcarryx_u32(x447, x415, x433);
    let mut x450: u32 = 0;
    let mut x451: fiat_p224_u1 = 0;
    let (x450, x451) = fiat_p224_addcarryx_u32(x449, x417, x435);
    let x452: u32 = ((x451 as u32) + (x418 as u32));
    let mut x453: u32 = 0;
    let mut x454: u32 = 0;
    let (x453, x454) = fiat_p224_mulx_u32(x6, (arg2[6]));
    let mut x455: u32 = 0;
    let mut x456: u32 = 0;
    let (x455, x456) = fiat_p224_mulx_u32(x6, (arg2[5]));
    let mut x457: u32 = 0;
    let mut x458: u32 = 0;
    let (x457, x458) = fiat_p224_mulx_u32(x6, (arg2[4]));
    let mut x459: u32 = 0;
    let mut x460: u32 = 0;
    let (x459, x460) = fiat_p224_mulx_u32(x6, (arg2[3]));
    let mut x461: u32 = 0;
    let mut x462: u32 = 0;
    let (x461, x462) = fiat_p224_mulx_u32(x6, (arg2[2]));
    let mut x463: u32 = 0;
    let mut x464: u32 = 0;
    let (x463, x464) = fiat_p224_mulx_u32(x6, (arg2[1]));
    let mut x465: u32 = 0;
    let mut x466: u32 = 0;
    let (x465, x466) = fiat_p224_mulx_u32(x6, (arg2[0]));
    let mut x467: u32 = 0;
    let mut x468: fiat_p224_u1 = 0;
    let (x467, x468) = fiat_p224_addcarryx_u32(0x0, x466, x463);
    let mut x469: u32 = 0;
    let mut x470: fiat_p224_u1 = 0;
    let (x469, x470) = fiat_p224_addcarryx_u32(x468, x464, x461);
    let mut x471: u32 = 0;
    let mut x472: fiat_p224_u1 = 0;
    let (x471, x472) = fiat_p224_addcarryx_u32(x470, x462, x459);
    let mut x473: u32 = 0;
    let mut x474: fiat_p224_u1 = 0;
    let (x473, x474) = fiat_p224_addcarryx_u32(x472, x460, x457);
    let mut x475: u32 = 0;
    let mut x476: fiat_p224_u1 = 0;
    let (x475, x476) = fiat_p224_addcarryx_u32(x474, x458, x455);
    let mut x477: u32 = 0;
    let mut x478: fiat_p224_u1 = 0;
    let (x477, x478) = fiat_p224_addcarryx_u32(x476, x456, x453);
    let x479: u32 = ((x478 as u32) + x454);
    let mut x480: u32 = 0;
    let mut x481: fiat_p224_u1 = 0;
    let (x480, x481) = fiat_p224_addcarryx_u32(0x0, x438, x465);
    let mut x482: u32 = 0;
    let mut x483: fiat_p224_u1 = 0;
    let (x482, x483) = fiat_p224_addcarryx_u32(x481, x440, x467);
    let mut x484: u32 = 0;
    let mut x485: fiat_p224_u1 = 0;
    let (x484, x485) = fiat_p224_addcarryx_u32(x483, x442, x469);
    let mut x486: u32 = 0;
    let mut x487: fiat_p224_u1 = 0;
    let (x486, x487) = fiat_p224_addcarryx_u32(x485, x444, x471);
    let mut x488: u32 = 0;
    let mut x489: fiat_p224_u1 = 0;
    let (x488, x489) = fiat_p224_addcarryx_u32(x487, x446, x473);
    let mut x490: u32 = 0;
    let mut x491: fiat_p224_u1 = 0;
    let (x490, x491) = fiat_p224_addcarryx_u32(x489, x448, x475);
    let mut x492: u32 = 0;
    let mut x493: fiat_p224_u1 = 0;
    let (x492, x493) = fiat_p224_addcarryx_u32(x491, x450, x477);
    let mut x494: u32 = 0;
    let mut x495: fiat_p224_u1 = 0;
    let (x494, x495) = fiat_p224_addcarryx_u32(x493, x452, x479);
    let mut x496: u32 = 0;
    let mut x497: u32 = 0;
    let (x496, x497) = fiat_p224_mulx_u32(x480, 0xffffffff);
    let mut x498: u32 = 0;
    let mut x499: u32 = 0;
    let (x498, x499) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x500: u32 = 0;
    let mut x501: u32 = 0;
    let (x500, x501) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x502: u32 = 0;
    let mut x503: u32 = 0;
    let (x502, x503) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x504: u32 = 0;
    let mut x505: u32 = 0;
    let (x504, x505) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x506: u32 = 0;
    let mut x507: fiat_p224_u1 = 0;
    let (x506, x507) = fiat_p224_addcarryx_u32(0x0, x505, x502);
    let mut x508: u32 = 0;
    let mut x509: fiat_p224_u1 = 0;
    let (x508, x509) = fiat_p224_addcarryx_u32(x507, x503, x500);
    let mut x510: u32 = 0;
    let mut x511: fiat_p224_u1 = 0;
    let (x510, x511) = fiat_p224_addcarryx_u32(x509, x501, x498);
    let x512: u32 = ((x511 as u32) + x499);
    let mut x513: u32 = 0;
    let mut x514: fiat_p224_u1 = 0;
    let (x513, x514) = fiat_p224_addcarryx_u32(0x0, x480, x496);
    let mut x515: u32 = 0;
    let mut x516: fiat_p224_u1 = 0;
    let (x515, x516) = fiat_p224_addcarryx_u32(x514, x482, (0x0 as u32));
    let mut x517: u32 = 0;
    let mut x518: fiat_p224_u1 = 0;
    let (x517, x518) = fiat_p224_addcarryx_u32(x516, x484, (0x0 as u32));
    let mut x519: u32 = 0;
    let mut x520: fiat_p224_u1 = 0;
    let (x519, x520) = fiat_p224_addcarryx_u32(x518, x486, x504);
    let mut x521: u32 = 0;
    let mut x522: fiat_p224_u1 = 0;
    let (x521, x522) = fiat_p224_addcarryx_u32(x520, x488, x506);
    let mut x523: u32 = 0;
    let mut x524: fiat_p224_u1 = 0;
    let (x523, x524) = fiat_p224_addcarryx_u32(x522, x490, x508);
    let mut x525: u32 = 0;
    let mut x526: fiat_p224_u1 = 0;
    let (x525, x526) = fiat_p224_addcarryx_u32(x524, x492, x510);
    let mut x527: u32 = 0;
    let mut x528: fiat_p224_u1 = 0;
    let (x527, x528) = fiat_p224_addcarryx_u32(x526, x494, x512);
    let x529: u32 = ((x528 as u32) + (x495 as u32));
    let mut x530: u32 = 0;
    let mut x531: fiat_p224_u1 = 0;
    let (x530, x531) = fiat_p224_subborrowx_u32(0x0, x515, (0x1 as u32));
    let mut x532: u32 = 0;
    let mut x533: fiat_p224_u1 = 0;
    let (x532, x533) = fiat_p224_subborrowx_u32(x531, x517, (0x0 as u32));
    let mut x534: u32 = 0;
    let mut x535: fiat_p224_u1 = 0;
    let (x534, x535) = fiat_p224_subborrowx_u32(x533, x519, (0x0 as u32));
    let mut x536: u32 = 0;
    let mut x537: fiat_p224_u1 = 0;
    let (x536, x537) = fiat_p224_subborrowx_u32(x535, x521, 0xffffffff);
    let mut x538: u32 = 0;
    let mut x539: fiat_p224_u1 = 0;
    let (x538, x539) = fiat_p224_subborrowx_u32(x537, x523, 0xffffffff);
    let mut x540: u32 = 0;
    let mut x541: fiat_p224_u1 = 0;
    let (x540, x541) = fiat_p224_subborrowx_u32(x539, x525, 0xffffffff);
    let mut x542: u32 = 0;
    let mut x543: fiat_p224_u1 = 0;
    let (x542, x543) = fiat_p224_subborrowx_u32(x541, x527, 0xffffffff);
    let mut x544: u32 = 0;
    let mut x545: fiat_p224_u1 = 0;
    let (x544, x545) = fiat_p224_subborrowx_u32(x543, x529, (0x0 as u32));
    let mut x546: u32 = 0;
    let (x546) = fiat_p224_cmovznz_u32(x545, x530, x515);
    let mut x547: u32 = 0;
    let (x547) = fiat_p224_cmovznz_u32(x545, x532, x517);
    let mut x548: u32 = 0;
    let (x548) = fiat_p224_cmovznz_u32(x545, x534, x519);
    let mut x549: u32 = 0;
    let (x549) = fiat_p224_cmovznz_u32(x545, x536, x521);
    let mut x550: u32 = 0;
    let (x550) = fiat_p224_cmovznz_u32(x545, x538, x523);
    let mut x551: u32 = 0;
    let (x551) = fiat_p224_cmovznz_u32(x545, x540, x525);
    let mut x552: u32 = 0;
    let (x552) = fiat_p224_cmovznz_u32(x545, x542, x527);
    out1[0] = x546;
    out1[1] = x547;
    out1[2] = x548;
    out1[3] = x549;
    out1[4] = x550;
    out1[5] = x551;
    out1[6] = x552;
    out1
}
#[doc = " The function fiat_p224_square squares a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_square(
    arg1: &fiat_p224_montgomery_domain_field_element,
) -> fiat_p224_montgomery_domain_field_element {
    let mut out1: fiat_p224_montgomery_domain_field_element = [0; 7];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[0]);
    let mut x8: u32 = 0;
    let mut x9: u32 = 0;
    let (x8, x9) = fiat_p224_mulx_u32(x7, (arg1[6]));
    let mut x10: u32 = 0;
    let mut x11: u32 = 0;
    let (x10, x11) = fiat_p224_mulx_u32(x7, (arg1[5]));
    let mut x12: u32 = 0;
    let mut x13: u32 = 0;
    let (x12, x13) = fiat_p224_mulx_u32(x7, (arg1[4]));
    let mut x14: u32 = 0;
    let mut x15: u32 = 0;
    let (x14, x15) = fiat_p224_mulx_u32(x7, (arg1[3]));
    let mut x16: u32 = 0;
    let mut x17: u32 = 0;
    let (x16, x17) = fiat_p224_mulx_u32(x7, (arg1[2]));
    let mut x18: u32 = 0;
    let mut x19: u32 = 0;
    let (x18, x19) = fiat_p224_mulx_u32(x7, (arg1[1]));
    let mut x20: u32 = 0;
    let mut x21: u32 = 0;
    let (x20, x21) = fiat_p224_mulx_u32(x7, (arg1[0]));
    let mut x22: u32 = 0;
    let mut x23: fiat_p224_u1 = 0;
    let (x22, x23) = fiat_p224_addcarryx_u32(0x0, x21, x18);
    let mut x24: u32 = 0;
    let mut x25: fiat_p224_u1 = 0;
    let (x24, x25) = fiat_p224_addcarryx_u32(x23, x19, x16);
    let mut x26: u32 = 0;
    let mut x27: fiat_p224_u1 = 0;
    let (x26, x27) = fiat_p224_addcarryx_u32(x25, x17, x14);
    let mut x28: u32 = 0;
    let mut x29: fiat_p224_u1 = 0;
    let (x28, x29) = fiat_p224_addcarryx_u32(x27, x15, x12);
    let mut x30: u32 = 0;
    let mut x31: fiat_p224_u1 = 0;
    let (x30, x31) = fiat_p224_addcarryx_u32(x29, x13, x10);
    let mut x32: u32 = 0;
    let mut x33: fiat_p224_u1 = 0;
    let (x32, x33) = fiat_p224_addcarryx_u32(x31, x11, x8);
    let x34: u32 = ((x33 as u32) + x9);
    let mut x35: u32 = 0;
    let mut x36: u32 = 0;
    let (x35, x36) = fiat_p224_mulx_u32(x20, 0xffffffff);
    let mut x37: u32 = 0;
    let mut x38: u32 = 0;
    let (x37, x38) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x39: u32 = 0;
    let mut x40: u32 = 0;
    let (x39, x40) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x41: u32 = 0;
    let mut x42: u32 = 0;
    let (x41, x42) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x43: u32 = 0;
    let mut x44: u32 = 0;
    let (x43, x44) = fiat_p224_mulx_u32(x35, 0xffffffff);
    let mut x45: u32 = 0;
    let mut x46: fiat_p224_u1 = 0;
    let (x45, x46) = fiat_p224_addcarryx_u32(0x0, x44, x41);
    let mut x47: u32 = 0;
    let mut x48: fiat_p224_u1 = 0;
    let (x47, x48) = fiat_p224_addcarryx_u32(x46, x42, x39);
    let mut x49: u32 = 0;
    let mut x50: fiat_p224_u1 = 0;
    let (x49, x50) = fiat_p224_addcarryx_u32(x48, x40, x37);
    let x51: u32 = ((x50 as u32) + x38);
    let mut x52: u32 = 0;
    let mut x53: fiat_p224_u1 = 0;
    let (x52, x53) = fiat_p224_addcarryx_u32(0x0, x20, x35);
    let mut x54: u32 = 0;
    let mut x55: fiat_p224_u1 = 0;
    let (x54, x55) = fiat_p224_addcarryx_u32(x53, x22, (0x0 as u32));
    let mut x56: u32 = 0;
    let mut x57: fiat_p224_u1 = 0;
    let (x56, x57) = fiat_p224_addcarryx_u32(x55, x24, (0x0 as u32));
    let mut x58: u32 = 0;
    let mut x59: fiat_p224_u1 = 0;
    let (x58, x59) = fiat_p224_addcarryx_u32(x57, x26, x43);
    let mut x60: u32 = 0;
    let mut x61: fiat_p224_u1 = 0;
    let (x60, x61) = fiat_p224_addcarryx_u32(x59, x28, x45);
    let mut x62: u32 = 0;
    let mut x63: fiat_p224_u1 = 0;
    let (x62, x63) = fiat_p224_addcarryx_u32(x61, x30, x47);
    let mut x64: u32 = 0;
    let mut x65: fiat_p224_u1 = 0;
    let (x64, x65) = fiat_p224_addcarryx_u32(x63, x32, x49);
    let mut x66: u32 = 0;
    let mut x67: fiat_p224_u1 = 0;
    let (x66, x67) = fiat_p224_addcarryx_u32(x65, x34, x51);
    let mut x68: u32 = 0;
    let mut x69: u32 = 0;
    let (x68, x69) = fiat_p224_mulx_u32(x1, (arg1[6]));
    let mut x70: u32 = 0;
    let mut x71: u32 = 0;
    let (x70, x71) = fiat_p224_mulx_u32(x1, (arg1[5]));
    let mut x72: u32 = 0;
    let mut x73: u32 = 0;
    let (x72, x73) = fiat_p224_mulx_u32(x1, (arg1[4]));
    let mut x74: u32 = 0;
    let mut x75: u32 = 0;
    let (x74, x75) = fiat_p224_mulx_u32(x1, (arg1[3]));
    let mut x76: u32 = 0;
    let mut x77: u32 = 0;
    let (x76, x77) = fiat_p224_mulx_u32(x1, (arg1[2]));
    let mut x78: u32 = 0;
    let mut x79: u32 = 0;
    let (x78, x79) = fiat_p224_mulx_u32(x1, (arg1[1]));
    let mut x80: u32 = 0;
    let mut x81: u32 = 0;
    let (x80, x81) = fiat_p224_mulx_u32(x1, (arg1[0]));
    let mut x82: u32 = 0;
    let mut x83: fiat_p224_u1 = 0;
    let (x82, x83) = fiat_p224_addcarryx_u32(0x0, x81, x78);
    let mut x84: u32 = 0;
    let mut x85: fiat_p224_u1 = 0;
    let (x84, x85) = fiat_p224_addcarryx_u32(x83, x79, x76);
    let mut x86: u32 = 0;
    let mut x87: fiat_p224_u1 = 0;
    let (x86, x87) = fiat_p224_addcarryx_u32(x85, x77, x74);
    let mut x88: u32 = 0;
    let mut x89: fiat_p224_u1 = 0;
    let (x88, x89) = fiat_p224_addcarryx_u32(x87, x75, x72);
    let mut x90: u32 = 0;
    let mut x91: fiat_p224_u1 = 0;
    let (x90, x91) = fiat_p224_addcarryx_u32(x89, x73, x70);
    let mut x92: u32 = 0;
    let mut x93: fiat_p224_u1 = 0;
    let (x92, x93) = fiat_p224_addcarryx_u32(x91, x71, x68);
    let x94: u32 = ((x93 as u32) + x69);
    let mut x95: u32 = 0;
    let mut x96: fiat_p224_u1 = 0;
    let (x95, x96) = fiat_p224_addcarryx_u32(0x0, x54, x80);
    let mut x97: u32 = 0;
    let mut x98: fiat_p224_u1 = 0;
    let (x97, x98) = fiat_p224_addcarryx_u32(x96, x56, x82);
    let mut x99: u32 = 0;
    let mut x100: fiat_p224_u1 = 0;
    let (x99, x100) = fiat_p224_addcarryx_u32(x98, x58, x84);
    let mut x101: u32 = 0;
    let mut x102: fiat_p224_u1 = 0;
    let (x101, x102) = fiat_p224_addcarryx_u32(x100, x60, x86);
    let mut x103: u32 = 0;
    let mut x104: fiat_p224_u1 = 0;
    let (x103, x104) = fiat_p224_addcarryx_u32(x102, x62, x88);
    let mut x105: u32 = 0;
    let mut x106: fiat_p224_u1 = 0;
    let (x105, x106) = fiat_p224_addcarryx_u32(x104, x64, x90);
    let mut x107: u32 = 0;
    let mut x108: fiat_p224_u1 = 0;
    let (x107, x108) = fiat_p224_addcarryx_u32(x106, x66, x92);
    let mut x109: u32 = 0;
    let mut x110: fiat_p224_u1 = 0;
    let (x109, x110) = fiat_p224_addcarryx_u32(x108, (x67 as u32), x94);
    let mut x111: u32 = 0;
    let mut x112: u32 = 0;
    let (x111, x112) = fiat_p224_mulx_u32(x95, 0xffffffff);
    let mut x113: u32 = 0;
    let mut x114: u32 = 0;
    let (x113, x114) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x115: u32 = 0;
    let mut x116: u32 = 0;
    let (x115, x116) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x117: u32 = 0;
    let mut x118: u32 = 0;
    let (x117, x118) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x119: u32 = 0;
    let mut x120: u32 = 0;
    let (x119, x120) = fiat_p224_mulx_u32(x111, 0xffffffff);
    let mut x121: u32 = 0;
    let mut x122: fiat_p224_u1 = 0;
    let (x121, x122) = fiat_p224_addcarryx_u32(0x0, x120, x117);
    let mut x123: u32 = 0;
    let mut x124: fiat_p224_u1 = 0;
    let (x123, x124) = fiat_p224_addcarryx_u32(x122, x118, x115);
    let mut x125: u32 = 0;
    let mut x126: fiat_p224_u1 = 0;
    let (x125, x126) = fiat_p224_addcarryx_u32(x124, x116, x113);
    let x127: u32 = ((x126 as u32) + x114);
    let mut x128: u32 = 0;
    let mut x129: fiat_p224_u1 = 0;
    let (x128, x129) = fiat_p224_addcarryx_u32(0x0, x95, x111);
    let mut x130: u32 = 0;
    let mut x131: fiat_p224_u1 = 0;
    let (x130, x131) = fiat_p224_addcarryx_u32(x129, x97, (0x0 as u32));
    let mut x132: u32 = 0;
    let mut x133: fiat_p224_u1 = 0;
    let (x132, x133) = fiat_p224_addcarryx_u32(x131, x99, (0x0 as u32));
    let mut x134: u32 = 0;
    let mut x135: fiat_p224_u1 = 0;
    let (x134, x135) = fiat_p224_addcarryx_u32(x133, x101, x119);
    let mut x136: u32 = 0;
    let mut x137: fiat_p224_u1 = 0;
    let (x136, x137) = fiat_p224_addcarryx_u32(x135, x103, x121);
    let mut x138: u32 = 0;
    let mut x139: fiat_p224_u1 = 0;
    let (x138, x139) = fiat_p224_addcarryx_u32(x137, x105, x123);
    let mut x140: u32 = 0;
    let mut x141: fiat_p224_u1 = 0;
    let (x140, x141) = fiat_p224_addcarryx_u32(x139, x107, x125);
    let mut x142: u32 = 0;
    let mut x143: fiat_p224_u1 = 0;
    let (x142, x143) = fiat_p224_addcarryx_u32(x141, x109, x127);
    let x144: u32 = ((x143 as u32) + (x110 as u32));
    let mut x145: u32 = 0;
    let mut x146: u32 = 0;
    let (x145, x146) = fiat_p224_mulx_u32(x2, (arg1[6]));
    let mut x147: u32 = 0;
    let mut x148: u32 = 0;
    let (x147, x148) = fiat_p224_mulx_u32(x2, (arg1[5]));
    let mut x149: u32 = 0;
    let mut x150: u32 = 0;
    let (x149, x150) = fiat_p224_mulx_u32(x2, (arg1[4]));
    let mut x151: u32 = 0;
    let mut x152: u32 = 0;
    let (x151, x152) = fiat_p224_mulx_u32(x2, (arg1[3]));
    let mut x153: u32 = 0;
    let mut x154: u32 = 0;
    let (x153, x154) = fiat_p224_mulx_u32(x2, (arg1[2]));
    let mut x155: u32 = 0;
    let mut x156: u32 = 0;
    let (x155, x156) = fiat_p224_mulx_u32(x2, (arg1[1]));
    let mut x157: u32 = 0;
    let mut x158: u32 = 0;
    let (x157, x158) = fiat_p224_mulx_u32(x2, (arg1[0]));
    let mut x159: u32 = 0;
    let mut x160: fiat_p224_u1 = 0;
    let (x159, x160) = fiat_p224_addcarryx_u32(0x0, x158, x155);
    let mut x161: u32 = 0;
    let mut x162: fiat_p224_u1 = 0;
    let (x161, x162) = fiat_p224_addcarryx_u32(x160, x156, x153);
    let mut x163: u32 = 0;
    let mut x164: fiat_p224_u1 = 0;
    let (x163, x164) = fiat_p224_addcarryx_u32(x162, x154, x151);
    let mut x165: u32 = 0;
    let mut x166: fiat_p224_u1 = 0;
    let (x165, x166) = fiat_p224_addcarryx_u32(x164, x152, x149);
    let mut x167: u32 = 0;
    let mut x168: fiat_p224_u1 = 0;
    let (x167, x168) = fiat_p224_addcarryx_u32(x166, x150, x147);
    let mut x169: u32 = 0;
    let mut x170: fiat_p224_u1 = 0;
    let (x169, x170) = fiat_p224_addcarryx_u32(x168, x148, x145);
    let x171: u32 = ((x170 as u32) + x146);
    let mut x172: u32 = 0;
    let mut x173: fiat_p224_u1 = 0;
    let (x172, x173) = fiat_p224_addcarryx_u32(0x0, x130, x157);
    let mut x174: u32 = 0;
    let mut x175: fiat_p224_u1 = 0;
    let (x174, x175) = fiat_p224_addcarryx_u32(x173, x132, x159);
    let mut x176: u32 = 0;
    let mut x177: fiat_p224_u1 = 0;
    let (x176, x177) = fiat_p224_addcarryx_u32(x175, x134, x161);
    let mut x178: u32 = 0;
    let mut x179: fiat_p224_u1 = 0;
    let (x178, x179) = fiat_p224_addcarryx_u32(x177, x136, x163);
    let mut x180: u32 = 0;
    let mut x181: fiat_p224_u1 = 0;
    let (x180, x181) = fiat_p224_addcarryx_u32(x179, x138, x165);
    let mut x182: u32 = 0;
    let mut x183: fiat_p224_u1 = 0;
    let (x182, x183) = fiat_p224_addcarryx_u32(x181, x140, x167);
    let mut x184: u32 = 0;
    let mut x185: fiat_p224_u1 = 0;
    let (x184, x185) = fiat_p224_addcarryx_u32(x183, x142, x169);
    let mut x186: u32 = 0;
    let mut x187: fiat_p224_u1 = 0;
    let (x186, x187) = fiat_p224_addcarryx_u32(x185, x144, x171);
    let mut x188: u32 = 0;
    let mut x189: u32 = 0;
    let (x188, x189) = fiat_p224_mulx_u32(x172, 0xffffffff);
    let mut x190: u32 = 0;
    let mut x191: u32 = 0;
    let (x190, x191) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x192: u32 = 0;
    let mut x193: u32 = 0;
    let (x192, x193) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x194: u32 = 0;
    let mut x195: u32 = 0;
    let (x194, x195) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x196: u32 = 0;
    let mut x197: u32 = 0;
    let (x196, x197) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x198: u32 = 0;
    let mut x199: fiat_p224_u1 = 0;
    let (x198, x199) = fiat_p224_addcarryx_u32(0x0, x197, x194);
    let mut x200: u32 = 0;
    let mut x201: fiat_p224_u1 = 0;
    let (x200, x201) = fiat_p224_addcarryx_u32(x199, x195, x192);
    let mut x202: u32 = 0;
    let mut x203: fiat_p224_u1 = 0;
    let (x202, x203) = fiat_p224_addcarryx_u32(x201, x193, x190);
    let x204: u32 = ((x203 as u32) + x191);
    let mut x205: u32 = 0;
    let mut x206: fiat_p224_u1 = 0;
    let (x205, x206) = fiat_p224_addcarryx_u32(0x0, x172, x188);
    let mut x207: u32 = 0;
    let mut x208: fiat_p224_u1 = 0;
    let (x207, x208) = fiat_p224_addcarryx_u32(x206, x174, (0x0 as u32));
    let mut x209: u32 = 0;
    let mut x210: fiat_p224_u1 = 0;
    let (x209, x210) = fiat_p224_addcarryx_u32(x208, x176, (0x0 as u32));
    let mut x211: u32 = 0;
    let mut x212: fiat_p224_u1 = 0;
    let (x211, x212) = fiat_p224_addcarryx_u32(x210, x178, x196);
    let mut x213: u32 = 0;
    let mut x214: fiat_p224_u1 = 0;
    let (x213, x214) = fiat_p224_addcarryx_u32(x212, x180, x198);
    let mut x215: u32 = 0;
    let mut x216: fiat_p224_u1 = 0;
    let (x215, x216) = fiat_p224_addcarryx_u32(x214, x182, x200);
    let mut x217: u32 = 0;
    let mut x218: fiat_p224_u1 = 0;
    let (x217, x218) = fiat_p224_addcarryx_u32(x216, x184, x202);
    let mut x219: u32 = 0;
    let mut x220: fiat_p224_u1 = 0;
    let (x219, x220) = fiat_p224_addcarryx_u32(x218, x186, x204);
    let x221: u32 = ((x220 as u32) + (x187 as u32));
    let mut x222: u32 = 0;
    let mut x223: u32 = 0;
    let (x222, x223) = fiat_p224_mulx_u32(x3, (arg1[6]));
    let mut x224: u32 = 0;
    let mut x225: u32 = 0;
    let (x224, x225) = fiat_p224_mulx_u32(x3, (arg1[5]));
    let mut x226: u32 = 0;
    let mut x227: u32 = 0;
    let (x226, x227) = fiat_p224_mulx_u32(x3, (arg1[4]));
    let mut x228: u32 = 0;
    let mut x229: u32 = 0;
    let (x228, x229) = fiat_p224_mulx_u32(x3, (arg1[3]));
    let mut x230: u32 = 0;
    let mut x231: u32 = 0;
    let (x230, x231) = fiat_p224_mulx_u32(x3, (arg1[2]));
    let mut x232: u32 = 0;
    let mut x233: u32 = 0;
    let (x232, x233) = fiat_p224_mulx_u32(x3, (arg1[1]));
    let mut x234: u32 = 0;
    let mut x235: u32 = 0;
    let (x234, x235) = fiat_p224_mulx_u32(x3, (arg1[0]));
    let mut x236: u32 = 0;
    let mut x237: fiat_p224_u1 = 0;
    let (x236, x237) = fiat_p224_addcarryx_u32(0x0, x235, x232);
    let mut x238: u32 = 0;
    let mut x239: fiat_p224_u1 = 0;
    let (x238, x239) = fiat_p224_addcarryx_u32(x237, x233, x230);
    let mut x240: u32 = 0;
    let mut x241: fiat_p224_u1 = 0;
    let (x240, x241) = fiat_p224_addcarryx_u32(x239, x231, x228);
    let mut x242: u32 = 0;
    let mut x243: fiat_p224_u1 = 0;
    let (x242, x243) = fiat_p224_addcarryx_u32(x241, x229, x226);
    let mut x244: u32 = 0;
    let mut x245: fiat_p224_u1 = 0;
    let (x244, x245) = fiat_p224_addcarryx_u32(x243, x227, x224);
    let mut x246: u32 = 0;
    let mut x247: fiat_p224_u1 = 0;
    let (x246, x247) = fiat_p224_addcarryx_u32(x245, x225, x222);
    let x248: u32 = ((x247 as u32) + x223);
    let mut x249: u32 = 0;
    let mut x250: fiat_p224_u1 = 0;
    let (x249, x250) = fiat_p224_addcarryx_u32(0x0, x207, x234);
    let mut x251: u32 = 0;
    let mut x252: fiat_p224_u1 = 0;
    let (x251, x252) = fiat_p224_addcarryx_u32(x250, x209, x236);
    let mut x253: u32 = 0;
    let mut x254: fiat_p224_u1 = 0;
    let (x253, x254) = fiat_p224_addcarryx_u32(x252, x211, x238);
    let mut x255: u32 = 0;
    let mut x256: fiat_p224_u1 = 0;
    let (x255, x256) = fiat_p224_addcarryx_u32(x254, x213, x240);
    let mut x257: u32 = 0;
    let mut x258: fiat_p224_u1 = 0;
    let (x257, x258) = fiat_p224_addcarryx_u32(x256, x215, x242);
    let mut x259: u32 = 0;
    let mut x260: fiat_p224_u1 = 0;
    let (x259, x260) = fiat_p224_addcarryx_u32(x258, x217, x244);
    let mut x261: u32 = 0;
    let mut x262: fiat_p224_u1 = 0;
    let (x261, x262) = fiat_p224_addcarryx_u32(x260, x219, x246);
    let mut x263: u32 = 0;
    let mut x264: fiat_p224_u1 = 0;
    let (x263, x264) = fiat_p224_addcarryx_u32(x262, x221, x248);
    let mut x265: u32 = 0;
    let mut x266: u32 = 0;
    let (x265, x266) = fiat_p224_mulx_u32(x249, 0xffffffff);
    let mut x267: u32 = 0;
    let mut x268: u32 = 0;
    let (x267, x268) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x269: u32 = 0;
    let mut x270: u32 = 0;
    let (x269, x270) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x271: u32 = 0;
    let mut x272: u32 = 0;
    let (x271, x272) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x273: u32 = 0;
    let mut x274: u32 = 0;
    let (x273, x274) = fiat_p224_mulx_u32(x265, 0xffffffff);
    let mut x275: u32 = 0;
    let mut x276: fiat_p224_u1 = 0;
    let (x275, x276) = fiat_p224_addcarryx_u32(0x0, x274, x271);
    let mut x277: u32 = 0;
    let mut x278: fiat_p224_u1 = 0;
    let (x277, x278) = fiat_p224_addcarryx_u32(x276, x272, x269);
    let mut x279: u32 = 0;
    let mut x280: fiat_p224_u1 = 0;
    let (x279, x280) = fiat_p224_addcarryx_u32(x278, x270, x267);
    let x281: u32 = ((x280 as u32) + x268);
    let mut x282: u32 = 0;
    let mut x283: fiat_p224_u1 = 0;
    let (x282, x283) = fiat_p224_addcarryx_u32(0x0, x249, x265);
    let mut x284: u32 = 0;
    let mut x285: fiat_p224_u1 = 0;
    let (x284, x285) = fiat_p224_addcarryx_u32(x283, x251, (0x0 as u32));
    let mut x286: u32 = 0;
    let mut x287: fiat_p224_u1 = 0;
    let (x286, x287) = fiat_p224_addcarryx_u32(x285, x253, (0x0 as u32));
    let mut x288: u32 = 0;
    let mut x289: fiat_p224_u1 = 0;
    let (x288, x289) = fiat_p224_addcarryx_u32(x287, x255, x273);
    let mut x290: u32 = 0;
    let mut x291: fiat_p224_u1 = 0;
    let (x290, x291) = fiat_p224_addcarryx_u32(x289, x257, x275);
    let mut x292: u32 = 0;
    let mut x293: fiat_p224_u1 = 0;
    let (x292, x293) = fiat_p224_addcarryx_u32(x291, x259, x277);
    let mut x294: u32 = 0;
    let mut x295: fiat_p224_u1 = 0;
    let (x294, x295) = fiat_p224_addcarryx_u32(x293, x261, x279);
    let mut x296: u32 = 0;
    let mut x297: fiat_p224_u1 = 0;
    let (x296, x297) = fiat_p224_addcarryx_u32(x295, x263, x281);
    let x298: u32 = ((x297 as u32) + (x264 as u32));
    let mut x299: u32 = 0;
    let mut x300: u32 = 0;
    let (x299, x300) = fiat_p224_mulx_u32(x4, (arg1[6]));
    let mut x301: u32 = 0;
    let mut x302: u32 = 0;
    let (x301, x302) = fiat_p224_mulx_u32(x4, (arg1[5]));
    let mut x303: u32 = 0;
    let mut x304: u32 = 0;
    let (x303, x304) = fiat_p224_mulx_u32(x4, (arg1[4]));
    let mut x305: u32 = 0;
    let mut x306: u32 = 0;
    let (x305, x306) = fiat_p224_mulx_u32(x4, (arg1[3]));
    let mut x307: u32 = 0;
    let mut x308: u32 = 0;
    let (x307, x308) = fiat_p224_mulx_u32(x4, (arg1[2]));
    let mut x309: u32 = 0;
    let mut x310: u32 = 0;
    let (x309, x310) = fiat_p224_mulx_u32(x4, (arg1[1]));
    let mut x311: u32 = 0;
    let mut x312: u32 = 0;
    let (x311, x312) = fiat_p224_mulx_u32(x4, (arg1[0]));
    let mut x313: u32 = 0;
    let mut x314: fiat_p224_u1 = 0;
    let (x313, x314) = fiat_p224_addcarryx_u32(0x0, x312, x309);
    let mut x315: u32 = 0;
    let mut x316: fiat_p224_u1 = 0;
    let (x315, x316) = fiat_p224_addcarryx_u32(x314, x310, x307);
    let mut x317: u32 = 0;
    let mut x318: fiat_p224_u1 = 0;
    let (x317, x318) = fiat_p224_addcarryx_u32(x316, x308, x305);
    let mut x319: u32 = 0;
    let mut x320: fiat_p224_u1 = 0;
    let (x319, x320) = fiat_p224_addcarryx_u32(x318, x306, x303);
    let mut x321: u32 = 0;
    let mut x322: fiat_p224_u1 = 0;
    let (x321, x322) = fiat_p224_addcarryx_u32(x320, x304, x301);
    let mut x323: u32 = 0;
    let mut x324: fiat_p224_u1 = 0;
    let (x323, x324) = fiat_p224_addcarryx_u32(x322, x302, x299);
    let x325: u32 = ((x324 as u32) + x300);
    let mut x326: u32 = 0;
    let mut x327: fiat_p224_u1 = 0;
    let (x326, x327) = fiat_p224_addcarryx_u32(0x0, x284, x311);
    let mut x328: u32 = 0;
    let mut x329: fiat_p224_u1 = 0;
    let (x328, x329) = fiat_p224_addcarryx_u32(x327, x286, x313);
    let mut x330: u32 = 0;
    let mut x331: fiat_p224_u1 = 0;
    let (x330, x331) = fiat_p224_addcarryx_u32(x329, x288, x315);
    let mut x332: u32 = 0;
    let mut x333: fiat_p224_u1 = 0;
    let (x332, x333) = fiat_p224_addcarryx_u32(x331, x290, x317);
    let mut x334: u32 = 0;
    let mut x335: fiat_p224_u1 = 0;
    let (x334, x335) = fiat_p224_addcarryx_u32(x333, x292, x319);
    let mut x336: u32 = 0;
    let mut x337: fiat_p224_u1 = 0;
    let (x336, x337) = fiat_p224_addcarryx_u32(x335, x294, x321);
    let mut x338: u32 = 0;
    let mut x339: fiat_p224_u1 = 0;
    let (x338, x339) = fiat_p224_addcarryx_u32(x337, x296, x323);
    let mut x340: u32 = 0;
    let mut x341: fiat_p224_u1 = 0;
    let (x340, x341) = fiat_p224_addcarryx_u32(x339, x298, x325);
    let mut x342: u32 = 0;
    let mut x343: u32 = 0;
    let (x342, x343) = fiat_p224_mulx_u32(x326, 0xffffffff);
    let mut x344: u32 = 0;
    let mut x345: u32 = 0;
    let (x344, x345) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x346: u32 = 0;
    let mut x347: u32 = 0;
    let (x346, x347) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x348: u32 = 0;
    let mut x349: u32 = 0;
    let (x348, x349) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x350: u32 = 0;
    let mut x351: u32 = 0;
    let (x350, x351) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x352: u32 = 0;
    let mut x353: fiat_p224_u1 = 0;
    let (x352, x353) = fiat_p224_addcarryx_u32(0x0, x351, x348);
    let mut x354: u32 = 0;
    let mut x355: fiat_p224_u1 = 0;
    let (x354, x355) = fiat_p224_addcarryx_u32(x353, x349, x346);
    let mut x356: u32 = 0;
    let mut x357: fiat_p224_u1 = 0;
    let (x356, x357) = fiat_p224_addcarryx_u32(x355, x347, x344);
    let x358: u32 = ((x357 as u32) + x345);
    let mut x359: u32 = 0;
    let mut x360: fiat_p224_u1 = 0;
    let (x359, x360) = fiat_p224_addcarryx_u32(0x0, x326, x342);
    let mut x361: u32 = 0;
    let mut x362: fiat_p224_u1 = 0;
    let (x361, x362) = fiat_p224_addcarryx_u32(x360, x328, (0x0 as u32));
    let mut x363: u32 = 0;
    let mut x364: fiat_p224_u1 = 0;
    let (x363, x364) = fiat_p224_addcarryx_u32(x362, x330, (0x0 as u32));
    let mut x365: u32 = 0;
    let mut x366: fiat_p224_u1 = 0;
    let (x365, x366) = fiat_p224_addcarryx_u32(x364, x332, x350);
    let mut x367: u32 = 0;
    let mut x368: fiat_p224_u1 = 0;
    let (x367, x368) = fiat_p224_addcarryx_u32(x366, x334, x352);
    let mut x369: u32 = 0;
    let mut x370: fiat_p224_u1 = 0;
    let (x369, x370) = fiat_p224_addcarryx_u32(x368, x336, x354);
    let mut x371: u32 = 0;
    let mut x372: fiat_p224_u1 = 0;
    let (x371, x372) = fiat_p224_addcarryx_u32(x370, x338, x356);
    let mut x373: u32 = 0;
    let mut x374: fiat_p224_u1 = 0;
    let (x373, x374) = fiat_p224_addcarryx_u32(x372, x340, x358);
    let x375: u32 = ((x374 as u32) + (x341 as u32));
    let mut x376: u32 = 0;
    let mut x377: u32 = 0;
    let (x376, x377) = fiat_p224_mulx_u32(x5, (arg1[6]));
    let mut x378: u32 = 0;
    let mut x379: u32 = 0;
    let (x378, x379) = fiat_p224_mulx_u32(x5, (arg1[5]));
    let mut x380: u32 = 0;
    let mut x381: u32 = 0;
    let (x380, x381) = fiat_p224_mulx_u32(x5, (arg1[4]));
    let mut x382: u32 = 0;
    let mut x383: u32 = 0;
    let (x382, x383) = fiat_p224_mulx_u32(x5, (arg1[3]));
    let mut x384: u32 = 0;
    let mut x385: u32 = 0;
    let (x384, x385) = fiat_p224_mulx_u32(x5, (arg1[2]));
    let mut x386: u32 = 0;
    let mut x387: u32 = 0;
    let (x386, x387) = fiat_p224_mulx_u32(x5, (arg1[1]));
    let mut x388: u32 = 0;
    let mut x389: u32 = 0;
    let (x388, x389) = fiat_p224_mulx_u32(x5, (arg1[0]));
    let mut x390: u32 = 0;
    let mut x391: fiat_p224_u1 = 0;
    let (x390, x391) = fiat_p224_addcarryx_u32(0x0, x389, x386);
    let mut x392: u32 = 0;
    let mut x393: fiat_p224_u1 = 0;
    let (x392, x393) = fiat_p224_addcarryx_u32(x391, x387, x384);
    let mut x394: u32 = 0;
    let mut x395: fiat_p224_u1 = 0;
    let (x394, x395) = fiat_p224_addcarryx_u32(x393, x385, x382);
    let mut x396: u32 = 0;
    let mut x397: fiat_p224_u1 = 0;
    let (x396, x397) = fiat_p224_addcarryx_u32(x395, x383, x380);
    let mut x398: u32 = 0;
    let mut x399: fiat_p224_u1 = 0;
    let (x398, x399) = fiat_p224_addcarryx_u32(x397, x381, x378);
    let mut x400: u32 = 0;
    let mut x401: fiat_p224_u1 = 0;
    let (x400, x401) = fiat_p224_addcarryx_u32(x399, x379, x376);
    let x402: u32 = ((x401 as u32) + x377);
    let mut x403: u32 = 0;
    let mut x404: fiat_p224_u1 = 0;
    let (x403, x404) = fiat_p224_addcarryx_u32(0x0, x361, x388);
    let mut x405: u32 = 0;
    let mut x406: fiat_p224_u1 = 0;
    let (x405, x406) = fiat_p224_addcarryx_u32(x404, x363, x390);
    let mut x407: u32 = 0;
    let mut x408: fiat_p224_u1 = 0;
    let (x407, x408) = fiat_p224_addcarryx_u32(x406, x365, x392);
    let mut x409: u32 = 0;
    let mut x410: fiat_p224_u1 = 0;
    let (x409, x410) = fiat_p224_addcarryx_u32(x408, x367, x394);
    let mut x411: u32 = 0;
    let mut x412: fiat_p224_u1 = 0;
    let (x411, x412) = fiat_p224_addcarryx_u32(x410, x369, x396);
    let mut x413: u32 = 0;
    let mut x414: fiat_p224_u1 = 0;
    let (x413, x414) = fiat_p224_addcarryx_u32(x412, x371, x398);
    let mut x415: u32 = 0;
    let mut x416: fiat_p224_u1 = 0;
    let (x415, x416) = fiat_p224_addcarryx_u32(x414, x373, x400);
    let mut x417: u32 = 0;
    let mut x418: fiat_p224_u1 = 0;
    let (x417, x418) = fiat_p224_addcarryx_u32(x416, x375, x402);
    let mut x419: u32 = 0;
    let mut x420: u32 = 0;
    let (x419, x420) = fiat_p224_mulx_u32(x403, 0xffffffff);
    let mut x421: u32 = 0;
    let mut x422: u32 = 0;
    let (x421, x422) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x423: u32 = 0;
    let mut x424: u32 = 0;
    let (x423, x424) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x425: u32 = 0;
    let mut x426: u32 = 0;
    let (x425, x426) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x427: u32 = 0;
    let mut x428: u32 = 0;
    let (x427, x428) = fiat_p224_mulx_u32(x419, 0xffffffff);
    let mut x429: u32 = 0;
    let mut x430: fiat_p224_u1 = 0;
    let (x429, x430) = fiat_p224_addcarryx_u32(0x0, x428, x425);
    let mut x431: u32 = 0;
    let mut x432: fiat_p224_u1 = 0;
    let (x431, x432) = fiat_p224_addcarryx_u32(x430, x426, x423);
    let mut x433: u32 = 0;
    let mut x434: fiat_p224_u1 = 0;
    let (x433, x434) = fiat_p224_addcarryx_u32(x432, x424, x421);
    let x435: u32 = ((x434 as u32) + x422);
    let mut x436: u32 = 0;
    let mut x437: fiat_p224_u1 = 0;
    let (x436, x437) = fiat_p224_addcarryx_u32(0x0, x403, x419);
    let mut x438: u32 = 0;
    let mut x439: fiat_p224_u1 = 0;
    let (x438, x439) = fiat_p224_addcarryx_u32(x437, x405, (0x0 as u32));
    let mut x440: u32 = 0;
    let mut x441: fiat_p224_u1 = 0;
    let (x440, x441) = fiat_p224_addcarryx_u32(x439, x407, (0x0 as u32));
    let mut x442: u32 = 0;
    let mut x443: fiat_p224_u1 = 0;
    let (x442, x443) = fiat_p224_addcarryx_u32(x441, x409, x427);
    let mut x444: u32 = 0;
    let mut x445: fiat_p224_u1 = 0;
    let (x444, x445) = fiat_p224_addcarryx_u32(x443, x411, x429);
    let mut x446: u32 = 0;
    let mut x447: fiat_p224_u1 = 0;
    let (x446, x447) = fiat_p224_addcarryx_u32(x445, x413, x431);
    let mut x448: u32 = 0;
    let mut x449: fiat_p224_u1 = 0;
    let (x448, x449) = fiat_p224_addcarryx_u32(x447, x415, x433);
    let mut x450: u32 = 0;
    let mut x451: fiat_p224_u1 = 0;
    let (x450, x451) = fiat_p224_addcarryx_u32(x449, x417, x435);
    let x452: u32 = ((x451 as u32) + (x418 as u32));
    let mut x453: u32 = 0;
    let mut x454: u32 = 0;
    let (x453, x454) = fiat_p224_mulx_u32(x6, (arg1[6]));
    let mut x455: u32 = 0;
    let mut x456: u32 = 0;
    let (x455, x456) = fiat_p224_mulx_u32(x6, (arg1[5]));
    let mut x457: u32 = 0;
    let mut x458: u32 = 0;
    let (x457, x458) = fiat_p224_mulx_u32(x6, (arg1[4]));
    let mut x459: u32 = 0;
    let mut x460: u32 = 0;
    let (x459, x460) = fiat_p224_mulx_u32(x6, (arg1[3]));
    let mut x461: u32 = 0;
    let mut x462: u32 = 0;
    let (x461, x462) = fiat_p224_mulx_u32(x6, (arg1[2]));
    let mut x463: u32 = 0;
    let mut x464: u32 = 0;
    let (x463, x464) = fiat_p224_mulx_u32(x6, (arg1[1]));
    let mut x465: u32 = 0;
    let mut x466: u32 = 0;
    let (x465, x466) = fiat_p224_mulx_u32(x6, (arg1[0]));
    let mut x467: u32 = 0;
    let mut x468: fiat_p224_u1 = 0;
    let (x467, x468) = fiat_p224_addcarryx_u32(0x0, x466, x463);
    let mut x469: u32 = 0;
    let mut x470: fiat_p224_u1 = 0;
    let (x469, x470) = fiat_p224_addcarryx_u32(x468, x464, x461);
    let mut x471: u32 = 0;
    let mut x472: fiat_p224_u1 = 0;
    let (x471, x472) = fiat_p224_addcarryx_u32(x470, x462, x459);
    let mut x473: u32 = 0;
    let mut x474: fiat_p224_u1 = 0;
    let (x473, x474) = fiat_p224_addcarryx_u32(x472, x460, x457);
    let mut x475: u32 = 0;
    let mut x476: fiat_p224_u1 = 0;
    let (x475, x476) = fiat_p224_addcarryx_u32(x474, x458, x455);
    let mut x477: u32 = 0;
    let mut x478: fiat_p224_u1 = 0;
    let (x477, x478) = fiat_p224_addcarryx_u32(x476, x456, x453);
    let x479: u32 = ((x478 as u32) + x454);
    let mut x480: u32 = 0;
    let mut x481: fiat_p224_u1 = 0;
    let (x480, x481) = fiat_p224_addcarryx_u32(0x0, x438, x465);
    let mut x482: u32 = 0;
    let mut x483: fiat_p224_u1 = 0;
    let (x482, x483) = fiat_p224_addcarryx_u32(x481, x440, x467);
    let mut x484: u32 = 0;
    let mut x485: fiat_p224_u1 = 0;
    let (x484, x485) = fiat_p224_addcarryx_u32(x483, x442, x469);
    let mut x486: u32 = 0;
    let mut x487: fiat_p224_u1 = 0;
    let (x486, x487) = fiat_p224_addcarryx_u32(x485, x444, x471);
    let mut x488: u32 = 0;
    let mut x489: fiat_p224_u1 = 0;
    let (x488, x489) = fiat_p224_addcarryx_u32(x487, x446, x473);
    let mut x490: u32 = 0;
    let mut x491: fiat_p224_u1 = 0;
    let (x490, x491) = fiat_p224_addcarryx_u32(x489, x448, x475);
    let mut x492: u32 = 0;
    let mut x493: fiat_p224_u1 = 0;
    let (x492, x493) = fiat_p224_addcarryx_u32(x491, x450, x477);
    let mut x494: u32 = 0;
    let mut x495: fiat_p224_u1 = 0;
    let (x494, x495) = fiat_p224_addcarryx_u32(x493, x452, x479);
    let mut x496: u32 = 0;
    let mut x497: u32 = 0;
    let (x496, x497) = fiat_p224_mulx_u32(x480, 0xffffffff);
    let mut x498: u32 = 0;
    let mut x499: u32 = 0;
    let (x498, x499) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x500: u32 = 0;
    let mut x501: u32 = 0;
    let (x500, x501) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x502: u32 = 0;
    let mut x503: u32 = 0;
    let (x502, x503) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x504: u32 = 0;
    let mut x505: u32 = 0;
    let (x504, x505) = fiat_p224_mulx_u32(x496, 0xffffffff);
    let mut x506: u32 = 0;
    let mut x507: fiat_p224_u1 = 0;
    let (x506, x507) = fiat_p224_addcarryx_u32(0x0, x505, x502);
    let mut x508: u32 = 0;
    let mut x509: fiat_p224_u1 = 0;
    let (x508, x509) = fiat_p224_addcarryx_u32(x507, x503, x500);
    let mut x510: u32 = 0;
    let mut x511: fiat_p224_u1 = 0;
    let (x510, x511) = fiat_p224_addcarryx_u32(x509, x501, x498);
    let x512: u32 = ((x511 as u32) + x499);
    let mut x513: u32 = 0;
    let mut x514: fiat_p224_u1 = 0;
    let (x513, x514) = fiat_p224_addcarryx_u32(0x0, x480, x496);
    let mut x515: u32 = 0;
    let mut x516: fiat_p224_u1 = 0;
    let (x515, x516) = fiat_p224_addcarryx_u32(x514, x482, (0x0 as u32));
    let mut x517: u32 = 0;
    let mut x518: fiat_p224_u1 = 0;
    let (x517, x518) = fiat_p224_addcarryx_u32(x516, x484, (0x0 as u32));
    let mut x519: u32 = 0;
    let mut x520: fiat_p224_u1 = 0;
    let (x519, x520) = fiat_p224_addcarryx_u32(x518, x486, x504);
    let mut x521: u32 = 0;
    let mut x522: fiat_p224_u1 = 0;
    let (x521, x522) = fiat_p224_addcarryx_u32(x520, x488, x506);
    let mut x523: u32 = 0;
    let mut x524: fiat_p224_u1 = 0;
    let (x523, x524) = fiat_p224_addcarryx_u32(x522, x490, x508);
    let mut x525: u32 = 0;
    let mut x526: fiat_p224_u1 = 0;
    let (x525, x526) = fiat_p224_addcarryx_u32(x524, x492, x510);
    let mut x527: u32 = 0;
    let mut x528: fiat_p224_u1 = 0;
    let (x527, x528) = fiat_p224_addcarryx_u32(x526, x494, x512);
    let x529: u32 = ((x528 as u32) + (x495 as u32));
    let mut x530: u32 = 0;
    let mut x531: fiat_p224_u1 = 0;
    let (x530, x531) = fiat_p224_subborrowx_u32(0x0, x515, (0x1 as u32));
    let mut x532: u32 = 0;
    let mut x533: fiat_p224_u1 = 0;
    let (x532, x533) = fiat_p224_subborrowx_u32(x531, x517, (0x0 as u32));
    let mut x534: u32 = 0;
    let mut x535: fiat_p224_u1 = 0;
    let (x534, x535) = fiat_p224_subborrowx_u32(x533, x519, (0x0 as u32));
    let mut x536: u32 = 0;
    let mut x537: fiat_p224_u1 = 0;
    let (x536, x537) = fiat_p224_subborrowx_u32(x535, x521, 0xffffffff);
    let mut x538: u32 = 0;
    let mut x539: fiat_p224_u1 = 0;
    let (x538, x539) = fiat_p224_subborrowx_u32(x537, x523, 0xffffffff);
    let mut x540: u32 = 0;
    let mut x541: fiat_p224_u1 = 0;
    let (x540, x541) = fiat_p224_subborrowx_u32(x539, x525, 0xffffffff);
    let mut x542: u32 = 0;
    let mut x543: fiat_p224_u1 = 0;
    let (x542, x543) = fiat_p224_subborrowx_u32(x541, x527, 0xffffffff);
    let mut x544: u32 = 0;
    let mut x545: fiat_p224_u1 = 0;
    let (x544, x545) = fiat_p224_subborrowx_u32(x543, x529, (0x0 as u32));
    let mut x546: u32 = 0;
    let (x546) = fiat_p224_cmovznz_u32(x545, x530, x515);
    let mut x547: u32 = 0;
    let (x547) = fiat_p224_cmovznz_u32(x545, x532, x517);
    let mut x548: u32 = 0;
    let (x548) = fiat_p224_cmovznz_u32(x545, x534, x519);
    let mut x549: u32 = 0;
    let (x549) = fiat_p224_cmovznz_u32(x545, x536, x521);
    let mut x550: u32 = 0;
    let (x550) = fiat_p224_cmovznz_u32(x545, x538, x523);
    let mut x551: u32 = 0;
    let (x551) = fiat_p224_cmovznz_u32(x545, x540, x525);
    let mut x552: u32 = 0;
    let (x552) = fiat_p224_cmovznz_u32(x545, x542, x527);
    out1[0] = x546;
    out1[1] = x547;
    out1[2] = x548;
    out1[3] = x549;
    out1[4] = x550;
    out1[5] = x551;
    out1[6] = x552;
    out1
}
#[doc = " The function fiat_p224_add adds two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_add(
    arg1: &fiat_p224_montgomery_domain_field_element,
    arg2: &fiat_p224_montgomery_domain_field_element,
) -> fiat_p224_montgomery_domain_field_element {
    let mut out1: fiat_p224_montgomery_domain_field_element = [0; 7];
    let mut x1: u32 = 0;
    let mut x2: fiat_p224_u1 = 0;
    let (x1, x2) = fiat_p224_addcarryx_u32(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u32 = 0;
    let mut x4: fiat_p224_u1 = 0;
    let (x3, x4) = fiat_p224_addcarryx_u32(x2, (arg1[1]), (arg2[1]));
    let mut x5: u32 = 0;
    let mut x6: fiat_p224_u1 = 0;
    let (x5, x6) = fiat_p224_addcarryx_u32(x4, (arg1[2]), (arg2[2]));
    let mut x7: u32 = 0;
    let mut x8: fiat_p224_u1 = 0;
    let (x7, x8) = fiat_p224_addcarryx_u32(x6, (arg1[3]), (arg2[3]));
    let mut x9: u32 = 0;
    let mut x10: fiat_p224_u1 = 0;
    let (x9, x10) = fiat_p224_addcarryx_u32(x8, (arg1[4]), (arg2[4]));
    let mut x11: u32 = 0;
    let mut x12: fiat_p224_u1 = 0;
    let (x11, x12) = fiat_p224_addcarryx_u32(x10, (arg1[5]), (arg2[5]));
    let mut x13: u32 = 0;
    let mut x14: fiat_p224_u1 = 0;
    let (x13, x14) = fiat_p224_addcarryx_u32(x12, (arg1[6]), (arg2[6]));
    let mut x15: u32 = 0;
    let mut x16: fiat_p224_u1 = 0;
    let (x15, x16) = fiat_p224_subborrowx_u32(0x0, x1, (0x1 as u32));
    let mut x17: u32 = 0;
    let mut x18: fiat_p224_u1 = 0;
    let (x17, x18) = fiat_p224_subborrowx_u32(x16, x3, (0x0 as u32));
    let mut x19: u32 = 0;
    let mut x20: fiat_p224_u1 = 0;
    let (x19, x20) = fiat_p224_subborrowx_u32(x18, x5, (0x0 as u32));
    let mut x21: u32 = 0;
    let mut x22: fiat_p224_u1 = 0;
    let (x21, x22) = fiat_p224_subborrowx_u32(x20, x7, 0xffffffff);
    let mut x23: u32 = 0;
    let mut x24: fiat_p224_u1 = 0;
    let (x23, x24) = fiat_p224_subborrowx_u32(x22, x9, 0xffffffff);
    let mut x25: u32 = 0;
    let mut x26: fiat_p224_u1 = 0;
    let (x25, x26) = fiat_p224_subborrowx_u32(x24, x11, 0xffffffff);
    let mut x27: u32 = 0;
    let mut x28: fiat_p224_u1 = 0;
    let (x27, x28) = fiat_p224_subborrowx_u32(x26, x13, 0xffffffff);
    let mut x29: u32 = 0;
    let mut x30: fiat_p224_u1 = 0;
    let (x29, x30) = fiat_p224_subborrowx_u32(x28, (x14 as u32), (0x0 as u32));
    let mut x31: u32 = 0;
    let (x31) = fiat_p224_cmovznz_u32(x30, x15, x1);
    let mut x32: u32 = 0;
    let (x32) = fiat_p224_cmovznz_u32(x30, x17, x3);
    let mut x33: u32 = 0;
    let (x33) = fiat_p224_cmovznz_u32(x30, x19, x5);
    let mut x34: u32 = 0;
    let (x34) = fiat_p224_cmovznz_u32(x30, x21, x7);
    let mut x35: u32 = 0;
    let (x35) = fiat_p224_cmovznz_u32(x30, x23, x9);
    let mut x36: u32 = 0;
    let (x36) = fiat_p224_cmovznz_u32(x30, x25, x11);
    let mut x37: u32 = 0;
    let (x37) = fiat_p224_cmovznz_u32(x30, x27, x13);
    out1[0] = x31;
    out1[1] = x32;
    out1[2] = x33;
    out1[3] = x34;
    out1[4] = x35;
    out1[5] = x36;
    out1[6] = x37;
    out1
}
#[doc = " The function fiat_p224_sub subtracts two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_sub(
    arg1: &fiat_p224_montgomery_domain_field_element,
    arg2: &fiat_p224_montgomery_domain_field_element,
) -> fiat_p224_montgomery_domain_field_element {
    let mut out1: fiat_p224_montgomery_domain_field_element = [0; 7];
    let mut x1: u32 = 0;
    let mut x2: fiat_p224_u1 = 0;
    let (x1, x2) = fiat_p224_subborrowx_u32(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u32 = 0;
    let mut x4: fiat_p224_u1 = 0;
    let (x3, x4) = fiat_p224_subborrowx_u32(x2, (arg1[1]), (arg2[1]));
    let mut x5: u32 = 0;
    let mut x6: fiat_p224_u1 = 0;
    let (x5, x6) = fiat_p224_subborrowx_u32(x4, (arg1[2]), (arg2[2]));
    let mut x7: u32 = 0;
    let mut x8: fiat_p224_u1 = 0;
    let (x7, x8) = fiat_p224_subborrowx_u32(x6, (arg1[3]), (arg2[3]));
    let mut x9: u32 = 0;
    let mut x10: fiat_p224_u1 = 0;
    let (x9, x10) = fiat_p224_subborrowx_u32(x8, (arg1[4]), (arg2[4]));
    let mut x11: u32 = 0;
    let mut x12: fiat_p224_u1 = 0;
    let (x11, x12) = fiat_p224_subborrowx_u32(x10, (arg1[5]), (arg2[5]));
    let mut x13: u32 = 0;
    let mut x14: fiat_p224_u1 = 0;
    let (x13, x14) = fiat_p224_subborrowx_u32(x12, (arg1[6]), (arg2[6]));
    let mut x15: u32 = 0;
    let (x15) = fiat_p224_cmovznz_u32(x14, (0x0 as u32), 0xffffffff);
    let mut x16: u32 = 0;
    let mut x17: fiat_p224_u1 = 0;
    let (x16, x17) =
        fiat_p224_addcarryx_u32(0x0, x1, (((x15 & (0x1 as u32)) as fiat_p224_u1) as u32));
    let mut x18: u32 = 0;
    let mut x19: fiat_p224_u1 = 0;
    let (x18, x19) = fiat_p224_addcarryx_u32(x17, x3, (0x0 as u32));
    let mut x20: u32 = 0;
    let mut x21: fiat_p224_u1 = 0;
    let (x20, x21) = fiat_p224_addcarryx_u32(x19, x5, (0x0 as u32));
    let mut x22: u32 = 0;
    let mut x23: fiat_p224_u1 = 0;
    let (x22, x23) = fiat_p224_addcarryx_u32(x21, x7, x15);
    let mut x24: u32 = 0;
    let mut x25: fiat_p224_u1 = 0;
    let (x24, x25) = fiat_p224_addcarryx_u32(x23, x9, x15);
    let mut x26: u32 = 0;
    let mut x27: fiat_p224_u1 = 0;
    let (x26, x27) = fiat_p224_addcarryx_u32(x25, x11, x15);
    let mut x28: u32 = 0;
    let mut x29: fiat_p224_u1 = 0;
    let (x28, x29) = fiat_p224_addcarryx_u32(x27, x13, x15);
    out1[0] = x16;
    out1[1] = x18;
    out1[2] = x20;
    out1[3] = x22;
    out1[4] = x24;
    out1[5] = x26;
    out1[6] = x28;
    out1
}
#[doc = " The function fiat_p224_opp negates a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_opp(
    arg1: &fiat_p224_montgomery_domain_field_element,
) -> fiat_p224_montgomery_domain_field_element {
    let mut out1: fiat_p224_montgomery_domain_field_element = [0; 7];
    let mut x1: u32 = 0;
    let mut x2: fiat_p224_u1 = 0;
    let (x1, x2) = fiat_p224_subborrowx_u32(0x0, (0x0 as u32), (arg1[0]));
    let mut x3: u32 = 0;
    let mut x4: fiat_p224_u1 = 0;
    let (x3, x4) = fiat_p224_subborrowx_u32(x2, (0x0 as u32), (arg1[1]));
    let mut x5: u32 = 0;
    let mut x6: fiat_p224_u1 = 0;
    let (x5, x6) = fiat_p224_subborrowx_u32(x4, (0x0 as u32), (arg1[2]));
    let mut x7: u32 = 0;
    let mut x8: fiat_p224_u1 = 0;
    let (x7, x8) = fiat_p224_subborrowx_u32(x6, (0x0 as u32), (arg1[3]));
    let mut x9: u32 = 0;
    let mut x10: fiat_p224_u1 = 0;
    let (x9, x10) = fiat_p224_subborrowx_u32(x8, (0x0 as u32), (arg1[4]));
    let mut x11: u32 = 0;
    let mut x12: fiat_p224_u1 = 0;
    let (x11, x12) = fiat_p224_subborrowx_u32(x10, (0x0 as u32), (arg1[5]));
    let mut x13: u32 = 0;
    let mut x14: fiat_p224_u1 = 0;
    let (x13, x14) = fiat_p224_subborrowx_u32(x12, (0x0 as u32), (arg1[6]));
    let mut x15: u32 = 0;
    let (x15) = fiat_p224_cmovznz_u32(x14, (0x0 as u32), 0xffffffff);
    let mut x16: u32 = 0;
    let mut x17: fiat_p224_u1 = 0;
    let (x16, x17) =
        fiat_p224_addcarryx_u32(0x0, x1, (((x15 & (0x1 as u32)) as fiat_p224_u1) as u32));
    let mut x18: u32 = 0;
    let mut x19: fiat_p224_u1 = 0;
    let (x18, x19) = fiat_p224_addcarryx_u32(x17, x3, (0x0 as u32));
    let mut x20: u32 = 0;
    let mut x21: fiat_p224_u1 = 0;
    let (x20, x21) = fiat_p224_addcarryx_u32(x19, x5, (0x0 as u32));
    let mut x22: u32 = 0;
    let mut x23: fiat_p224_u1 = 0;
    let (x22, x23) = fiat_p224_addcarryx_u32(x21, x7, x15);
    let mut x24: u32 = 0;
    let mut x25: fiat_p224_u1 = 0;
    let (x24, x25) = fiat_p224_addcarryx_u32(x23, x9, x15);
    let mut x26: u32 = 0;
    let mut x27: fiat_p224_u1 = 0;
    let (x26, x27) = fiat_p224_addcarryx_u32(x25, x11, x15);
    let mut x28: u32 = 0;
    let mut x29: fiat_p224_u1 = 0;
    let (x28, x29) = fiat_p224_addcarryx_u32(x27, x13, x15);
    out1[0] = x16;
    out1[1] = x18;
    out1[2] = x20;
    out1[3] = x22;
    out1[4] = x24;
    out1[5] = x26;
    out1[6] = x28;
    out1
}
#[doc = " The function fiat_p224_from_montgomery translates a field element out of the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^7) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_from_montgomery(
    arg1: &fiat_p224_montgomery_domain_field_element,
) -> fiat_p224_non_montgomery_domain_field_element {
    let mut out1: fiat_p224_non_montgomery_domain_field_element = [0; 7];
    let x1: u32 = (arg1[0]);
    let mut x2: u32 = 0;
    let mut x3: u32 = 0;
    let (x2, x3) = fiat_p224_mulx_u32(x1, 0xffffffff);
    let mut x4: u32 = 0;
    let mut x5: u32 = 0;
    let (x4, x5) = fiat_p224_mulx_u32(x2, 0xffffffff);
    let mut x6: u32 = 0;
    let mut x7: u32 = 0;
    let (x6, x7) = fiat_p224_mulx_u32(x2, 0xffffffff);
    let mut x8: u32 = 0;
    let mut x9: u32 = 0;
    let (x8, x9) = fiat_p224_mulx_u32(x2, 0xffffffff);
    let mut x10: u32 = 0;
    let mut x11: u32 = 0;
    let (x10, x11) = fiat_p224_mulx_u32(x2, 0xffffffff);
    let mut x12: u32 = 0;
    let mut x13: fiat_p224_u1 = 0;
    let (x12, x13) = fiat_p224_addcarryx_u32(0x0, x11, x8);
    let mut x14: u32 = 0;
    let mut x15: fiat_p224_u1 = 0;
    let (x14, x15) = fiat_p224_addcarryx_u32(x13, x9, x6);
    let mut x16: u32 = 0;
    let mut x17: fiat_p224_u1 = 0;
    let (x16, x17) = fiat_p224_addcarryx_u32(x15, x7, x4);
    let mut x18: u32 = 0;
    let mut x19: fiat_p224_u1 = 0;
    let (x18, x19) = fiat_p224_addcarryx_u32(0x0, x1, x2);
    let mut x20: u32 = 0;
    let mut x21: fiat_p224_u1 = 0;
    let (x20, x21) = fiat_p224_addcarryx_u32(0x0, (x19 as u32), (arg1[1]));
    let mut x22: u32 = 0;
    let mut x23: u32 = 0;
    let (x22, x23) = fiat_p224_mulx_u32(x20, 0xffffffff);
    let mut x24: u32 = 0;
    let mut x25: u32 = 0;
    let (x24, x25) = fiat_p224_mulx_u32(x22, 0xffffffff);
    let mut x26: u32 = 0;
    let mut x27: u32 = 0;
    let (x26, x27) = fiat_p224_mulx_u32(x22, 0xffffffff);
    let mut x28: u32 = 0;
    let mut x29: u32 = 0;
    let (x28, x29) = fiat_p224_mulx_u32(x22, 0xffffffff);
    let mut x30: u32 = 0;
    let mut x31: u32 = 0;
    let (x30, x31) = fiat_p224_mulx_u32(x22, 0xffffffff);
    let mut x32: u32 = 0;
    let mut x33: fiat_p224_u1 = 0;
    let (x32, x33) = fiat_p224_addcarryx_u32(0x0, x31, x28);
    let mut x34: u32 = 0;
    let mut x35: fiat_p224_u1 = 0;
    let (x34, x35) = fiat_p224_addcarryx_u32(x33, x29, x26);
    let mut x36: u32 = 0;
    let mut x37: fiat_p224_u1 = 0;
    let (x36, x37) = fiat_p224_addcarryx_u32(x35, x27, x24);
    let mut x38: u32 = 0;
    let mut x39: fiat_p224_u1 = 0;
    let (x38, x39) = fiat_p224_addcarryx_u32(0x0, x12, x30);
    let mut x40: u32 = 0;
    let mut x41: fiat_p224_u1 = 0;
    let (x40, x41) = fiat_p224_addcarryx_u32(x39, x14, x32);
    let mut x42: u32 = 0;
    let mut x43: fiat_p224_u1 = 0;
    let (x42, x43) = fiat_p224_addcarryx_u32(x41, x16, x34);
    let mut x44: u32 = 0;
    let mut x45: fiat_p224_u1 = 0;
    let (x44, x45) = fiat_p224_addcarryx_u32(x43, ((x17 as u32) + x5), x36);
    let mut x46: u32 = 0;
    let mut x47: fiat_p224_u1 = 0;
    let (x46, x47) = fiat_p224_addcarryx_u32(x45, (0x0 as u32), ((x37 as u32) + x25));
    let mut x48: u32 = 0;
    let mut x49: fiat_p224_u1 = 0;
    let (x48, x49) = fiat_p224_addcarryx_u32(0x0, x20, x22);
    let mut x50: u32 = 0;
    let mut x51: fiat_p224_u1 = 0;
    let (x50, x51) = fiat_p224_addcarryx_u32(0x0, ((x49 as u32) + (x21 as u32)), (arg1[2]));
    let mut x52: u32 = 0;
    let mut x53: fiat_p224_u1 = 0;
    let (x52, x53) = fiat_p224_addcarryx_u32(x51, x10, (0x0 as u32));
    let mut x54: u32 = 0;
    let mut x55: fiat_p224_u1 = 0;
    let (x54, x55) = fiat_p224_addcarryx_u32(x53, x38, (0x0 as u32));
    let mut x56: u32 = 0;
    let mut x57: fiat_p224_u1 = 0;
    let (x56, x57) = fiat_p224_addcarryx_u32(x55, x40, (0x0 as u32));
    let mut x58: u32 = 0;
    let mut x59: fiat_p224_u1 = 0;
    let (x58, x59) = fiat_p224_addcarryx_u32(x57, x42, (0x0 as u32));
    let mut x60: u32 = 0;
    let mut x61: fiat_p224_u1 = 0;
    let (x60, x61) = fiat_p224_addcarryx_u32(x59, x44, (0x0 as u32));
    let mut x62: u32 = 0;
    let mut x63: fiat_p224_u1 = 0;
    let (x62, x63) = fiat_p224_addcarryx_u32(x61, x46, (0x0 as u32));
    let mut x64: u32 = 0;
    let mut x65: u32 = 0;
    let (x64, x65) = fiat_p224_mulx_u32(x50, 0xffffffff);
    let mut x66: u32 = 0;
    let mut x67: u32 = 0;
    let (x66, x67) = fiat_p224_mulx_u32(x64, 0xffffffff);
    let mut x68: u32 = 0;
    let mut x69: u32 = 0;
    let (x68, x69) = fiat_p224_mulx_u32(x64, 0xffffffff);
    let mut x70: u32 = 0;
    let mut x71: u32 = 0;
    let (x70, x71) = fiat_p224_mulx_u32(x64, 0xffffffff);
    let mut x72: u32 = 0;
    let mut x73: u32 = 0;
    let (x72, x73) = fiat_p224_mulx_u32(x64, 0xffffffff);
    let mut x74: u32 = 0;
    let mut x75: fiat_p224_u1 = 0;
    let (x74, x75) = fiat_p224_addcarryx_u32(0x0, x73, x70);
    let mut x76: u32 = 0;
    let mut x77: fiat_p224_u1 = 0;
    let (x76, x77) = fiat_p224_addcarryx_u32(x75, x71, x68);
    let mut x78: u32 = 0;
    let mut x79: fiat_p224_u1 = 0;
    let (x78, x79) = fiat_p224_addcarryx_u32(x77, x69, x66);
    let mut x80: u32 = 0;
    let mut x81: fiat_p224_u1 = 0;
    let (x80, x81) = fiat_p224_addcarryx_u32(0x0, x50, x64);
    let mut x82: u32 = 0;
    let mut x83: fiat_p224_u1 = 0;
    let (x82, x83) = fiat_p224_addcarryx_u32(x81, x52, (0x0 as u32));
    let mut x84: u32 = 0;
    let mut x85: fiat_p224_u1 = 0;
    let (x84, x85) = fiat_p224_addcarryx_u32(x83, x54, (0x0 as u32));
    let mut x86: u32 = 0;
    let mut x87: fiat_p224_u1 = 0;
    let (x86, x87) = fiat_p224_addcarryx_u32(x85, x56, x72);
    let mut x88: u32 = 0;
    let mut x89: fiat_p224_u1 = 0;
    let (x88, x89) = fiat_p224_addcarryx_u32(x87, x58, x74);
    let mut x90: u32 = 0;
    let mut x91: fiat_p224_u1 = 0;
    let (x90, x91) = fiat_p224_addcarryx_u32(x89, x60, x76);
    let mut x92: u32 = 0;
    let mut x93: fiat_p224_u1 = 0;
    let (x92, x93) = fiat_p224_addcarryx_u32(x91, x62, x78);
    let mut x94: u32 = 0;
    let mut x95: fiat_p224_u1 = 0;
    let (x94, x95) =
        fiat_p224_addcarryx_u32(x93, ((x63 as u32) + (x47 as u32)), ((x79 as u32) + x67));
    let mut x96: u32 = 0;
    let mut x97: fiat_p224_u1 = 0;
    let (x96, x97) = fiat_p224_addcarryx_u32(0x0, x82, (arg1[3]));
    let mut x98: u32 = 0;
    let mut x99: fiat_p224_u1 = 0;
    let (x98, x99) = fiat_p224_addcarryx_u32(x97, x84, (0x0 as u32));
    let mut x100: u32 = 0;
    let mut x101: fiat_p224_u1 = 0;
    let (x100, x101) = fiat_p224_addcarryx_u32(x99, x86, (0x0 as u32));
    let mut x102: u32 = 0;
    let mut x103: fiat_p224_u1 = 0;
    let (x102, x103) = fiat_p224_addcarryx_u32(x101, x88, (0x0 as u32));
    let mut x104: u32 = 0;
    let mut x105: fiat_p224_u1 = 0;
    let (x104, x105) = fiat_p224_addcarryx_u32(x103, x90, (0x0 as u32));
    let mut x106: u32 = 0;
    let mut x107: fiat_p224_u1 = 0;
    let (x106, x107) = fiat_p224_addcarryx_u32(x105, x92, (0x0 as u32));
    let mut x108: u32 = 0;
    let mut x109: fiat_p224_u1 = 0;
    let (x108, x109) = fiat_p224_addcarryx_u32(x107, x94, (0x0 as u32));
    let mut x110: u32 = 0;
    let mut x111: u32 = 0;
    let (x110, x111) = fiat_p224_mulx_u32(x96, 0xffffffff);
    let mut x112: u32 = 0;
    let mut x113: u32 = 0;
    let (x112, x113) = fiat_p224_mulx_u32(x110, 0xffffffff);
    let mut x114: u32 = 0;
    let mut x115: u32 = 0;
    let (x114, x115) = fiat_p224_mulx_u32(x110, 0xffffffff);
    let mut x116: u32 = 0;
    let mut x117: u32 = 0;
    let (x116, x117) = fiat_p224_mulx_u32(x110, 0xffffffff);
    let mut x118: u32 = 0;
    let mut x119: u32 = 0;
    let (x118, x119) = fiat_p224_mulx_u32(x110, 0xffffffff);
    let mut x120: u32 = 0;
    let mut x121: fiat_p224_u1 = 0;
    let (x120, x121) = fiat_p224_addcarryx_u32(0x0, x119, x116);
    let mut x122: u32 = 0;
    let mut x123: fiat_p224_u1 = 0;
    let (x122, x123) = fiat_p224_addcarryx_u32(x121, x117, x114);
    let mut x124: u32 = 0;
    let mut x125: fiat_p224_u1 = 0;
    let (x124, x125) = fiat_p224_addcarryx_u32(x123, x115, x112);
    let mut x126: u32 = 0;
    let mut x127: fiat_p224_u1 = 0;
    let (x126, x127) = fiat_p224_addcarryx_u32(0x0, x96, x110);
    let mut x128: u32 = 0;
    let mut x129: fiat_p224_u1 = 0;
    let (x128, x129) = fiat_p224_addcarryx_u32(x127, x98, (0x0 as u32));
    let mut x130: u32 = 0;
    let mut x131: fiat_p224_u1 = 0;
    let (x130, x131) = fiat_p224_addcarryx_u32(x129, x100, (0x0 as u32));
    let mut x132: u32 = 0;
    let mut x133: fiat_p224_u1 = 0;
    let (x132, x133) = fiat_p224_addcarryx_u32(x131, x102, x118);
    let mut x134: u32 = 0;
    let mut x135: fiat_p224_u1 = 0;
    let (x134, x135) = fiat_p224_addcarryx_u32(x133, x104, x120);
    let mut x136: u32 = 0;
    let mut x137: fiat_p224_u1 = 0;
    let (x136, x137) = fiat_p224_addcarryx_u32(x135, x106, x122);
    let mut x138: u32 = 0;
    let mut x139: fiat_p224_u1 = 0;
    let (x138, x139) = fiat_p224_addcarryx_u32(x137, x108, x124);
    let mut x140: u32 = 0;
    let mut x141: fiat_p224_u1 = 0;
    let (x140, x141) =
        fiat_p224_addcarryx_u32(x139, ((x109 as u32) + (x95 as u32)), ((x125 as u32) + x113));
    let mut x142: u32 = 0;
    let mut x143: fiat_p224_u1 = 0;
    let (x142, x143) = fiat_p224_addcarryx_u32(0x0, x128, (arg1[4]));
    let mut x144: u32 = 0;
    let mut x145: fiat_p224_u1 = 0;
    let (x144, x145) = fiat_p224_addcarryx_u32(x143, x130, (0x0 as u32));
    let mut x146: u32 = 0;
    let mut x147: fiat_p224_u1 = 0;
    let (x146, x147) = fiat_p224_addcarryx_u32(x145, x132, (0x0 as u32));
    let mut x148: u32 = 0;
    let mut x149: fiat_p224_u1 = 0;
    let (x148, x149) = fiat_p224_addcarryx_u32(x147, x134, (0x0 as u32));
    let mut x150: u32 = 0;
    let mut x151: fiat_p224_u1 = 0;
    let (x150, x151) = fiat_p224_addcarryx_u32(x149, x136, (0x0 as u32));
    let mut x152: u32 = 0;
    let mut x153: fiat_p224_u1 = 0;
    let (x152, x153) = fiat_p224_addcarryx_u32(x151, x138, (0x0 as u32));
    let mut x154: u32 = 0;
    let mut x155: fiat_p224_u1 = 0;
    let (x154, x155) = fiat_p224_addcarryx_u32(x153, x140, (0x0 as u32));
    let mut x156: u32 = 0;
    let mut x157: u32 = 0;
    let (x156, x157) = fiat_p224_mulx_u32(x142, 0xffffffff);
    let mut x158: u32 = 0;
    let mut x159: u32 = 0;
    let (x158, x159) = fiat_p224_mulx_u32(x156, 0xffffffff);
    let mut x160: u32 = 0;
    let mut x161: u32 = 0;
    let (x160, x161) = fiat_p224_mulx_u32(x156, 0xffffffff);
    let mut x162: u32 = 0;
    let mut x163: u32 = 0;
    let (x162, x163) = fiat_p224_mulx_u32(x156, 0xffffffff);
    let mut x164: u32 = 0;
    let mut x165: u32 = 0;
    let (x164, x165) = fiat_p224_mulx_u32(x156, 0xffffffff);
    let mut x166: u32 = 0;
    let mut x167: fiat_p224_u1 = 0;
    let (x166, x167) = fiat_p224_addcarryx_u32(0x0, x165, x162);
    let mut x168: u32 = 0;
    let mut x169: fiat_p224_u1 = 0;
    let (x168, x169) = fiat_p224_addcarryx_u32(x167, x163, x160);
    let mut x170: u32 = 0;
    let mut x171: fiat_p224_u1 = 0;
    let (x170, x171) = fiat_p224_addcarryx_u32(x169, x161, x158);
    let mut x172: u32 = 0;
    let mut x173: fiat_p224_u1 = 0;
    let (x172, x173) = fiat_p224_addcarryx_u32(0x0, x142, x156);
    let mut x174: u32 = 0;
    let mut x175: fiat_p224_u1 = 0;
    let (x174, x175) = fiat_p224_addcarryx_u32(x173, x144, (0x0 as u32));
    let mut x176: u32 = 0;
    let mut x177: fiat_p224_u1 = 0;
    let (x176, x177) = fiat_p224_addcarryx_u32(x175, x146, (0x0 as u32));
    let mut x178: u32 = 0;
    let mut x179: fiat_p224_u1 = 0;
    let (x178, x179) = fiat_p224_addcarryx_u32(x177, x148, x164);
    let mut x180: u32 = 0;
    let mut x181: fiat_p224_u1 = 0;
    let (x180, x181) = fiat_p224_addcarryx_u32(x179, x150, x166);
    let mut x182: u32 = 0;
    let mut x183: fiat_p224_u1 = 0;
    let (x182, x183) = fiat_p224_addcarryx_u32(x181, x152, x168);
    let mut x184: u32 = 0;
    let mut x185: fiat_p224_u1 = 0;
    let (x184, x185) = fiat_p224_addcarryx_u32(x183, x154, x170);
    let mut x186: u32 = 0;
    let mut x187: fiat_p224_u1 = 0;
    let (x186, x187) = fiat_p224_addcarryx_u32(
        x185,
        ((x155 as u32) + (x141 as u32)),
        ((x171 as u32) + x159),
    );
    let mut x188: u32 = 0;
    let mut x189: fiat_p224_u1 = 0;
    let (x188, x189) = fiat_p224_addcarryx_u32(0x0, x174, (arg1[5]));
    let mut x190: u32 = 0;
    let mut x191: fiat_p224_u1 = 0;
    let (x190, x191) = fiat_p224_addcarryx_u32(x189, x176, (0x0 as u32));
    let mut x192: u32 = 0;
    let mut x193: fiat_p224_u1 = 0;
    let (x192, x193) = fiat_p224_addcarryx_u32(x191, x178, (0x0 as u32));
    let mut x194: u32 = 0;
    let mut x195: fiat_p224_u1 = 0;
    let (x194, x195) = fiat_p224_addcarryx_u32(x193, x180, (0x0 as u32));
    let mut x196: u32 = 0;
    let mut x197: fiat_p224_u1 = 0;
    let (x196, x197) = fiat_p224_addcarryx_u32(x195, x182, (0x0 as u32));
    let mut x198: u32 = 0;
    let mut x199: fiat_p224_u1 = 0;
    let (x198, x199) = fiat_p224_addcarryx_u32(x197, x184, (0x0 as u32));
    let mut x200: u32 = 0;
    let mut x201: fiat_p224_u1 = 0;
    let (x200, x201) = fiat_p224_addcarryx_u32(x199, x186, (0x0 as u32));
    let mut x202: u32 = 0;
    let mut x203: u32 = 0;
    let (x202, x203) = fiat_p224_mulx_u32(x188, 0xffffffff);
    let mut x204: u32 = 0;
    let mut x205: u32 = 0;
    let (x204, x205) = fiat_p224_mulx_u32(x202, 0xffffffff);
    let mut x206: u32 = 0;
    let mut x207: u32 = 0;
    let (x206, x207) = fiat_p224_mulx_u32(x202, 0xffffffff);
    let mut x208: u32 = 0;
    let mut x209: u32 = 0;
    let (x208, x209) = fiat_p224_mulx_u32(x202, 0xffffffff);
    let mut x210: u32 = 0;
    let mut x211: u32 = 0;
    let (x210, x211) = fiat_p224_mulx_u32(x202, 0xffffffff);
    let mut x212: u32 = 0;
    let mut x213: fiat_p224_u1 = 0;
    let (x212, x213) = fiat_p224_addcarryx_u32(0x0, x211, x208);
    let mut x214: u32 = 0;
    let mut x215: fiat_p224_u1 = 0;
    let (x214, x215) = fiat_p224_addcarryx_u32(x213, x209, x206);
    let mut x216: u32 = 0;
    let mut x217: fiat_p224_u1 = 0;
    let (x216, x217) = fiat_p224_addcarryx_u32(x215, x207, x204);
    let mut x218: u32 = 0;
    let mut x219: fiat_p224_u1 = 0;
    let (x218, x219) = fiat_p224_addcarryx_u32(0x0, x188, x202);
    let mut x220: u32 = 0;
    let mut x221: fiat_p224_u1 = 0;
    let (x220, x221) = fiat_p224_addcarryx_u32(x219, x190, (0x0 as u32));
    let mut x222: u32 = 0;
    let mut x223: fiat_p224_u1 = 0;
    let (x222, x223) = fiat_p224_addcarryx_u32(x221, x192, (0x0 as u32));
    let mut x224: u32 = 0;
    let mut x225: fiat_p224_u1 = 0;
    let (x224, x225) = fiat_p224_addcarryx_u32(x223, x194, x210);
    let mut x226: u32 = 0;
    let mut x227: fiat_p224_u1 = 0;
    let (x226, x227) = fiat_p224_addcarryx_u32(x225, x196, x212);
    let mut x228: u32 = 0;
    let mut x229: fiat_p224_u1 = 0;
    let (x228, x229) = fiat_p224_addcarryx_u32(x227, x198, x214);
    let mut x230: u32 = 0;
    let mut x231: fiat_p224_u1 = 0;
    let (x230, x231) = fiat_p224_addcarryx_u32(x229, x200, x216);
    let mut x232: u32 = 0;
    let mut x233: fiat_p224_u1 = 0;
    let (x232, x233) = fiat_p224_addcarryx_u32(
        x231,
        ((x201 as u32) + (x187 as u32)),
        ((x217 as u32) + x205),
    );
    let mut x234: u32 = 0;
    let mut x235: fiat_p224_u1 = 0;
    let (x234, x235) = fiat_p224_addcarryx_u32(0x0, x220, (arg1[6]));
    let mut x236: u32 = 0;
    let mut x237: fiat_p224_u1 = 0;
    let (x236, x237) = fiat_p224_addcarryx_u32(x235, x222, (0x0 as u32));
    let mut x238: u32 = 0;
    let mut x239: fiat_p224_u1 = 0;
    let (x238, x239) = fiat_p224_addcarryx_u32(x237, x224, (0x0 as u32));
    let mut x240: u32 = 0;
    let mut x241: fiat_p224_u1 = 0;
    let (x240, x241) = fiat_p224_addcarryx_u32(x239, x226, (0x0 as u32));
    let mut x242: u32 = 0;
    let mut x243: fiat_p224_u1 = 0;
    let (x242, x243) = fiat_p224_addcarryx_u32(x241, x228, (0x0 as u32));
    let mut x244: u32 = 0;
    let mut x245: fiat_p224_u1 = 0;
    let (x244, x245) = fiat_p224_addcarryx_u32(x243, x230, (0x0 as u32));
    let mut x246: u32 = 0;
    let mut x247: fiat_p224_u1 = 0;
    let (x246, x247) = fiat_p224_addcarryx_u32(x245, x232, (0x0 as u32));
    let mut x248: u32 = 0;
    let mut x249: u32 = 0;
    let (x248, x249) = fiat_p224_mulx_u32(x234, 0xffffffff);
    let mut x250: u32 = 0;
    let mut x251: u32 = 0;
    let (x250, x251) = fiat_p224_mulx_u32(x248, 0xffffffff);
    let mut x252: u32 = 0;
    let mut x253: u32 = 0;
    let (x252, x253) = fiat_p224_mulx_u32(x248, 0xffffffff);
    let mut x254: u32 = 0;
    let mut x255: u32 = 0;
    let (x254, x255) = fiat_p224_mulx_u32(x248, 0xffffffff);
    let mut x256: u32 = 0;
    let mut x257: u32 = 0;
    let (x256, x257) = fiat_p224_mulx_u32(x248, 0xffffffff);
    let mut x258: u32 = 0;
    let mut x259: fiat_p224_u1 = 0;
    let (x258, x259) = fiat_p224_addcarryx_u32(0x0, x257, x254);
    let mut x260: u32 = 0;
    let mut x261: fiat_p224_u1 = 0;
    let (x260, x261) = fiat_p224_addcarryx_u32(x259, x255, x252);
    let mut x262: u32 = 0;
    let mut x263: fiat_p224_u1 = 0;
    let (x262, x263) = fiat_p224_addcarryx_u32(x261, x253, x250);
    let mut x264: u32 = 0;
    let mut x265: fiat_p224_u1 = 0;
    let (x264, x265) = fiat_p224_addcarryx_u32(0x0, x234, x248);
    let mut x266: u32 = 0;
    let mut x267: fiat_p224_u1 = 0;
    let (x266, x267) = fiat_p224_addcarryx_u32(x265, x236, (0x0 as u32));
    let mut x268: u32 = 0;
    let mut x269: fiat_p224_u1 = 0;
    let (x268, x269) = fiat_p224_addcarryx_u32(x267, x238, (0x0 as u32));
    let mut x270: u32 = 0;
    let mut x271: fiat_p224_u1 = 0;
    let (x270, x271) = fiat_p224_addcarryx_u32(x269, x240, x256);
    let mut x272: u32 = 0;
    let mut x273: fiat_p224_u1 = 0;
    let (x272, x273) = fiat_p224_addcarryx_u32(x271, x242, x258);
    let mut x274: u32 = 0;
    let mut x275: fiat_p224_u1 = 0;
    let (x274, x275) = fiat_p224_addcarryx_u32(x273, x244, x260);
    let mut x276: u32 = 0;
    let mut x277: fiat_p224_u1 = 0;
    let (x276, x277) = fiat_p224_addcarryx_u32(x275, x246, x262);
    let mut x278: u32 = 0;
    let mut x279: fiat_p224_u1 = 0;
    let (x278, x279) = fiat_p224_addcarryx_u32(
        x277,
        ((x247 as u32) + (x233 as u32)),
        ((x263 as u32) + x251),
    );
    let mut x280: u32 = 0;
    let mut x281: fiat_p224_u1 = 0;
    let (x280, x281) = fiat_p224_subborrowx_u32(0x0, x266, (0x1 as u32));
    let mut x282: u32 = 0;
    let mut x283: fiat_p224_u1 = 0;
    let (x282, x283) = fiat_p224_subborrowx_u32(x281, x268, (0x0 as u32));
    let mut x284: u32 = 0;
    let mut x285: fiat_p224_u1 = 0;
    let (x284, x285) = fiat_p224_subborrowx_u32(x283, x270, (0x0 as u32));
    let mut x286: u32 = 0;
    let mut x287: fiat_p224_u1 = 0;
    let (x286, x287) = fiat_p224_subborrowx_u32(x285, x272, 0xffffffff);
    let mut x288: u32 = 0;
    let mut x289: fiat_p224_u1 = 0;
    let (x288, x289) = fiat_p224_subborrowx_u32(x287, x274, 0xffffffff);
    let mut x290: u32 = 0;
    let mut x291: fiat_p224_u1 = 0;
    let (x290, x291) = fiat_p224_subborrowx_u32(x289, x276, 0xffffffff);
    let mut x292: u32 = 0;
    let mut x293: fiat_p224_u1 = 0;
    let (x292, x293) = fiat_p224_subborrowx_u32(x291, x278, 0xffffffff);
    let mut x294: u32 = 0;
    let mut x295: fiat_p224_u1 = 0;
    let (x294, x295) = fiat_p224_subborrowx_u32(x293, (x279 as u32), (0x0 as u32));
    let mut x296: u32 = 0;
    let (x296) = fiat_p224_cmovznz_u32(x295, x280, x266);
    let mut x297: u32 = 0;
    let (x297) = fiat_p224_cmovznz_u32(x295, x282, x268);
    let mut x298: u32 = 0;
    let (x298) = fiat_p224_cmovznz_u32(x295, x284, x270);
    let mut x299: u32 = 0;
    let (x299) = fiat_p224_cmovznz_u32(x295, x286, x272);
    let mut x300: u32 = 0;
    let (x300) = fiat_p224_cmovznz_u32(x295, x288, x274);
    let mut x301: u32 = 0;
    let (x301) = fiat_p224_cmovznz_u32(x295, x290, x276);
    let mut x302: u32 = 0;
    let (x302) = fiat_p224_cmovznz_u32(x295, x292, x278);
    out1[0] = x296;
    out1[1] = x297;
    out1[2] = x298;
    out1[3] = x299;
    out1[4] = x300;
    out1[5] = x301;
    out1[6] = x302;
    out1
}
#[doc = " The function fiat_p224_to_montgomery translates a field element into the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_to_montgomery(
    arg1: &fiat_p224_non_montgomery_domain_field_element,
) -> fiat_p224_montgomery_domain_field_element {
    let mut out1: fiat_p224_montgomery_domain_field_element = [0; 7];
    let x1: u32 = (arg1[1]);
    let x2: u32 = (arg1[2]);
    let x3: u32 = (arg1[3]);
    let x4: u32 = (arg1[4]);
    let x5: u32 = (arg1[5]);
    let x6: u32 = (arg1[6]);
    let x7: u32 = (arg1[0]);
    let mut x8: u32 = 0;
    let mut x9: u32 = 0;
    let (x8, x9) = fiat_p224_mulx_u32(x7, 0xffffffff);
    let mut x10: u32 = 0;
    let mut x11: u32 = 0;
    let (x10, x11) = fiat_p224_mulx_u32(x7, 0xffffffff);
    let mut x12: u32 = 0;
    let mut x13: u32 = 0;
    let (x12, x13) = fiat_p224_mulx_u32(x7, 0xfffffffe);
    let mut x14: u32 = 0;
    let mut x15: fiat_p224_u1 = 0;
    let (x14, x15) = fiat_p224_addcarryx_u32(0x0, x13, x10);
    let mut x16: u32 = 0;
    let mut x17: fiat_p224_u1 = 0;
    let (x16, x17) = fiat_p224_addcarryx_u32(x15, x11, x8);
    let mut x18: u32 = 0;
    let mut x19: u32 = 0;
    let (x18, x19) = fiat_p224_mulx_u32(x7, 0xffffffff);
    let mut x20: u32 = 0;
    let mut x21: u32 = 0;
    let (x20, x21) = fiat_p224_mulx_u32(x18, 0xffffffff);
    let mut x22: u32 = 0;
    let mut x23: u32 = 0;
    let (x22, x23) = fiat_p224_mulx_u32(x18, 0xffffffff);
    let mut x24: u32 = 0;
    let mut x25: u32 = 0;
    let (x24, x25) = fiat_p224_mulx_u32(x18, 0xffffffff);
    let mut x26: u32 = 0;
    let mut x27: u32 = 0;
    let (x26, x27) = fiat_p224_mulx_u32(x18, 0xffffffff);
    let mut x28: u32 = 0;
    let mut x29: fiat_p224_u1 = 0;
    let (x28, x29) = fiat_p224_addcarryx_u32(0x0, x27, x24);
    let mut x30: u32 = 0;
    let mut x31: fiat_p224_u1 = 0;
    let (x30, x31) = fiat_p224_addcarryx_u32(x29, x25, x22);
    let mut x32: u32 = 0;
    let mut x33: fiat_p224_u1 = 0;
    let (x32, x33) = fiat_p224_addcarryx_u32(x31, x23, x20);
    let mut x34: u32 = 0;
    let mut x35: fiat_p224_u1 = 0;
    let (x34, x35) = fiat_p224_addcarryx_u32(0x0, x12, x26);
    let mut x36: u32 = 0;
    let mut x37: fiat_p224_u1 = 0;
    let (x36, x37) = fiat_p224_addcarryx_u32(x35, x14, x28);
    let mut x38: u32 = 0;
    let mut x39: fiat_p224_u1 = 0;
    let (x38, x39) = fiat_p224_addcarryx_u32(x37, x16, x30);
    let mut x40: u32 = 0;
    let mut x41: fiat_p224_u1 = 0;
    let (x40, x41) = fiat_p224_addcarryx_u32(x39, ((x17 as u32) + x9), x32);
    let mut x42: u32 = 0;
    let mut x43: fiat_p224_u1 = 0;
    let (x42, x43) = fiat_p224_addcarryx_u32(x41, (0x0 as u32), ((x33 as u32) + x21));
    let mut x44: u32 = 0;
    let mut x45: u32 = 0;
    let (x44, x45) = fiat_p224_mulx_u32(x1, 0xffffffff);
    let mut x46: u32 = 0;
    let mut x47: u32 = 0;
    let (x46, x47) = fiat_p224_mulx_u32(x1, 0xffffffff);
    let mut x48: u32 = 0;
    let mut x49: u32 = 0;
    let (x48, x49) = fiat_p224_mulx_u32(x1, 0xfffffffe);
    let mut x50: u32 = 0;
    let mut x51: fiat_p224_u1 = 0;
    let (x50, x51) = fiat_p224_addcarryx_u32(0x0, x49, x46);
    let mut x52: u32 = 0;
    let mut x53: fiat_p224_u1 = 0;
    let (x52, x53) = fiat_p224_addcarryx_u32(x51, x47, x44);
    let mut x54: u32 = 0;
    let mut x55: fiat_p224_u1 = 0;
    let (x54, x55) = fiat_p224_addcarryx_u32(0x0, x7, x18);
    let mut x56: u32 = 0;
    let mut x57: fiat_p224_u1 = 0;
    let (x56, x57) = fiat_p224_addcarryx_u32(0x0, (x55 as u32), x1);
    let mut x58: u32 = 0;
    let mut x59: fiat_p224_u1 = 0;
    let (x58, x59) = fiat_p224_addcarryx_u32(0x0, x36, x48);
    let mut x60: u32 = 0;
    let mut x61: fiat_p224_u1 = 0;
    let (x60, x61) = fiat_p224_addcarryx_u32(x59, x38, x50);
    let mut x62: u32 = 0;
    let mut x63: fiat_p224_u1 = 0;
    let (x62, x63) = fiat_p224_addcarryx_u32(x61, x40, x52);
    let mut x64: u32 = 0;
    let mut x65: fiat_p224_u1 = 0;
    let (x64, x65) = fiat_p224_addcarryx_u32(x63, x42, ((x53 as u32) + x45));
    let mut x66: u32 = 0;
    let mut x67: u32 = 0;
    let (x66, x67) = fiat_p224_mulx_u32(x56, 0xffffffff);
    let mut x68: u32 = 0;
    let mut x69: u32 = 0;
    let (x68, x69) = fiat_p224_mulx_u32(x66, 0xffffffff);
    let mut x70: u32 = 0;
    let mut x71: u32 = 0;
    let (x70, x71) = fiat_p224_mulx_u32(x66, 0xffffffff);
    let mut x72: u32 = 0;
    let mut x73: u32 = 0;
    let (x72, x73) = fiat_p224_mulx_u32(x66, 0xffffffff);
    let mut x74: u32 = 0;
    let mut x75: u32 = 0;
    let (x74, x75) = fiat_p224_mulx_u32(x66, 0xffffffff);
    let mut x76: u32 = 0;
    let mut x77: fiat_p224_u1 = 0;
    let (x76, x77) = fiat_p224_addcarryx_u32(0x0, x75, x72);
    let mut x78: u32 = 0;
    let mut x79: fiat_p224_u1 = 0;
    let (x78, x79) = fiat_p224_addcarryx_u32(x77, x73, x70);
    let mut x80: u32 = 0;
    let mut x81: fiat_p224_u1 = 0;
    let (x80, x81) = fiat_p224_addcarryx_u32(x79, x71, x68);
    let mut x82: u32 = 0;
    let mut x83: fiat_p224_u1 = 0;
    let (x82, x83) = fiat_p224_addcarryx_u32(0x0, x58, x74);
    let mut x84: u32 = 0;
    let mut x85: fiat_p224_u1 = 0;
    let (x84, x85) = fiat_p224_addcarryx_u32(x83, x60, x76);
    let mut x86: u32 = 0;
    let mut x87: fiat_p224_u1 = 0;
    let (x86, x87) = fiat_p224_addcarryx_u32(x85, x62, x78);
    let mut x88: u32 = 0;
    let mut x89: fiat_p224_u1 = 0;
    let (x88, x89) = fiat_p224_addcarryx_u32(x87, x64, x80);
    let mut x90: u32 = 0;
    let mut x91: fiat_p224_u1 = 0;
    let (x90, x91) =
        fiat_p224_addcarryx_u32(x89, ((x65 as u32) + (x43 as u32)), ((x81 as u32) + x69));
    let mut x92: u32 = 0;
    let mut x93: u32 = 0;
    let (x92, x93) = fiat_p224_mulx_u32(x2, 0xffffffff);
    let mut x94: u32 = 0;
    let mut x95: u32 = 0;
    let (x94, x95) = fiat_p224_mulx_u32(x2, 0xffffffff);
    let mut x96: u32 = 0;
    let mut x97: u32 = 0;
    let (x96, x97) = fiat_p224_mulx_u32(x2, 0xfffffffe);
    let mut x98: u32 = 0;
    let mut x99: fiat_p224_u1 = 0;
    let (x98, x99) = fiat_p224_addcarryx_u32(0x0, x97, x94);
    let mut x100: u32 = 0;
    let mut x101: fiat_p224_u1 = 0;
    let (x100, x101) = fiat_p224_addcarryx_u32(x99, x95, x92);
    let mut x102: u32 = 0;
    let mut x103: fiat_p224_u1 = 0;
    let (x102, x103) = fiat_p224_addcarryx_u32(0x0, x56, x66);
    let mut x104: u32 = 0;
    let mut x105: fiat_p224_u1 = 0;
    let (x104, x105) = fiat_p224_addcarryx_u32(0x0, ((x103 as u32) + (x57 as u32)), x2);
    let mut x106: u32 = 0;
    let mut x107: fiat_p224_u1 = 0;
    let (x106, x107) = fiat_p224_addcarryx_u32(x105, x34, (0x0 as u32));
    let mut x108: u32 = 0;
    let mut x109: fiat_p224_u1 = 0;
    let (x108, x109) = fiat_p224_addcarryx_u32(x107, x82, (0x0 as u32));
    let mut x110: u32 = 0;
    let mut x111: fiat_p224_u1 = 0;
    let (x110, x111) = fiat_p224_addcarryx_u32(x109, x84, x96);
    let mut x112: u32 = 0;
    let mut x113: fiat_p224_u1 = 0;
    let (x112, x113) = fiat_p224_addcarryx_u32(x111, x86, x98);
    let mut x114: u32 = 0;
    let mut x115: fiat_p224_u1 = 0;
    let (x114, x115) = fiat_p224_addcarryx_u32(x113, x88, x100);
    let mut x116: u32 = 0;
    let mut x117: fiat_p224_u1 = 0;
    let (x116, x117) = fiat_p224_addcarryx_u32(x115, x90, ((x101 as u32) + x93));
    let mut x118: u32 = 0;
    let mut x119: u32 = 0;
    let (x118, x119) = fiat_p224_mulx_u32(x104, 0xffffffff);
    let mut x120: u32 = 0;
    let mut x121: u32 = 0;
    let (x120, x121) = fiat_p224_mulx_u32(x118, 0xffffffff);
    let mut x122: u32 = 0;
    let mut x123: u32 = 0;
    let (x122, x123) = fiat_p224_mulx_u32(x118, 0xffffffff);
    let mut x124: u32 = 0;
    let mut x125: u32 = 0;
    let (x124, x125) = fiat_p224_mulx_u32(x118, 0xffffffff);
    let mut x126: u32 = 0;
    let mut x127: u32 = 0;
    let (x126, x127) = fiat_p224_mulx_u32(x118, 0xffffffff);
    let mut x128: u32 = 0;
    let mut x129: fiat_p224_u1 = 0;
    let (x128, x129) = fiat_p224_addcarryx_u32(0x0, x127, x124);
    let mut x130: u32 = 0;
    let mut x131: fiat_p224_u1 = 0;
    let (x130, x131) = fiat_p224_addcarryx_u32(x129, x125, x122);
    let mut x132: u32 = 0;
    let mut x133: fiat_p224_u1 = 0;
    let (x132, x133) = fiat_p224_addcarryx_u32(x131, x123, x120);
    let mut x134: u32 = 0;
    let mut x135: fiat_p224_u1 = 0;
    let (x134, x135) = fiat_p224_addcarryx_u32(0x0, x104, x118);
    let mut x136: u32 = 0;
    let mut x137: fiat_p224_u1 = 0;
    let (x136, x137) = fiat_p224_addcarryx_u32(x135, x106, (0x0 as u32));
    let mut x138: u32 = 0;
    let mut x139: fiat_p224_u1 = 0;
    let (x138, x139) = fiat_p224_addcarryx_u32(x137, x108, (0x0 as u32));
    let mut x140: u32 = 0;
    let mut x141: fiat_p224_u1 = 0;
    let (x140, x141) = fiat_p224_addcarryx_u32(x139, x110, x126);
    let mut x142: u32 = 0;
    let mut x143: fiat_p224_u1 = 0;
    let (x142, x143) = fiat_p224_addcarryx_u32(x141, x112, x128);
    let mut x144: u32 = 0;
    let mut x145: fiat_p224_u1 = 0;
    let (x144, x145) = fiat_p224_addcarryx_u32(x143, x114, x130);
    let mut x146: u32 = 0;
    let mut x147: fiat_p224_u1 = 0;
    let (x146, x147) = fiat_p224_addcarryx_u32(x145, x116, x132);
    let mut x148: u32 = 0;
    let mut x149: fiat_p224_u1 = 0;
    let (x148, x149) =
        fiat_p224_addcarryx_u32(x147, ((x117 as u32) + (x91 as u32)), ((x133 as u32) + x121));
    let mut x150: u32 = 0;
    let mut x151: u32 = 0;
    let (x150, x151) = fiat_p224_mulx_u32(x3, 0xffffffff);
    let mut x152: u32 = 0;
    let mut x153: u32 = 0;
    let (x152, x153) = fiat_p224_mulx_u32(x3, 0xffffffff);
    let mut x154: u32 = 0;
    let mut x155: u32 = 0;
    let (x154, x155) = fiat_p224_mulx_u32(x3, 0xfffffffe);
    let mut x156: u32 = 0;
    let mut x157: fiat_p224_u1 = 0;
    let (x156, x157) = fiat_p224_addcarryx_u32(0x0, x155, x152);
    let mut x158: u32 = 0;
    let mut x159: fiat_p224_u1 = 0;
    let (x158, x159) = fiat_p224_addcarryx_u32(x157, x153, x150);
    let mut x160: u32 = 0;
    let mut x161: fiat_p224_u1 = 0;
    let (x160, x161) = fiat_p224_addcarryx_u32(0x0, x136, x3);
    let mut x162: u32 = 0;
    let mut x163: fiat_p224_u1 = 0;
    let (x162, x163) = fiat_p224_addcarryx_u32(x161, x138, (0x0 as u32));
    let mut x164: u32 = 0;
    let mut x165: fiat_p224_u1 = 0;
    let (x164, x165) = fiat_p224_addcarryx_u32(x163, x140, (0x0 as u32));
    let mut x166: u32 = 0;
    let mut x167: fiat_p224_u1 = 0;
    let (x166, x167) = fiat_p224_addcarryx_u32(x165, x142, x154);
    let mut x168: u32 = 0;
    let mut x169: fiat_p224_u1 = 0;
    let (x168, x169) = fiat_p224_addcarryx_u32(x167, x144, x156);
    let mut x170: u32 = 0;
    let mut x171: fiat_p224_u1 = 0;
    let (x170, x171) = fiat_p224_addcarryx_u32(x169, x146, x158);
    let mut x172: u32 = 0;
    let mut x173: fiat_p224_u1 = 0;
    let (x172, x173) = fiat_p224_addcarryx_u32(x171, x148, ((x159 as u32) + x151));
    let mut x174: u32 = 0;
    let mut x175: u32 = 0;
    let (x174, x175) = fiat_p224_mulx_u32(x160, 0xffffffff);
    let mut x176: u32 = 0;
    let mut x177: u32 = 0;
    let (x176, x177) = fiat_p224_mulx_u32(x174, 0xffffffff);
    let mut x178: u32 = 0;
    let mut x179: u32 = 0;
    let (x178, x179) = fiat_p224_mulx_u32(x174, 0xffffffff);
    let mut x180: u32 = 0;
    let mut x181: u32 = 0;
    let (x180, x181) = fiat_p224_mulx_u32(x174, 0xffffffff);
    let mut x182: u32 = 0;
    let mut x183: u32 = 0;
    let (x182, x183) = fiat_p224_mulx_u32(x174, 0xffffffff);
    let mut x184: u32 = 0;
    let mut x185: fiat_p224_u1 = 0;
    let (x184, x185) = fiat_p224_addcarryx_u32(0x0, x183, x180);
    let mut x186: u32 = 0;
    let mut x187: fiat_p224_u1 = 0;
    let (x186, x187) = fiat_p224_addcarryx_u32(x185, x181, x178);
    let mut x188: u32 = 0;
    let mut x189: fiat_p224_u1 = 0;
    let (x188, x189) = fiat_p224_addcarryx_u32(x187, x179, x176);
    let mut x190: u32 = 0;
    let mut x191: fiat_p224_u1 = 0;
    let (x190, x191) = fiat_p224_addcarryx_u32(0x0, x160, x174);
    let mut x192: u32 = 0;
    let mut x193: fiat_p224_u1 = 0;
    let (x192, x193) = fiat_p224_addcarryx_u32(x191, x162, (0x0 as u32));
    let mut x194: u32 = 0;
    let mut x195: fiat_p224_u1 = 0;
    let (x194, x195) = fiat_p224_addcarryx_u32(x193, x164, (0x0 as u32));
    let mut x196: u32 = 0;
    let mut x197: fiat_p224_u1 = 0;
    let (x196, x197) = fiat_p224_addcarryx_u32(x195, x166, x182);
    let mut x198: u32 = 0;
    let mut x199: fiat_p224_u1 = 0;
    let (x198, x199) = fiat_p224_addcarryx_u32(x197, x168, x184);
    let mut x200: u32 = 0;
    let mut x201: fiat_p224_u1 = 0;
    let (x200, x201) = fiat_p224_addcarryx_u32(x199, x170, x186);
    let mut x202: u32 = 0;
    let mut x203: fiat_p224_u1 = 0;
    let (x202, x203) = fiat_p224_addcarryx_u32(x201, x172, x188);
    let mut x204: u32 = 0;
    let mut x205: fiat_p224_u1 = 0;
    let (x204, x205) = fiat_p224_addcarryx_u32(
        x203,
        ((x173 as u32) + (x149 as u32)),
        ((x189 as u32) + x177),
    );
    let mut x206: u32 = 0;
    let mut x207: u32 = 0;
    let (x206, x207) = fiat_p224_mulx_u32(x4, 0xffffffff);
    let mut x208: u32 = 0;
    let mut x209: u32 = 0;
    let (x208, x209) = fiat_p224_mulx_u32(x4, 0xffffffff);
    let mut x210: u32 = 0;
    let mut x211: u32 = 0;
    let (x210, x211) = fiat_p224_mulx_u32(x4, 0xfffffffe);
    let mut x212: u32 = 0;
    let mut x213: fiat_p224_u1 = 0;
    let (x212, x213) = fiat_p224_addcarryx_u32(0x0, x211, x208);
    let mut x214: u32 = 0;
    let mut x215: fiat_p224_u1 = 0;
    let (x214, x215) = fiat_p224_addcarryx_u32(x213, x209, x206);
    let mut x216: u32 = 0;
    let mut x217: fiat_p224_u1 = 0;
    let (x216, x217) = fiat_p224_addcarryx_u32(0x0, x192, x4);
    let mut x218: u32 = 0;
    let mut x219: fiat_p224_u1 = 0;
    let (x218, x219) = fiat_p224_addcarryx_u32(x217, x194, (0x0 as u32));
    let mut x220: u32 = 0;
    let mut x221: fiat_p224_u1 = 0;
    let (x220, x221) = fiat_p224_addcarryx_u32(x219, x196, (0x0 as u32));
    let mut x222: u32 = 0;
    let mut x223: fiat_p224_u1 = 0;
    let (x222, x223) = fiat_p224_addcarryx_u32(x221, x198, x210);
    let mut x224: u32 = 0;
    let mut x225: fiat_p224_u1 = 0;
    let (x224, x225) = fiat_p224_addcarryx_u32(x223, x200, x212);
    let mut x226: u32 = 0;
    let mut x227: fiat_p224_u1 = 0;
    let (x226, x227) = fiat_p224_addcarryx_u32(x225, x202, x214);
    let mut x228: u32 = 0;
    let mut x229: fiat_p224_u1 = 0;
    let (x228, x229) = fiat_p224_addcarryx_u32(x227, x204, ((x215 as u32) + x207));
    let mut x230: u32 = 0;
    let mut x231: u32 = 0;
    let (x230, x231) = fiat_p224_mulx_u32(x216, 0xffffffff);
    let mut x232: u32 = 0;
    let mut x233: u32 = 0;
    let (x232, x233) = fiat_p224_mulx_u32(x230, 0xffffffff);
    let mut x234: u32 = 0;
    let mut x235: u32 = 0;
    let (x234, x235) = fiat_p224_mulx_u32(x230, 0xffffffff);
    let mut x236: u32 = 0;
    let mut x237: u32 = 0;
    let (x236, x237) = fiat_p224_mulx_u32(x230, 0xffffffff);
    let mut x238: u32 = 0;
    let mut x239: u32 = 0;
    let (x238, x239) = fiat_p224_mulx_u32(x230, 0xffffffff);
    let mut x240: u32 = 0;
    let mut x241: fiat_p224_u1 = 0;
    let (x240, x241) = fiat_p224_addcarryx_u32(0x0, x239, x236);
    let mut x242: u32 = 0;
    let mut x243: fiat_p224_u1 = 0;
    let (x242, x243) = fiat_p224_addcarryx_u32(x241, x237, x234);
    let mut x244: u32 = 0;
    let mut x245: fiat_p224_u1 = 0;
    let (x244, x245) = fiat_p224_addcarryx_u32(x243, x235, x232);
    let mut x246: u32 = 0;
    let mut x247: fiat_p224_u1 = 0;
    let (x246, x247) = fiat_p224_addcarryx_u32(0x0, x216, x230);
    let mut x248: u32 = 0;
    let mut x249: fiat_p224_u1 = 0;
    let (x248, x249) = fiat_p224_addcarryx_u32(x247, x218, (0x0 as u32));
    let mut x250: u32 = 0;
    let mut x251: fiat_p224_u1 = 0;
    let (x250, x251) = fiat_p224_addcarryx_u32(x249, x220, (0x0 as u32));
    let mut x252: u32 = 0;
    let mut x253: fiat_p224_u1 = 0;
    let (x252, x253) = fiat_p224_addcarryx_u32(x251, x222, x238);
    let mut x254: u32 = 0;
    let mut x255: fiat_p224_u1 = 0;
    let (x254, x255) = fiat_p224_addcarryx_u32(x253, x224, x240);
    let mut x256: u32 = 0;
    let mut x257: fiat_p224_u1 = 0;
    let (x256, x257) = fiat_p224_addcarryx_u32(x255, x226, x242);
    let mut x258: u32 = 0;
    let mut x259: fiat_p224_u1 = 0;
    let (x258, x259) = fiat_p224_addcarryx_u32(x257, x228, x244);
    let mut x260: u32 = 0;
    let mut x261: fiat_p224_u1 = 0;
    let (x260, x261) = fiat_p224_addcarryx_u32(
        x259,
        ((x229 as u32) + (x205 as u32)),
        ((x245 as u32) + x233),
    );
    let mut x262: u32 = 0;
    let mut x263: u32 = 0;
    let (x262, x263) = fiat_p224_mulx_u32(x5, 0xffffffff);
    let mut x264: u32 = 0;
    let mut x265: u32 = 0;
    let (x264, x265) = fiat_p224_mulx_u32(x5, 0xffffffff);
    let mut x266: u32 = 0;
    let mut x267: u32 = 0;
    let (x266, x267) = fiat_p224_mulx_u32(x5, 0xfffffffe);
    let mut x268: u32 = 0;
    let mut x269: fiat_p224_u1 = 0;
    let (x268, x269) = fiat_p224_addcarryx_u32(0x0, x267, x264);
    let mut x270: u32 = 0;
    let mut x271: fiat_p224_u1 = 0;
    let (x270, x271) = fiat_p224_addcarryx_u32(x269, x265, x262);
    let mut x272: u32 = 0;
    let mut x273: fiat_p224_u1 = 0;
    let (x272, x273) = fiat_p224_addcarryx_u32(0x0, x248, x5);
    let mut x274: u32 = 0;
    let mut x275: fiat_p224_u1 = 0;
    let (x274, x275) = fiat_p224_addcarryx_u32(x273, x250, (0x0 as u32));
    let mut x276: u32 = 0;
    let mut x277: fiat_p224_u1 = 0;
    let (x276, x277) = fiat_p224_addcarryx_u32(x275, x252, (0x0 as u32));
    let mut x278: u32 = 0;
    let mut x279: fiat_p224_u1 = 0;
    let (x278, x279) = fiat_p224_addcarryx_u32(x277, x254, x266);
    let mut x280: u32 = 0;
    let mut x281: fiat_p224_u1 = 0;
    let (x280, x281) = fiat_p224_addcarryx_u32(x279, x256, x268);
    let mut x282: u32 = 0;
    let mut x283: fiat_p224_u1 = 0;
    let (x282, x283) = fiat_p224_addcarryx_u32(x281, x258, x270);
    let mut x284: u32 = 0;
    let mut x285: fiat_p224_u1 = 0;
    let (x284, x285) = fiat_p224_addcarryx_u32(x283, x260, ((x271 as u32) + x263));
    let mut x286: u32 = 0;
    let mut x287: u32 = 0;
    let (x286, x287) = fiat_p224_mulx_u32(x272, 0xffffffff);
    let mut x288: u32 = 0;
    let mut x289: u32 = 0;
    let (x288, x289) = fiat_p224_mulx_u32(x286, 0xffffffff);
    let mut x290: u32 = 0;
    let mut x291: u32 = 0;
    let (x290, x291) = fiat_p224_mulx_u32(x286, 0xffffffff);
    let mut x292: u32 = 0;
    let mut x293: u32 = 0;
    let (x292, x293) = fiat_p224_mulx_u32(x286, 0xffffffff);
    let mut x294: u32 = 0;
    let mut x295: u32 = 0;
    let (x294, x295) = fiat_p224_mulx_u32(x286, 0xffffffff);
    let mut x296: u32 = 0;
    let mut x297: fiat_p224_u1 = 0;
    let (x296, x297) = fiat_p224_addcarryx_u32(0x0, x295, x292);
    let mut x298: u32 = 0;
    let mut x299: fiat_p224_u1 = 0;
    let (x298, x299) = fiat_p224_addcarryx_u32(x297, x293, x290);
    let mut x300: u32 = 0;
    let mut x301: fiat_p224_u1 = 0;
    let (x300, x301) = fiat_p224_addcarryx_u32(x299, x291, x288);
    let mut x302: u32 = 0;
    let mut x303: fiat_p224_u1 = 0;
    let (x302, x303) = fiat_p224_addcarryx_u32(0x0, x272, x286);
    let mut x304: u32 = 0;
    let mut x305: fiat_p224_u1 = 0;
    let (x304, x305) = fiat_p224_addcarryx_u32(x303, x274, (0x0 as u32));
    let mut x306: u32 = 0;
    let mut x307: fiat_p224_u1 = 0;
    let (x306, x307) = fiat_p224_addcarryx_u32(x305, x276, (0x0 as u32));
    let mut x308: u32 = 0;
    let mut x309: fiat_p224_u1 = 0;
    let (x308, x309) = fiat_p224_addcarryx_u32(x307, x278, x294);
    let mut x310: u32 = 0;
    let mut x311: fiat_p224_u1 = 0;
    let (x310, x311) = fiat_p224_addcarryx_u32(x309, x280, x296);
    let mut x312: u32 = 0;
    let mut x313: fiat_p224_u1 = 0;
    let (x312, x313) = fiat_p224_addcarryx_u32(x311, x282, x298);
    let mut x314: u32 = 0;
    let mut x315: fiat_p224_u1 = 0;
    let (x314, x315) = fiat_p224_addcarryx_u32(x313, x284, x300);
    let mut x316: u32 = 0;
    let mut x317: fiat_p224_u1 = 0;
    let (x316, x317) = fiat_p224_addcarryx_u32(
        x315,
        ((x285 as u32) + (x261 as u32)),
        ((x301 as u32) + x289),
    );
    let mut x318: u32 = 0;
    let mut x319: u32 = 0;
    let (x318, x319) = fiat_p224_mulx_u32(x6, 0xffffffff);
    let mut x320: u32 = 0;
    let mut x321: u32 = 0;
    let (x320, x321) = fiat_p224_mulx_u32(x6, 0xffffffff);
    let mut x322: u32 = 0;
    let mut x323: u32 = 0;
    let (x322, x323) = fiat_p224_mulx_u32(x6, 0xfffffffe);
    let mut x324: u32 = 0;
    let mut x325: fiat_p224_u1 = 0;
    let (x324, x325) = fiat_p224_addcarryx_u32(0x0, x323, x320);
    let mut x326: u32 = 0;
    let mut x327: fiat_p224_u1 = 0;
    let (x326, x327) = fiat_p224_addcarryx_u32(x325, x321, x318);
    let mut x328: u32 = 0;
    let mut x329: fiat_p224_u1 = 0;
    let (x328, x329) = fiat_p224_addcarryx_u32(0x0, x304, x6);
    let mut x330: u32 = 0;
    let mut x331: fiat_p224_u1 = 0;
    let (x330, x331) = fiat_p224_addcarryx_u32(x329, x306, (0x0 as u32));
    let mut x332: u32 = 0;
    let mut x333: fiat_p224_u1 = 0;
    let (x332, x333) = fiat_p224_addcarryx_u32(x331, x308, (0x0 as u32));
    let mut x334: u32 = 0;
    let mut x335: fiat_p224_u1 = 0;
    let (x334, x335) = fiat_p224_addcarryx_u32(x333, x310, x322);
    let mut x336: u32 = 0;
    let mut x337: fiat_p224_u1 = 0;
    let (x336, x337) = fiat_p224_addcarryx_u32(x335, x312, x324);
    let mut x338: u32 = 0;
    let mut x339: fiat_p224_u1 = 0;
    let (x338, x339) = fiat_p224_addcarryx_u32(x337, x314, x326);
    let mut x340: u32 = 0;
    let mut x341: fiat_p224_u1 = 0;
    let (x340, x341) = fiat_p224_addcarryx_u32(x339, x316, ((x327 as u32) + x319));
    let mut x342: u32 = 0;
    let mut x343: u32 = 0;
    let (x342, x343) = fiat_p224_mulx_u32(x328, 0xffffffff);
    let mut x344: u32 = 0;
    let mut x345: u32 = 0;
    let (x344, x345) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x346: u32 = 0;
    let mut x347: u32 = 0;
    let (x346, x347) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x348: u32 = 0;
    let mut x349: u32 = 0;
    let (x348, x349) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x350: u32 = 0;
    let mut x351: u32 = 0;
    let (x350, x351) = fiat_p224_mulx_u32(x342, 0xffffffff);
    let mut x352: u32 = 0;
    let mut x353: fiat_p224_u1 = 0;
    let (x352, x353) = fiat_p224_addcarryx_u32(0x0, x351, x348);
    let mut x354: u32 = 0;
    let mut x355: fiat_p224_u1 = 0;
    let (x354, x355) = fiat_p224_addcarryx_u32(x353, x349, x346);
    let mut x356: u32 = 0;
    let mut x357: fiat_p224_u1 = 0;
    let (x356, x357) = fiat_p224_addcarryx_u32(x355, x347, x344);
    let mut x358: u32 = 0;
    let mut x359: fiat_p224_u1 = 0;
    let (x358, x359) = fiat_p224_addcarryx_u32(0x0, x328, x342);
    let mut x360: u32 = 0;
    let mut x361: fiat_p224_u1 = 0;
    let (x360, x361) = fiat_p224_addcarryx_u32(x359, x330, (0x0 as u32));
    let mut x362: u32 = 0;
    let mut x363: fiat_p224_u1 = 0;
    let (x362, x363) = fiat_p224_addcarryx_u32(x361, x332, (0x0 as u32));
    let mut x364: u32 = 0;
    let mut x365: fiat_p224_u1 = 0;
    let (x364, x365) = fiat_p224_addcarryx_u32(x363, x334, x350);
    let mut x366: u32 = 0;
    let mut x367: fiat_p224_u1 = 0;
    let (x366, x367) = fiat_p224_addcarryx_u32(x365, x336, x352);
    let mut x368: u32 = 0;
    let mut x369: fiat_p224_u1 = 0;
    let (x368, x369) = fiat_p224_addcarryx_u32(x367, x338, x354);
    let mut x370: u32 = 0;
    let mut x371: fiat_p224_u1 = 0;
    let (x370, x371) = fiat_p224_addcarryx_u32(x369, x340, x356);
    let mut x372: u32 = 0;
    let mut x373: fiat_p224_u1 = 0;
    let (x372, x373) = fiat_p224_addcarryx_u32(
        x371,
        ((x341 as u32) + (x317 as u32)),
        ((x357 as u32) + x345),
    );
    let mut x374: u32 = 0;
    let mut x375: fiat_p224_u1 = 0;
    let (x374, x375) = fiat_p224_subborrowx_u32(0x0, x360, (0x1 as u32));
    let mut x376: u32 = 0;
    let mut x377: fiat_p224_u1 = 0;
    let (x376, x377) = fiat_p224_subborrowx_u32(x375, x362, (0x0 as u32));
    let mut x378: u32 = 0;
    let mut x379: fiat_p224_u1 = 0;
    let (x378, x379) = fiat_p224_subborrowx_u32(x377, x364, (0x0 as u32));
    let mut x380: u32 = 0;
    let mut x381: fiat_p224_u1 = 0;
    let (x380, x381) = fiat_p224_subborrowx_u32(x379, x366, 0xffffffff);
    let mut x382: u32 = 0;
    let mut x383: fiat_p224_u1 = 0;
    let (x382, x383) = fiat_p224_subborrowx_u32(x381, x368, 0xffffffff);
    let mut x384: u32 = 0;
    let mut x385: fiat_p224_u1 = 0;
    let (x384, x385) = fiat_p224_subborrowx_u32(x383, x370, 0xffffffff);
    let mut x386: u32 = 0;
    let mut x387: fiat_p224_u1 = 0;
    let (x386, x387) = fiat_p224_subborrowx_u32(x385, x372, 0xffffffff);
    let mut x388: u32 = 0;
    let mut x389: fiat_p224_u1 = 0;
    let (x388, x389) = fiat_p224_subborrowx_u32(x387, (x373 as u32), (0x0 as u32));
    let mut x390: u32 = 0;
    let (x390) = fiat_p224_cmovznz_u32(x389, x374, x360);
    let mut x391: u32 = 0;
    let (x391) = fiat_p224_cmovznz_u32(x389, x376, x362);
    let mut x392: u32 = 0;
    let (x392) = fiat_p224_cmovznz_u32(x389, x378, x364);
    let mut x393: u32 = 0;
    let (x393) = fiat_p224_cmovznz_u32(x389, x380, x366);
    let mut x394: u32 = 0;
    let (x394) = fiat_p224_cmovznz_u32(x389, x382, x368);
    let mut x395: u32 = 0;
    let (x395) = fiat_p224_cmovznz_u32(x389, x384, x370);
    let mut x396: u32 = 0;
    let (x396) = fiat_p224_cmovznz_u32(x389, x386, x372);
    out1[0] = x390;
    out1[1] = x391;
    out1[2] = x392;
    out1[3] = x393;
    out1[4] = x394;
    out1[5] = x395;
    out1[6] = x396;
    out1
}
#[doc = " The function fiat_p224_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[inline]
pub const fn fiat_p224_nonzero(arg1: &[u32; 7]) -> u32 {
    let mut out1: u32 = 0;
    let x1: u32 = ((arg1[0])
        | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | (arg1[6])))))));
    out1 = x1;
    out1
}
#[doc = " The function fiat_p224_selectznz is a multi-limb conditional select."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p224_selectznz(arg1: fiat_p224_u1, arg2: &[u32; 7], arg3: &[u32; 7]) -> [u32; 7] {
    let mut out1: [u32; 7] = [0; 7];
    let mut x1: u32 = 0;
    let (x1) = fiat_p224_cmovznz_u32(arg1, (arg2[0]), (arg3[0]));
    let mut x2: u32 = 0;
    let (x2) = fiat_p224_cmovznz_u32(arg1, (arg2[1]), (arg3[1]));
    let mut x3: u32 = 0;
    let (x3) = fiat_p224_cmovznz_u32(arg1, (arg2[2]), (arg3[2]));
    let mut x4: u32 = 0;
    let (x4) = fiat_p224_cmovznz_u32(arg1, (arg2[3]), (arg3[3]));
    let mut x5: u32 = 0;
    let (x5) = fiat_p224_cmovznz_u32(arg1, (arg2[4]), (arg3[4]));
    let mut x6: u32 = 0;
    let (x6) = fiat_p224_cmovznz_u32(arg1, (arg2[5]), (arg3[5]));
    let mut x7: u32 = 0;
    let (x7) = fiat_p224_cmovznz_u32(arg1, (arg2[6]), (arg3[6]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1
}
#[doc = " The function fiat_p224_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..27]"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[inline]
pub const fn fiat_p224_to_bytes(arg1: &[u32; 7]) -> [u8; 28] {
    let mut out1: [u8; 28] = [0; 28];
    let x1: u32 = (arg1[6]);
    let x2: u32 = (arg1[5]);
    let x3: u32 = (arg1[4]);
    let x4: u32 = (arg1[3]);
    let x5: u32 = (arg1[2]);
    let x6: u32 = (arg1[1]);
    let x7: u32 = (arg1[0]);
    let x8: u8 = ((x7 & (0xff as u32)) as u8);
    let x9: u32 = (x7 >> 8);
    let x10: u8 = ((x9 & (0xff as u32)) as u8);
    let x11: u32 = (x9 >> 8);
    let x12: u8 = ((x11 & (0xff as u32)) as u8);
    let x13: u8 = ((x11 >> 8) as u8);
    let x14: u8 = ((x6 & (0xff as u32)) as u8);
    let x15: u32 = (x6 >> 8);
    let x16: u8 = ((x15 & (0xff as u32)) as u8);
    let x17: u32 = (x15 >> 8);
    let x18: u8 = ((x17 & (0xff as u32)) as u8);
    let x19: u8 = ((x17 >> 8) as u8);
    let x20: u8 = ((x5 & (0xff as u32)) as u8);
    let x21: u32 = (x5 >> 8);
    let x22: u8 = ((x21 & (0xff as u32)) as u8);
    let x23: u32 = (x21 >> 8);
    let x24: u8 = ((x23 & (0xff as u32)) as u8);
    let x25: u8 = ((x23 >> 8) as u8);
    let x26: u8 = ((x4 & (0xff as u32)) as u8);
    let x27: u32 = (x4 >> 8);
    let x28: u8 = ((x27 & (0xff as u32)) as u8);
    let x29: u32 = (x27 >> 8);
    let x30: u8 = ((x29 & (0xff as u32)) as u8);
    let x31: u8 = ((x29 >> 8) as u8);
    let x32: u8 = ((x3 & (0xff as u32)) as u8);
    let x33: u32 = (x3 >> 8);
    let x34: u8 = ((x33 & (0xff as u32)) as u8);
    let x35: u32 = (x33 >> 8);
    let x36: u8 = ((x35 & (0xff as u32)) as u8);
    let x37: u8 = ((x35 >> 8) as u8);
    let x38: u8 = ((x2 & (0xff as u32)) as u8);
    let x39: u32 = (x2 >> 8);
    let x40: u8 = ((x39 & (0xff as u32)) as u8);
    let x41: u32 = (x39 >> 8);
    let x42: u8 = ((x41 & (0xff as u32)) as u8);
    let x43: u8 = ((x41 >> 8) as u8);
    let x44: u8 = ((x1 & (0xff as u32)) as u8);
    let x45: u32 = (x1 >> 8);
    let x46: u8 = ((x45 & (0xff as u32)) as u8);
    let x47: u32 = (x45 >> 8);
    let x48: u8 = ((x47 & (0xff as u32)) as u8);
    let x49: u8 = ((x47 >> 8) as u8);
    out1[0] = x8;
    out1[1] = x10;
    out1[2] = x12;
    out1[3] = x13;
    out1[4] = x14;
    out1[5] = x16;
    out1[6] = x18;
    out1[7] = x19;
    out1[8] = x20;
    out1[9] = x22;
    out1[10] = x24;
    out1[11] = x25;
    out1[12] = x26;
    out1[13] = x28;
    out1[14] = x30;
    out1[15] = x31;
    out1[16] = x32;
    out1[17] = x34;
    out1[18] = x36;
    out1[19] = x37;
    out1[20] = x38;
    out1[21] = x40;
    out1[22] = x42;
    out1[23] = x43;
    out1[24] = x44;
    out1[25] = x46;
    out1[26] = x48;
    out1[27] = x49;
    out1
}
#[doc = " The function fiat_p224_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ bytes_eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = bytes_eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p224_from_bytes(arg1: &[u8; 28]) -> [u32; 7] {
    let mut out1: [u32; 7] = [0; 7];
    let x1: u32 = (((arg1[27]) as u32) << 24);
    let x2: u32 = (((arg1[26]) as u32) << 16);
    let x3: u32 = (((arg1[25]) as u32) << 8);
    let x4: u8 = (arg1[24]);
    let x5: u32 = (((arg1[23]) as u32) << 24);
    let x6: u32 = (((arg1[22]) as u32) << 16);
    let x7: u32 = (((arg1[21]) as u32) << 8);
    let x8: u8 = (arg1[20]);
    let x9: u32 = (((arg1[19]) as u32) << 24);
    let x10: u32 = (((arg1[18]) as u32) << 16);
    let x11: u32 = (((arg1[17]) as u32) << 8);
    let x12: u8 = (arg1[16]);
    let x13: u32 = (((arg1[15]) as u32) << 24);
    let x14: u32 = (((arg1[14]) as u32) << 16);
    let x15: u32 = (((arg1[13]) as u32) << 8);
    let x16: u8 = (arg1[12]);
    let x17: u32 = (((arg1[11]) as u32) << 24);
    let x18: u32 = (((arg1[10]) as u32) << 16);
    let x19: u32 = (((arg1[9]) as u32) << 8);
    let x20: u8 = (arg1[8]);
    let x21: u32 = (((arg1[7]) as u32) << 24);
    let x22: u32 = (((arg1[6]) as u32) << 16);
    let x23: u32 = (((arg1[5]) as u32) << 8);
    let x24: u8 = (arg1[4]);
    let x25: u32 = (((arg1[3]) as u32) << 24);
    let x26: u32 = (((arg1[2]) as u32) << 16);
    let x27: u32 = (((arg1[1]) as u32) << 8);
    let x28: u8 = (arg1[0]);
    let x29: u32 = (x27 + (x28 as u32));
    let x30: u32 = (x26 + x29);
    let x31: u32 = (x25 + x30);
    let x32: u32 = (x23 + (x24 as u32));
    let x33: u32 = (x22 + x32);
    let x34: u32 = (x21 + x33);
    let x35: u32 = (x19 + (x20 as u32));
    let x36: u32 = (x18 + x35);
    let x37: u32 = (x17 + x36);
    let x38: u32 = (x15 + (x16 as u32));
    let x39: u32 = (x14 + x38);
    let x40: u32 = (x13 + x39);
    let x41: u32 = (x11 + (x12 as u32));
    let x42: u32 = (x10 + x41);
    let x43: u32 = (x9 + x42);
    let x44: u32 = (x7 + (x8 as u32));
    let x45: u32 = (x6 + x44);
    let x46: u32 = (x5 + x45);
    let x47: u32 = (x3 + (x4 as u32));
    let x48: u32 = (x2 + x47);
    let x49: u32 = (x1 + x48);
    out1[0] = x31;
    out1[1] = x34;
    out1[2] = x37;
    out1[3] = x40;
    out1[4] = x43;
    out1[5] = x46;
    out1[6] = x49;
    out1
}
#[doc = " The function fiat_p224_set_one returns the field element one in the Montgomery domain."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = 1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p224_set_one() -> fiat_p224_montgomery_domain_field_element {
    let mut out1: fiat_p224_montgomery_domain_field_element = [0; 7];
    out1[0] = 0xffffffff;
    out1[1] = 0xffffffff;
    out1[2] = 0xffffffff;
    out1[3] = (0x0 as u32);
    out1[4] = (0x0 as u32);
    out1[5] = (0x0 as u32);
    out1[6] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p224_msat returns the saturated representation of the prime modulus."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   twos_complement_eval out1 = m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p224_msat() -> [u32; 8] {
    let mut out1: [u32; 8] = [0; 8];
    out1[0] = (0x1 as u32);
    out1[1] = (0x0 as u32);
    out1[2] = (0x0 as u32);
    out1[3] = 0xffffffff;
    out1[4] = 0xffffffff;
    out1[5] = 0xffffffff;
    out1[6] = 0xffffffff;
    out1[7] = (0x0 as u32);
    out1
}
#[doc = " The function fiat_p224_divstep computes a divstep."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg4 < m"]
#[doc = "   0 ≤ eval arg5 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)"]
#[doc = "   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)"]
#[doc = "   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)"]
#[doc = "   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)"]
#[doc = "   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out2 < m"]
#[doc = "   0 ≤ eval out3 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffff]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffff]"]
#[doc = "   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[doc = "   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p224_divstep(
    arg1: u32,
    arg2: &[u32; 8],
    arg3: &[u32; 8],
    arg4: &[u32; 7],
    arg5: &[u32; 7],
) -> (u32, [u32; 8], [u32; 8], [u32; 7], [u32; 7]) {
    let mut out1: u32 = 0;
    let mut out2: [u32; 8] = [0; 8];
    let mut out3: [u32; 8] = [0; 8];
    let mut out4: [u32; 7] = [0; 7];
    let mut out5: [u32; 7] = [0; 7];
    let mut x1: u32 = 0;
    let mut x2: fiat_p224_u1 = 0;
    let (x1, x2) = fiat_p224_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let x3: fiat_p224_u1 =
        (((x1 >> 31) as fiat_p224_u1) & (((arg3[0]) & (0x1 as u32)) as fiat_p224_u1));
    let mut x4: u32 = 0;
    let mut x5: fiat_p224_u1 = 0;
    let (x4, x5) = fiat_p224_addcarryx_u32(0x0, (!arg1), (0x1 as u32));
    let mut x6: u32 = 0;
    let (x6) = fiat_p224_cmovznz_u32(x3, arg1, x4);
    let mut x7: u32 = 0;
    let (x7) = fiat_p224_cmovznz_u32(x3, (arg2[0]), (arg3[0]));
    let mut x8: u32 = 0;
    let (x8) = fiat_p224_cmovznz_u32(x3, (arg2[1]), (arg3[1]));
    let mut x9: u32 = 0;
    let (x9) = fiat_p224_cmovznz_u32(x3, (arg2[2]), (arg3[2]));
    let mut x10: u32 = 0;
    let (x10) = fiat_p224_cmovznz_u32(x3, (arg2[3]), (arg3[3]));
    let mut x11: u32 = 0;
    let (x11) = fiat_p224_cmovznz_u32(x3, (arg2[4]), (arg3[4]));
    let mut x12: u32 = 0;
    let (x12) = fiat_p224_cmovznz_u32(x3, (arg2[5]), (arg3[5]));
    let mut x13: u32 = 0;
    let (x13) = fiat_p224_cmovznz_u32(x3, (arg2[6]), (arg3[6]));
    let mut x14: u32 = 0;
    let (x14) = fiat_p224_cmovznz_u32(x3, (arg2[7]), (arg3[7]));
    let mut x15: u32 = 0;
    let mut x16: fiat_p224_u1 = 0;
    let (x15, x16) = fiat_p224_addcarryx_u32(0x0, (0x1 as u32), (!(arg2[0])));
    let mut x17: u32 = 0;
    let mut x18: fiat_p224_u1 = 0;
    let (x17, x18) = fiat_p224_addcarryx_u32(x16, (0x0 as u32), (!(arg2[1])));
    let mut x19: u32 = 0;
    let mut x20: fiat_p224_u1 = 0;
    let (x19, x20) = fiat_p224_addcarryx_u32(x18, (0x0 as u32), (!(arg2[2])));
    let mut x21: u32 = 0;
    let mut x22: fiat_p224_u1 = 0;
    let (x21, x22) = fiat_p224_addcarryx_u32(x20, (0x0 as u32), (!(arg2[3])));
    let mut x23: u32 = 0;
    let mut x24: fiat_p224_u1 = 0;
    let (x23, x24) = fiat_p224_addcarryx_u32(x22, (0x0 as u32), (!(arg2[4])));
    let mut x25: u32 = 0;
    let mut x26: fiat_p224_u1 = 0;
    let (x25, x26) = fiat_p224_addcarryx_u32(x24, (0x0 as u32), (!(arg2[5])));
    let mut x27: u32 = 0;
    let mut x28: fiat_p224_u1 = 0;
    let (x27, x28) = fiat_p224_addcarryx_u32(x26, (0x0 as u32), (!(arg2[6])));
    let mut x29: u32 = 0;
    let mut x30: fiat_p224_u1 = 0;
    let (x29, x30) = fiat_p224_addcarryx_u32(x28, (0x0 as u32), (!(arg2[7])));
    let mut x31: u32 = 0;
    let (x31) = fiat_p224_cmovznz_u32(x3, (arg3[0]), x15);
    let mut x32: u32 = 0;
    let (x32) = fiat_p224_cmovznz_u32(x3, (arg3[1]), x17);
    let mut x33: u32 = 0;
    let (x33) = fiat_p224_cmovznz_u32(x3, (arg3[2]), x19);
    let mut x34: u32 = 0;
    let (x34) = fiat_p224_cmovznz_u32(x3, (arg3[3]), x21);
    let mut x35: u32 = 0;
    let (x35) = fiat_p224_cmovznz_u32(x3, (arg3[4]), x23);
    let mut x36: u32 = 0;
    let (x36) = fiat_p224_cmovznz_u32(x3, (arg3[5]), x25);
    let mut x37: u32 = 0;
    let (x37) = fiat_p224_cmovznz_u32(x3, (arg3[6]), x27);
    let mut x38: u32 = 0;
    let (x38) = fiat_p224_cmovznz_u32(x3, (arg3[7]), x29);
    let mut x39: u32 = 0;
    let (x39) = fiat_p224_cmovznz_u32(x3, (arg4[0]), (arg5[0]));
    let mut x40: u32 = 0;
    let (x40) = fiat_p224_cmovznz_u32(x3, (arg4[1]), (arg5[1]));
    let mut x41: u32 = 0;
    let (x41) = fiat_p224_cmovznz_u32(x3, (arg4[2]), (arg5[2]));
    let mut x42: u32 = 0;
    let (x42) = fiat_p224_cmovznz_u32(x3, (arg4[3]), (arg5[3]));
    let mut x43: u32 = 0;
    let (x43) = fiat_p224_cmovznz_u32(x3, (arg4[4]), (arg5[4]));
    let mut x44: u32 = 0;
    let (x44) = fiat_p224_cmovznz_u32(x3, (arg4[5]), (arg5[5]));
    let mut x45: u32 = 0;
    let (x45) = fiat_p224_cmovznz_u32(x3, (arg4[6]), (arg5[6]));
    let mut x46: u32 = 0;
    let mut x47: fiat_p224_u1 = 0;
    let (x46, x47) = fiat_p224_addcarryx_u32(0x0, x39, x39);
    let mut x48: u32 = 0;
    let mut x49: fiat_p224_u1 = 0;
    let (x48, x49) = fiat_p224_addcarryx_u32(x47, x40, x40);
    let mut x50: u32 = 0;
    let mut x51: fiat_p224_u1 = 0;
    let (x50, x51) = fiat_p224_addcarryx_u32(x49, x41, x41);
    let mut x52: u32 = 0;
    let mut x53: fiat_p224_u1 = 0;
    let (x52, x53) = fiat_p224_addcarryx_u32(x51, x42, x42);
    let mut x54: u32 = 0;
    let mut x55: fiat_p224_u1 = 0;
    let (x54, x55) = fiat_p224_addcarryx_u32(x53, x43, x43);
    let mut x56: u32 = 0;
    let mut x57: fiat_p224_u1 = 0;
    let (x56, x57) = fiat_p224_addcarryx_u32(x55, x44, x44);
    let mut x58: u32 = 0;
    let mut x59: fiat_p224_u1 = 0;
    let (x58, x59) = fiat_p224_addcarryx_u32(x57, x45, x45);
    let mut x60: u32 = 0;
    let mut x61: fiat_p224_u1 = 0;
    let (x60, x61) = fiat_p224_subborrowx_u32(0x0, x46, (0x1 as u32));
    let mut x62: u32 = 0;
    let mut x63: fiat_p224_u1 = 0;
    let (x62, x63) = fiat_p224_subborrowx_u32(x61, x48, (0x0 as u32));
    let mut x64: u32 = 0;
    let mut x65: fiat_p224_u1 = 0;
    let (x64, x65) = fiat_p224_subborrowx_u32(x63, x50, (0x0 as u32));
    let mut x66: u32 = 0;
    let mut x67: fiat_p224_u1 = 0;
    let (x66, x67) = fiat_p224_subborrowx_u32(x65, x52, 0xffffffff);
    let mut x68: u32 = 0;
    let mut x69: fiat_p224_u1 = 0;
    let (x68, x69) = fiat_p224_subborrowx_u32(x67, x54, 0xffffffff);
    let mut x70: u32 = 0;
    let mut x71: fiat_p224_u1 = 0;
    let (x70, x71) = fiat_p224_subborrowx_u32(x69, x56, 0xffffffff);
    let mut x72: u32 = 0;
    let mut x73: fiat_p224_u1 = 0;
    let (x72, x73) = fiat_p224_subborrowx_u32(x71, x58, 0xffffffff);
    let mut x74: u32 = 0;
    let mut x75: fiat_p224_u1 = 0;
    let (x74, x75) = fiat_p224_subborrowx_u32(x73, (x59 as u32), (0x0 as u32));
    let x76: u32 = (arg4[6]);
    let x77: u32 = (arg4[5]);
    let x78: u32 = (arg4[4]);
    let x79: u32 = (arg4[3]);
    let x80: u32 = (arg4[2]);
    let x81: u32 = (arg4[1]);
    let x82: u32 = (arg4[0]);
    let mut x83: u32 = 0;
    let mut x84: fiat_p224_u1 = 0;
    let (x83, x84) = fiat_p224_subborrowx_u32(0x0, (0x0 as u32), x82);
    let mut x85: u32 = 0;
    let mut x86: fiat_p224_u1 = 0;
    let (x85, x86) = fiat_p224_subborrowx_u32(x84, (0x0 as u32), x81);
    let mut x87: u32 = 0;
    let mut x88: fiat_p224_u1 = 0;
    let (x87, x88) = fiat_p224_subborrowx_u32(x86, (0x0 as u32), x80);
    let mut x89: u32 = 0;
    let mut x90: fiat_p224_u1 = 0;
    let (x89, x90) = fiat_p224_subborrowx_u32(x88, (0x0 as u32), x79);
    let mut x91: u32 = 0;
    let mut x92: fiat_p224_u1 = 0;
    let (x91, x92) = fiat_p224_subborrowx_u32(x90, (0x0 as u32), x78);
    let mut x93: u32 = 0;
    let mut x94: fiat_p224_u1 = 0;
    let (x93, x94) = fiat_p224_subborrowx_u32(x92, (0x0 as u32), x77);
    let mut x95: u32 = 0;
    let mut x96: fiat_p224_u1 = 0;
    let (x95, x96) = fiat_p224_subborrowx_u32(x94, (0x0 as u32), x76);
    let mut x97: u32 = 0;
    let (x97) = fiat_p224_cmovznz_u32(x96, (0x0 as u32), 0xffffffff);
    let mut x98: u32 = 0;
    let mut x99: fiat_p224_u1 = 0;
    let (x98, x99) =
        fiat_p224_addcarryx_u32(0x0, x83, (((x97 & (0x1 as u32)) as fiat_p224_u1) as u32));
    let mut x100: u32 = 0;
    let mut x101: fiat_p224_u1 = 0;
    let (x100, x101) = fiat_p224_addcarryx_u32(x99, x85, (0x0 as u32));
    let mut x102: u32 = 0;
    let mut x103: fiat_p224_u1 = 0;
    let (x102, x103) = fiat_p224_addcarryx_u32(x101, x87, (0x0 as u32));
    let mut x104: u32 = 0;
    let mut x105: fiat_p224_u1 = 0;
    let (x104, x105) = fiat_p224_addcarryx_u32(x103, x89, x97);
    let mut x106: u32 = 0;
    let mut x107: fiat_p224_u1 = 0;
    let (x106, x107) = fiat_p224_addcarryx_u32(x105, x91, x97);
    let mut x108: u32 = 0;
    let mut x109: fiat_p224_u1 = 0;
    let (x108, x109) = fiat_p224_addcarryx_u32(x107, x93, x97);
    let mut x110: u32 = 0;
    let mut x111: fiat_p224_u1 = 0;
    let (x110, x111) = fiat_p224_addcarryx_u32(x109, x95, x97);
    let mut x112: u32 = 0;
    let (x112) = fiat_p224_cmovznz_u32(x3, (arg5[0]), x98);
    let mut x113: u32 = 0;
    let (x113) = fiat_p224_cmovznz_u32(x3, (arg5[1]), x100);
    let mut x114: u32 = 0;
    let (x114) = fiat_p224_cmovznz_u32(x3, (arg5[2]), x102);
    let mut x115: u32 = 0;
    let (x115) = fiat_p224_cmovznz_u32(x3, (arg5[3]), x104);
    let mut x116: u32 = 0;
    let (x116) = fiat_p224_cmovznz_u32(x3, (arg5[4]), x106);
    let mut x117: u32 = 0;
    let (x117) = fiat_p224_cmovznz_u32(x3, (arg5[5]), x108);
    let mut x118: u32 = 0;
    let (x118) = fiat_p224_cmovznz_u32(x3, (arg5[6]), x110);
    let x119: fiat_p224_u1 = ((x31 & (0x1 as u32)) as fiat_p224_u1);
    let mut x120: u32 = 0;
    let (x120) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x7);
    let mut x121: u32 = 0;
    let (x121) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x8);
    let mut x122: u32 = 0;
    let (x122) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x9);
    let mut x123: u32 = 0;
    let (x123) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x10);
    let mut x124: u32 = 0;
    let (x124) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x11);
    let mut x125: u32 = 0;
    let (x125) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x12);
    let mut x126: u32 = 0;
    let (x126) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x13);
    let mut x127: u32 = 0;
    let (x127) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x14);
    let mut x128: u32 = 0;
    let mut x129: fiat_p224_u1 = 0;
    let (x128, x129) = fiat_p224_addcarryx_u32(0x0, x31, x120);
    let mut x130: u32 = 0;
    let mut x131: fiat_p224_u1 = 0;
    let (x130, x131) = fiat_p224_addcarryx_u32(x129, x32, x121);
    let mut x132: u32 = 0;
    let mut x133: fiat_p224_u1 = 0;
    let (x132, x133) = fiat_p224_addcarryx_u32(x131, x33, x122);
    let mut x134: u32 = 0;
    let mut x135: fiat_p224_u1 = 0;
    let (x134, x135) = fiat_p224_addcarryx_u32(x133, x34, x123);
    let mut x136: u32 = 0;
    let mut x137: fiat_p224_u1 = 0;
    let (x136, x137) = fiat_p224_addcarryx_u32(x135, x35, x124);
    let mut x138: u32 = 0;
    let mut x139: fiat_p224_u1 = 0;
    let (x138, x139) = fiat_p224_addcarryx_u32(x137, x36, x125);
    let mut x140: u32 = 0;
    let mut x141: fiat_p224_u1 = 0;
    let (x140, x141) = fiat_p224_addcarryx_u32(x139, x37, x126);
    let mut x142: u32 = 0;
    let mut x143: fiat_p224_u1 = 0;
    let (x142, x143) = fiat_p224_addcarryx_u32(x141, x38, x127);
    let mut x144: u32 = 0;
    let (x144) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x39);
    let mut x145: u32 = 0;
    let (x145) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x40);
    let mut x146: u32 = 0;
    let (x146) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x41);
    let mut x147: u32 = 0;
    let (x147) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x42);
    let mut x148: u32 = 0;
    let (x148) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x43);
    let mut x149: u32 = 0;
    let (x149) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x44);
    let mut x150: u32 = 0;
    let (x150) = fiat_p224_cmovznz_u32(x119, (0x0 as u32), x45);
    let mut x151: u32 = 0;
    let mut x152: fiat_p224_u1 = 0;
    let (x151, x152) = fiat_p224_addcarryx_u32(0x0, x112, x144);
    let mut x153: u32 = 0;
    let mut x154: fiat_p224_u1 = 0;
    let (x153, x154) = fiat_p224_addcarryx_u32(x152, x113, x145);
    let mut x155: u32 = 0;
    let mut x156: fiat_p224_u1 = 0;
    let (x155, x156) = fiat_p224_addcarryx_u32(x154, x114, x146);
    let mut x157: u32 = 0;
    let mut x158: fiat_p224_u1 = 0;
    let (x157, x158) = fiat_p224_addcarryx_u32(x156, x115, x147);
    let mut x159: u32 = 0;
    let mut x160: fiat_p224_u1 = 0;
    let (x159, x160) = fiat_p224_addcarryx_u32(x158, x116, x148);
    let mut x161: u32 = 0;
    let mut x162: fiat_p224_u1 = 0;
    let (x161, x162) = fiat_p224_addcarryx_u32(x160, x117, x149);
    let mut x163: u32 = 0;
    let mut x164: fiat_p224_u1 = 0;
    let (x163, x164) = fiat_p224_addcarryx_u32(x162, x118, x150);
    let mut x165: u32 = 0;
    let mut x166: fiat_p224_u1 = 0;
    let (x165, x166) = fiat_p224_subborrowx_u32(0x0, x151, (0x1 as u32));
    let mut x167: u32 = 0;
    let mut x168: fiat_p224_u1 = 0;
    let (x167, x168) = fiat_p224_subborrowx_u32(x166, x153, (0x0 as u32));
    let mut x169: u32 = 0;
    let mut x170: fiat_p224_u1 = 0;
    let (x169, x170) = fiat_p224_subborrowx_u32(x168, x155, (0x0 as u32));
    let mut x171: u32 = 0;
    let mut x172: fiat_p224_u1 = 0;
    let (x171, x172) = fiat_p224_subborrowx_u32(x170, x157, 0xffffffff);
    let mut x173: u32 = 0;
    let mut x174: fiat_p224_u1 = 0;
    let (x173, x174) = fiat_p224_subborrowx_u32(x172, x159, 0xffffffff);
    let mut x175: u32 = 0;
    let mut x176: fiat_p224_u1 = 0;
    let (x175, x176) = fiat_p224_subborrowx_u32(x174, x161, 0xffffffff);
    let mut x177: u32 = 0;
    let mut x178: fiat_p224_u1 = 0;
    let (x177, x178) = fiat_p224_subborrowx_u32(x176, x163, 0xffffffff);
    let mut x179: u32 = 0;
    let mut x180: fiat_p224_u1 = 0;
    let (x179, x180) = fiat_p224_subborrowx_u32(x178, (x164 as u32), (0x0 as u32));
    let mut x181: u32 = 0;
    let mut x182: fiat_p224_u1 = 0;
    let (x181, x182) = fiat_p224_addcarryx_u32(0x0, x6, (0x1 as u32));
    let x183: u32 = ((x128 >> 1) | ((x130 << 31) & 0xffffffff));
    let x184: u32 = ((x130 >> 1) | ((x132 << 31) & 0xffffffff));
    let x185: u32 = ((x132 >> 1) | ((x134 << 31) & 0xffffffff));
    let x186: u32 = ((x134 >> 1) | ((x136 << 31) & 0xffffffff));
    let x187: u32 = ((x136 >> 1) | ((x138 << 31) & 0xffffffff));
    let x188: u32 = ((x138 >> 1) | ((x140 << 31) & 0xffffffff));
    let x189: u32 = ((x140 >> 1) | ((x142 << 31) & 0xffffffff));
    let x190: u32 = ((x142 & 0x80000000) | (x142 >> 1));
    let mut x191: u32 = 0;
    let (x191) = fiat_p224_cmovznz_u32(x75, x60, x46);
    let mut x192: u32 = 0;
    let (x192) = fiat_p224_cmovznz_u32(x75, x62, x48);
    let mut x193: u32 = 0;
    let (x193) = fiat_p224_cmovznz_u32(x75, x64, x50);
    let mut x194: u32 = 0;
    let (x194) = fiat_p224_cmovznz_u32(x75, x66, x52);
    let mut x195: u32 = 0;
    let (x195) = fiat_p224_cmovznz_u32(x75, x68, x54);
    let mut x196: u32 = 0;
    let (x196) = fiat_p224_cmovznz_u32(x75, x70, x56);
    let mut x197: u32 = 0;
    let (x197) = fiat_p224_cmovznz_u32(x75, x72, x58);
    let mut x198: u32 = 0;
    let (x198) = fiat_p224_cmovznz_u32(x180, x165, x151);
    let mut x199: u32 = 0;
    let (x199) = fiat_p224_cmovznz_u32(x180, x167, x153);
    let mut x200: u32 = 0;
    let (x200) = fiat_p224_cmovznz_u32(x180, x169, x155);
    let mut x201: u32 = 0;
    let (x201) = fiat_p224_cmovznz_u32(x180, x171, x157);
    let mut x202: u32 = 0;
    let (x202) = fiat_p224_cmovznz_u32(x180, x173, x159);
    let mut x203: u32 = 0;
    let (x203) = fiat_p224_cmovznz_u32(x180, x175, x161);
    let mut x204: u32 = 0;
    let (x204) = fiat_p224_cmovznz_u32(x180, x177, x163);
    out1 = x181;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out2[5] = x12;
    out2[6] = x13;
    out2[7] = x14;
    out3[0] = x183;
    out3[1] = x184;
    out3[2] = x185;
    out3[3] = x186;
    out3[4] = x187;
    out3[5] = x188;
    out3[6] = x189;
    out3[7] = x190;
    out4[0] = x191;
    out4[1] = x192;
    out4[2] = x193;
    out4[3] = x194;
    out4[4] = x195;
    out4[5] = x196;
    out4[6] = x197;
    out5[0] = x198;
    out5[1] = x199;
    out5[2] = x200;
    out5[3] = x201;
    out5[4] = x202;
    out5[5] = x203;
    out5[6] = x204;
    (out1, out2, out3, out4, out5)
}
#[doc = " The function fiat_p224_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form)."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]"]
#[inline]
pub const fn fiat_p224_divstep_precomp() -> [u32; 7] {
    let mut out1: [u32; 7] = [0; 7];
    out1[0] = 0x800000;
    out1[1] = 0x800000;
    out1[2] = 0xfe000000;
    out1[3] = 0xffffff;
    out1[4] = (0x0 as u32);
    out1[5] = 0xff800000;
    out1[6] = 0x17fffff;
    out1
}
