// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.

/// List of globals available in Deno environment.
///
/// Boolean tells if global can be overwritten
///
/// Adapted from https://www.npmjs.com/package/globals
pub static GLOBALS: &[(&str, bool)] = &[
  ("AbortController", false),
  ("AbortSignal", false),
  ("addEventListener", false),
  ("AggregateError", false),
  ("alert", false),
  ("Array", false),
  ("ArrayBuffer", false),
  ("atob", false),
  ("Atomics", false),
  ("BigInt", false),
  ("BigInt64Array", false),
  ("BigUint64Array", false),
  ("Blob", false),
  ("Boolean", false),
  ("BroadcastChannel", false),
  ("btoa", false),
  ("ByteLengthQueuingStrategy", false),
  ("Cache", false),
  ("caches", false),
  ("CacheStorage", false),
  ("clearInterval", false),
  ("clearTimeout", false),
  ("close", false),
  ("closed", false),
  ("CloseEvent", false),
  ("CompressionStream", false),
  ("confirm", false),
  ("console", false),
  ("constructor", false),
  ("CountQueuingStrategy", false),
  ("createImageBitmap", false),
  ("crypto", false),
  ("Crypto", false),
  ("CryptoKey", false),
  ("CustomEvent", false),
  ("DataView", false),
  ("Date", false),
  ("decodeURI", false),
  ("decodeURIComponent", false),
  ("DecompressionStream", false),
  ("DedicatedWorkerGlobalScope", false),
  ("Deno", false),
  ("dispatchEvent", false),
  ("DOMException", false),
  ("encodeURI", false),
  ("encodeURIComponent", false),
  ("Error", false),
  ("ErrorEvent", false),
  ("escape", false),
  ("eval", false),
  ("EvalError", false),
  ("Event", false),
  ("EventSource", false),
  ("EventTarget", false),
  ("fetch", false),
  ("File", false),
  ("FileReader", false),
  ("FinalizationRegistry", false),
  ("Float16Array", false),
  ("Float32Array", false),
  ("Float64Array", false),
  ("FormData", false),
  ("Function", false),
  ("globalThis", false),
  ("GPU", false),
  ("GPUAdapter", false),
  ("GPUAdapterInfo", false),
  ("GPUBindGroup", false),
  ("GPUBindGroupLayout", false),
  ("GPUBuffer", false),
  ("GPUBufferUsage", false),
  ("GPUCanvasContext", false),
  ("GPUColorWrite", false),
  ("GPUCommandBuffer", false),
  ("GPUCommandEncoder", false),
  ("GPUComputePassEncoder", false),
  ("GPUComputePipeline", false),
  ("GPUDevice", false),
  ("GPUDeviceLostInfo", false),
  ("GPUError", false),
  ("GPUMapMode", false),
  ("GPUOutOfMemoryError", false),
  ("GPUPipelineLayout", false),
  ("GPUQuerySet", false),
  ("GPUQueue", false),
  ("GPURenderBundle", false),
  ("GPURenderBundleEncoder", false),
  ("GPURenderPassEncoder", false),
  ("GPURenderPipeline", false),
  ("GPUSampler", false),
  ("GPUShaderModule", false),
  ("GPUShaderStage", false),
  ("GPUSupportedFeatures", false),
  ("GPUSupportedLimits", false),
  ("GPUTexture", false),
  ("GPUTextureUsage", false),
  ("GPUTextureView", false),
  ("GPUValidationError", false),
  ("hasOwnProperty", false),
  ("Headers", false),
  ("ImageBitmap", false),
  ("ImageData", false),
  ("Infinity", false),
  ("Intl", false),
  ("Int16Array", false),
  ("Int32Array", false),
  ("Int8Array", false),
  ("isFinite", false),
  ("isNaN", false),
  ("isPrototypeOf", false),
  ("JSON", false),
  ("localStorage", false),
  ("location", false),
  ("Location", false),
  ("Map", false),
  ("Math", false),
  ("MessageChannel", false),
  ("MessageEvent", false),
  ("MessagePort", false),
  ("NaN", false),
  ("navigator", false),
  ("Navigator", false),
  ("Number", false),
  ("Object", false),
  ("onbeforeunload", true),
  ("onerror", true),
  ("onload", true),
  ("onmessage", true),
  ("onmessageerror", true),
  ("onunhandledrejection", true),
  ("onunload", true),
  ("parseFloat", false),
  ("parseInt", false),
  ("performance", false),
  ("Performance", false),
  ("PerformanceEntry", false),
  ("PerformanceMark", false),
  ("PerformanceMeasure", false),
  ("Permissions", false),
  ("PermissionStatus", false),
  ("postMessage", true),
  ("ProgressEvent", false),
  ("Promise", false),
  ("PromiseRejectionEvent", false),
  ("prompt", false),
  ("propertyIsEnumerable", false),
  ("Proxy", false),
  ("queueMicrotask", false),
  ("RangeError", false),
  ("ReadableStream", false),
  ("ReadableByteStreamController", false),
  ("ReadableStreamBYOBReader", false),
  ("ReadableStreamBYOBRequest", false),
  ("ReadableStreamDefaultController", false),
  ("ReadableStreamDefaultReader", false),
  ("ReferenceError", false),
  ("Reflect", false),
  ("RegExp", false),
  ("removeEventListener", false),
  ("reportError", false),
  ("Request", false),
  ("Response", false),
  ("self", false),
  ("sessionStorage", false),
  ("Set", false),
  ("setInterval", false),
  ("setTimeout", false),
  ("SharedArrayBuffer", false),
  ("Storage", false),
  ("String", false),
  ("structuredClone", false),
  ("SubtleCrypto", false),
  ("Symbol", false),
  ("SyntaxError", false),
  ("TextDecoder", false),
  ("TextDecoderStream", false),
  ("TextEncoder", false),
  ("TextEncoderStream", false),
  ("TransformStream", false),
  ("TransformStreamDefaultController", false),
  ("toLocaleString", false),
  ("toString", false),
  ("TransformStream", false),
  ("TypeError", false),
  ("Uint16Array", false),
  ("Uint32Array", false),
  ("Uint8Array", false),
  ("Uint8ClampedArray", false),
  ("undefined", false),
  ("unescape", false),
  ("URIError", false),
  ("URL", false),
  ("URLPattern", false),
  ("URLSearchParams", false),
  ("valueOf", false),
  ("WeakMap", false),
  ("WeakRef", false),
  ("WeakSet", false),
  ("WebAssembly", false),
  ("WebSocket", false),
  ("WebSocketError", false),
  ("WebSocketStream", false),
  ("window", false),
  ("Window", false),
  ("Worker", false),
  ("WorkerGlobalScope", false),
  ("WorkerLocation", false),
  ("WorkerNavigator", false),
  ("WritableStream", false),
  ("WritableStreamDefaultController", false),
  ("WritableStreamDefaultWriter", false),
];
