//! Data of media query, such as media feature names.

/// Known media feature names.
// Copied from:
// https://github.com/stylelint/stylelint/blob/e6d6740c581c7289d18337f0fb78a776bf5f654c/lib/reference/keywordSets.js#L660
// https://github.com/stylelint/stylelint/blob/e6d6740c581c7289d18337f0fb78a776bf5f654c/lib/reference/keywordSets.js#L673
pub static MEDIA_FEATURE_NAMES: [&str; 52] = [
    "any-hover",
    "any-pointer",
    "aspect-ratio",
    "color",
    "color-gamut",
    "color-index",
    "display-mode",
    "dynamic-range",
    "forced-colors",
    "grid",
    "height",
    "hover",
    "inverted-colors",
    "light-level",
    "max-aspect-ratio",
    "max-color",
    "max-color-index",
    "max-height",
    "max-monochrome",
    "max-resolution",
    "max-width",
    "min-aspect-ratio",
    "min-color",
    "min-color-index",
    "min-height",
    "min-monochrome",
    "min-resolution",
    "min-width",
    "monochrome",
    "orientation",
    "overflow-block",
    "overflow-inline",
    "pointer",
    "prefers-color-scheme",
    "prefers-contrast",
    "prefers-reduced-motion",
    "prefers-reduced-transparency",
    "resolution",
    "scan",
    "scripting",
    "update",
    "video-dynamic-range",
    "width",
    // deprecated media features
    "device-aspect-ratio",
    "device-height",
    "device-width",
    "max-device-aspect-ratio",
    "max-device-height",
    "max-device-width",
    "min-device-aspect-ratio",
    "min-device-height",
    "min-device-width",
];
