//! Properties, property values, pseudo classes and pseudo elements that can be
//! prefixed by [Autoprefixer](https://github.com/postcss/autoprefixer).
//!
//! Copied from [Stylelint](https://github.com/stylelint/stylelint/blob/main/lib/utils/isAutoprefixable.js).

/// Autoprefixable properties.
pub static PROPERTIES: [&str; 142] = [
    "align-content",
    "align-items",
    "align-self",
    "animation",
    "animation-delay",
    "animation-direction",
    "animation-duration",
    "animation-fill-mode",
    "animation-iteration-count",
    "animation-name",
    "animation-play-state",
    "animation-timing-function",
    "appearance",
    "backdrop-filter",
    "backface-visibility",
    "background-clip",
    "background-origin",
    "background-size",
    "border-block-end",
    "border-block-start",
    "border-bottom-left-radius",
    "border-bottom-right-radius",
    "border-image",
    "border-inline-end",
    "border-inline-start",
    "border-radius",
    "border-top-left-radius",
    "border-top-right-radius",
    "box-decoration-break",
    "box-shadow",
    "box-sizing",
    "break-after",
    "break-before",
    "break-inside",
    "clip-path",
    "color-adjust",
    "column-count",
    "column-fill",
    "column-gap",
    "column-rule",
    "column-rule-color",
    "column-rule-style",
    "column-rule-width",
    "column-span",
    "column-width",
    "columns",
    "filter",
    "flex",
    "flex-basis",
    "flex-direction",
    "flex-flow",
    "flex-grow",
    "flex-shrink",
    "flex-wrap",
    "flow-from",
    "flow-into",
    "font-feature-settings",
    "font-kerning",
    "font-language-override",
    "font-variant-ligatures",
    "grid-area",
    "grid-column",
    "grid-column-align",
    "grid-column-end",
    "grid-column-start",
    "grid-row",
    "grid-row-align",
    "grid-row-end",
    "grid-row-start",
    "grid-template",
    "grid-template-areas",
    "grid-template-columns",
    "grid-template-rows",
    "hyphens",
    "image-rendering",
    "justify-content",
    "margin-block-end",
    "margin-block-start",
    "margin-inline-end",
    "margin-inline-start",
    "mask",
    "mask-border",
    "mask-border-outset",
    "mask-border-repeat",
    "mask-border-slice",
    "mask-border-source",
    "mask-border-width",
    "mask-clip",
    "mask-composite",
    "mask-image",
    "mask-origin",
    "mask-position",
    "mask-repeat",
    "mask-size",
    "object-fit",
    "object-position",
    "order",
    "overscroll-behavior",
    "padding-block-end",
    "padding-block-start",
    "padding-inline-end",
    "padding-inline-start",
    "perspective",
    "perspective-origin",
    "place-self",
    "region-fragment",
    "scroll-snap-coordinate",
    "scroll-snap-destination",
    "scroll-snap-points-x",
    "scroll-snap-points-y",
    "scroll-snap-type",
    "shape-image-threshold",
    "shape-margin",
    "shape-outside",
    "tab-size",
    "text-align-last",
    "text-decoration",
    "text-decoration-color",
    "text-decoration-line",
    "text-decoration-skip",
    "text-decoration-skip-ink",
    "text-decoration-style",
    "text-emphasis",
    "text-emphasis-color",
    "text-emphasis-position",
    "text-emphasis-style",
    "text-orientation",
    "text-overflow",
    "text-size-adjust",
    "text-spacing",
    "touch-action",
    "transform",
    "transform-origin",
    "transform-style",
    "transition",
    "transition-delay",
    "transition-duration",
    "transition-property",
    "transition-timing-function",
    "user-select",
    "writing-mode",
    // Not a standard property, just from `-ms-interpolation-mode`.
    "interpolation-mode",
];

/// Autoprefixable pseudo classes. All items are starting with vendor prefix.
pub static PSEUDO_CLASSES: [&str; 10] = [
    ":-moz-any-link",
    ":-moz-full-screen",
    ":-moz-placeholder",
    ":-moz-placeholder-shown",
    ":-moz-read-only",
    ":-moz-read-write",
    ":-ms-fullscreen",
    ":-ms-input-placeholder",
    ":-webkit-any-link",
    ":-webkit-full-screen",
];

/// Autoprefixable pseudo elements. All items are starting with vendor prefix.
pub static PSEUDO_ELEMENTS: [&str; 5] = [
    "::-moz-placeholder",
    "::-moz-selection",
    "::-ms-input-placeholder",
    "::-webkit-backdrop",
    "::-webkit-input-placeholder",
];

/// Autoprefixable at-rules. All items are starting with `@` and vendor prefix, except `@resolution`.
pub static AT_RULES: [&str; 8] = [
    "@-khtml-keyframes",
    "@-moz-keyframes",
    "@-ms-keyframes",
    "@-ms-viewport",
    "@-o-keyframes",
    "@-o-viewport",
    "@-webkit-keyframes",
    "@resolution",
];

/// Autoprefixable property values. All items are starting with vendor prefix.
pub static PROPERTY_VALUES: [&str; 56] = [
    "-moz-available",
    "-moz-box",
    "-moz-calc",
    "-moz-crisp-edges",
    "-moz-element",
    "-moz-fit-content",
    "-moz-grab",
    "-moz-grabbing",
    "-moz-inline-box",
    "-moz-isolate",
    "-moz-isolate-override",
    "-moz-linear-gradient",
    "-moz-max-content",
    "-moz-min-content",
    "-moz-plaintext",
    "-moz-radial-gradient",
    "-moz-repeating-linear-gradient",
    "-moz-repeating-radial-gradient",
    "-moz-zoom-in",
    "-moz-zoom-out",
    "-ms-flexbox",
    "-ms-grid",
    "-ms-inline-flexbox",
    "-ms-inline-grid",
    "-ms-linear-gradient",
    "-ms-radial-gradient",
    "-ms-repeating-linear-gradient",
    "-ms-repeating-radial-gradient",
    "-o-linear-gradient",
    "-o-pixelated",
    "-o-radial-gradient",
    "-o-repeating-linear-gradient",
    "-o-repeating-radial-gradient",
    "-webkit-box",
    "-webkit-calc",
    "-webkit-cross-fade",
    "-webkit-fill-available",
    "-webkit-filter",
    "-webkit-fit-content",
    "-webkit-flex",
    "-webkit-grab",
    "-webkit-grabbing",
    "-webkit-image-set",
    "-webkit-inline-box",
    "-webkit-inline-flex",
    "-webkit-isolate",
    "-webkit-linear-gradient",
    "-webkit-max-content",
    "-webkit-min-content",
    "-webkit-optimize-contrast",
    "-webkit-radial-gradient",
    "-webkit-repeating-linear-gradient",
    "-webkit-repeating-radial-gradient",
    "-webkit-sticky",
    "-webkit-zoom-in",
    "-webkit-zoom-out",
];
